import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StaticConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/time/r/static#id Static#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/time/r/static#rfc3339 Static#rfc3339}
    */
    readonly rfc3339?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/time/r/static#triggers Static#triggers}
    */
    readonly triggers?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/time/r/static time_static}
*/
export declare class Static extends cdktf.TerraformResource {
    static readonly tfResourceType = "time_static";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/time/r/static time_static} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticConfig = {}
    */
    constructor(scope: Construct, id: string, config?: StaticConfig);
    get day(): number;
    get hour(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get minute(): number;
    get month(): number;
    private _rfc3339?;
    get rfc3339(): string;
    set rfc3339(value: string);
    resetRfc3339(): void;
    get rfc3339Input(): string | undefined;
    get second(): number;
    private _triggers?;
    get triggers(): {
        [key: string]: string;
    };
    set triggers(value: {
        [key: string]: string;
    });
    resetTriggers(): void;
    get triggersInput(): {
        [key: string]: string;
    } | undefined;
    get unix(): number;
    get year(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
