import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementEmailTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#api_management_name ApiManagementEmailTemplate#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#body ApiManagementEmailTemplate#body}.
     *
     * @stability stable
     */
    readonly body: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#resource_group_name ApiManagementEmailTemplate#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#subject ApiManagementEmailTemplate#subject}.
     *
     * @stability stable
     */
    readonly subject: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#template_name ApiManagementEmailTemplate#template_name}.
     *
     * @stability stable
     */
    readonly templateName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#timeouts ApiManagementEmailTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementEmailTemplateTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementEmailTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#create ApiManagementEmailTemplate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#delete ApiManagementEmailTemplate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#read ApiManagementEmailTemplate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html#update ApiManagementEmailTemplate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementEmailTemplateTimeoutsToTerraform(struct?: ApiManagementEmailTemplateTimeoutsOutputReference | ApiManagementEmailTemplateTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementEmailTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementEmailTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementEmailTemplateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html azurerm_api_management_email_template}.
 *
 * @stability stable
 */
export declare class ApiManagementEmailTemplate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_email_template.html azurerm_api_management_email_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementEmailTemplateConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    set subject(value: string);
    /**
     * @stability stable
     */
    get subjectInput(): string | undefined;
    private _templateName?;
    /**
     * @stability stable
     */
    get templateName(): string;
    /**
     * @stability stable
     */
    set templateName(value: string);
    /**
     * @stability stable
     */
    get templateNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get title(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementEmailTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementEmailTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementEmailTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
