import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#api_management_id ApiManagementPolicyA#api_management_id}.
     *
     * @stability stable
     */
    readonly apiManagementId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#xml_content ApiManagementPolicyA#xml_content}.
     *
     * @stability stable
     */
    readonly xmlContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#xml_link ApiManagementPolicyA#xml_link}.
     *
     * @stability stable
     */
    readonly xmlLink?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#timeouts ApiManagementPolicyA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#create ApiManagementPolicyA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#delete ApiManagementPolicyA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#read ApiManagementPolicyA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html#update ApiManagementPolicyA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementPolicyTimeoutsToTerraform(struct?: ApiManagementPolicyTimeoutsOutputReference | ApiManagementPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html azurerm_api_management_policy}.
 *
 * @stability stable
 */
export declare class ApiManagementPolicyA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_policy.html azurerm_api_management_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementPolicyAConfig);
    private _apiManagementId?;
    /**
     * @stability stable
     */
    get apiManagementId(): string;
    /**
     * @stability stable
     */
    set apiManagementId(value: string);
    /**
     * @stability stable
     */
    get apiManagementIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _xmlContent?;
    /**
     * @stability stable
     */
    get xmlContent(): string;
    /**
     * @stability stable
     */
    set xmlContent(value: string);
    /**
     * @stability stable
     */
    resetXmlContent(): void;
    /**
     * @stability stable
     */
    get xmlContentInput(): string | undefined;
    private _xmlLink?;
    /**
     * @stability stable
     */
    get xmlLink(): string;
    /**
     * @stability stable
     */
    set xmlLink(value: string);
    /**
     * @stability stable
     */
    resetXmlLink(): void;
    /**
     * @stability stable
     */
    get xmlLinkInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
