import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#allowed_user_ip_cidrs AppServiceEnvironment#allowed_user_ip_cidrs}.
     *
     * @stability stable
     */
    readonly allowedUserIpCidrs?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#front_end_scale_factor AppServiceEnvironment#front_end_scale_factor}.
     *
     * @stability stable
     */
    readonly frontEndScaleFactor?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#internal_load_balancing_mode AppServiceEnvironment#internal_load_balancing_mode}.
     *
     * @stability stable
     */
    readonly internalLoadBalancingMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#name AppServiceEnvironment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#pricing_tier AppServiceEnvironment#pricing_tier}.
     *
     * @stability stable
     */
    readonly pricingTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#resource_group_name AppServiceEnvironment#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#subnet_id AppServiceEnvironment#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#tags AppServiceEnvironment#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#user_whitelisted_ip_ranges AppServiceEnvironment#user_whitelisted_ip_ranges}.
     *
     * @stability stable
     */
    readonly userWhitelistedIpRanges?: string[];
    /**
     * cluster_setting block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#cluster_setting AppServiceEnvironment#cluster_setting}
     *
     * @stability stable
     */
    readonly clusterSetting?: AppServiceEnvironmentClusterSetting[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#timeouts AppServiceEnvironment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceEnvironmentTimeouts;
}
/**
 * @stability stable
 */
export interface AppServiceEnvironmentClusterSetting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#name AppServiceEnvironment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#value AppServiceEnvironment#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function appServiceEnvironmentClusterSettingToTerraform(struct?: AppServiceEnvironmentClusterSetting): any;
/**
 * @stability stable
 */
export interface AppServiceEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#create AppServiceEnvironment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#delete AppServiceEnvironment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#read AppServiceEnvironment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html#update AppServiceEnvironment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceEnvironmentTimeoutsToTerraform(struct?: AppServiceEnvironmentTimeoutsOutputReference | AppServiceEnvironmentTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceEnvironmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceEnvironmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html azurerm_app_service_environment}.
 *
 * @stability stable
 */
export declare class AppServiceEnvironment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment.html azurerm_app_service_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceEnvironmentConfig);
    private _allowedUserIpCidrs?;
    /**
     * @stability stable
     */
    get allowedUserIpCidrs(): string[];
    /**
     * @stability stable
     */
    set allowedUserIpCidrs(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedUserIpCidrs(): void;
    /**
     * @stability stable
     */
    get allowedUserIpCidrsInput(): string[] | undefined;
    private _frontEndScaleFactor?;
    /**
     * @stability stable
     */
    get frontEndScaleFactor(): number;
    /**
     * @stability stable
     */
    set frontEndScaleFactor(value: number);
    /**
     * @stability stable
     */
    resetFrontEndScaleFactor(): void;
    /**
     * @stability stable
     */
    get frontEndScaleFactorInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get internalIpAddress(): string;
    private _internalLoadBalancingMode?;
    /**
     * @stability stable
     */
    get internalLoadBalancingMode(): string;
    /**
     * @stability stable
     */
    set internalLoadBalancingMode(value: string);
    /**
     * @stability stable
     */
    resetInternalLoadBalancingMode(): void;
    /**
     * @stability stable
     */
    get internalLoadBalancingModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string[];
    private _pricingTier?;
    /**
     * @stability stable
     */
    get pricingTier(): string;
    /**
     * @stability stable
     */
    set pricingTier(value: string);
    /**
     * @stability stable
     */
    resetPricingTier(): void;
    /**
     * @stability stable
     */
    get pricingTierInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetResourceGroupName(): void;
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceIpAddress(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _userWhitelistedIpRanges?;
    /**
     * @stability stable
     */
    get userWhitelistedIpRanges(): string[];
    /**
     * @stability stable
     */
    set userWhitelistedIpRanges(value: string[]);
    /**
     * @stability stable
     */
    resetUserWhitelistedIpRanges(): void;
    /**
     * @stability stable
     */
    get userWhitelistedIpRangesInput(): string[] | undefined;
    private _clusterSetting?;
    /**
     * @stability stable
     */
    get clusterSetting(): AppServiceEnvironmentClusterSetting[];
    /**
     * @stability stable
     */
    set clusterSetting(value: AppServiceEnvironmentClusterSetting[]);
    /**
     * @stability stable
     */
    resetClusterSetting(): void;
    /**
     * @stability stable
     */
    get clusterSettingInput(): AppServiceEnvironmentClusterSetting[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceEnvironmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceEnvironmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceEnvironmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
