import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationInsightsWebTestConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#application_insights_id ApplicationInsightsWebTest#application_insights_id}.
     *
     * @stability stable
     */
    readonly applicationInsightsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#configuration ApplicationInsightsWebTest#configuration}.
     *
     * @stability stable
     */
    readonly configuration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#description ApplicationInsightsWebTest#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#enabled ApplicationInsightsWebTest#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#frequency ApplicationInsightsWebTest#frequency}.
     *
     * @stability stable
     */
    readonly frequency?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#geo_locations ApplicationInsightsWebTest#geo_locations}.
     *
     * @stability stable
     */
    readonly geoLocations: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#kind ApplicationInsightsWebTest#kind}.
     *
     * @stability stable
     */
    readonly kind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#location ApplicationInsightsWebTest#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#name ApplicationInsightsWebTest#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#resource_group_name ApplicationInsightsWebTest#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#retry_enabled ApplicationInsightsWebTest#retry_enabled}.
     *
     * @stability stable
     */
    readonly retryEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#tags ApplicationInsightsWebTest#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#timeout ApplicationInsightsWebTest#timeout}.
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#timeouts ApplicationInsightsWebTest#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationInsightsWebTestTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationInsightsWebTestTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#create ApplicationInsightsWebTest#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#delete ApplicationInsightsWebTest#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#read ApplicationInsightsWebTest#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html#update ApplicationInsightsWebTest#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationInsightsWebTestTimeoutsToTerraform(struct?: ApplicationInsightsWebTestTimeoutsOutputReference | ApplicationInsightsWebTestTimeouts): any;
/**
 * @stability stable
 */
export declare class ApplicationInsightsWebTestTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationInsightsWebTestTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationInsightsWebTestTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html azurerm_application_insights_web_test}.
 *
 * @stability stable
 */
export declare class ApplicationInsightsWebTest extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_web_test.html azurerm_application_insights_web_test} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationInsightsWebTestConfig);
    private _applicationInsightsId?;
    /**
     * @stability stable
     */
    get applicationInsightsId(): string;
    /**
     * @stability stable
     */
    set applicationInsightsId(value: string);
    /**
     * @stability stable
     */
    get applicationInsightsIdInput(): string | undefined;
    private _configuration?;
    /**
     * @stability stable
     */
    get configuration(): string;
    /**
     * @stability stable
     */
    set configuration(value: string);
    /**
     * @stability stable
     */
    get configurationInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): number;
    /**
     * @stability stable
     */
    set frequency(value: number);
    /**
     * @stability stable
     */
    resetFrequency(): void;
    /**
     * @stability stable
     */
    get frequencyInput(): number | undefined;
    private _geoLocations?;
    /**
     * @stability stable
     */
    get geoLocations(): string[];
    /**
     * @stability stable
     */
    set geoLocations(value: string[]);
    /**
     * @stability stable
     */
    get geoLocationsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _retryEnabled?;
    /**
     * @stability stable
     */
    get retryEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set retryEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRetryEnabled(): void;
    /**
     * @stability stable
     */
    get retryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get syntheticMonitorId(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationInsightsWebTestTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationInsightsWebTestTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationInsightsWebTestTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
