import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BotChannelDirectLineSpeechConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#bot_name BotChannelDirectLineSpeech#bot_name}.
     *
     * @stability stable
     */
    readonly botName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#cognitive_service_access_key BotChannelDirectLineSpeech#cognitive_service_access_key}.
     *
     * @stability stable
     */
    readonly cognitiveServiceAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#cognitive_service_location BotChannelDirectLineSpeech#cognitive_service_location}.
     *
     * @stability stable
     */
    readonly cognitiveServiceLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#custom_speech_model_id BotChannelDirectLineSpeech#custom_speech_model_id}.
     *
     * @stability stable
     */
    readonly customSpeechModelId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#custom_voice_deployment_id BotChannelDirectLineSpeech#custom_voice_deployment_id}.
     *
     * @stability stable
     */
    readonly customVoiceDeploymentId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#location BotChannelDirectLineSpeech#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#resource_group_name BotChannelDirectLineSpeech#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#timeouts BotChannelDirectLineSpeech#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BotChannelDirectLineSpeechTimeouts;
}
/**
 * @stability stable
 */
export interface BotChannelDirectLineSpeechTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#create BotChannelDirectLineSpeech#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#delete BotChannelDirectLineSpeech#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#read BotChannelDirectLineSpeech#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html#update BotChannelDirectLineSpeech#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function botChannelDirectLineSpeechTimeoutsToTerraform(struct?: BotChannelDirectLineSpeechTimeoutsOutputReference | BotChannelDirectLineSpeechTimeouts): any;
/**
 * @stability stable
 */
export declare class BotChannelDirectLineSpeechTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BotChannelDirectLineSpeechTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BotChannelDirectLineSpeechTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html azurerm_bot_channel_direct_line_speech}.
 *
 * @stability stable
 */
export declare class BotChannelDirectLineSpeech extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_direct_line_speech.html azurerm_bot_channel_direct_line_speech} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BotChannelDirectLineSpeechConfig);
    private _botName?;
    /**
     * @stability stable
     */
    get botName(): string;
    /**
     * @stability stable
     */
    set botName(value: string);
    /**
     * @stability stable
     */
    get botNameInput(): string | undefined;
    private _cognitiveServiceAccessKey?;
    /**
     * @stability stable
     */
    get cognitiveServiceAccessKey(): string;
    /**
     * @stability stable
     */
    set cognitiveServiceAccessKey(value: string);
    /**
     * @stability stable
     */
    get cognitiveServiceAccessKeyInput(): string | undefined;
    private _cognitiveServiceLocation?;
    /**
     * @stability stable
     */
    get cognitiveServiceLocation(): string;
    /**
     * @stability stable
     */
    set cognitiveServiceLocation(value: string);
    /**
     * @stability stable
     */
    get cognitiveServiceLocationInput(): string | undefined;
    private _customSpeechModelId?;
    /**
     * @stability stable
     */
    get customSpeechModelId(): string;
    /**
     * @stability stable
     */
    set customSpeechModelId(value: string);
    /**
     * @stability stable
     */
    resetCustomSpeechModelId(): void;
    /**
     * @stability stable
     */
    get customSpeechModelIdInput(): string | undefined;
    private _customVoiceDeploymentId?;
    /**
     * @stability stable
     */
    get customVoiceDeploymentId(): string;
    /**
     * @stability stable
     */
    set customVoiceDeploymentId(value: string);
    /**
     * @stability stable
     */
    resetCustomVoiceDeploymentId(): void;
    /**
     * @stability stable
     */
    get customVoiceDeploymentIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BotChannelDirectLineSpeechTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BotChannelDirectLineSpeechTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BotChannelDirectLineSpeechTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
