import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#dns_name_label ContainerGroup#dns_name_label}.
     *
     * @stability stable
     */
    readonly dnsNameLabel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#exposed_port ContainerGroup#exposed_port}.
     *
     * @stability stable
     */
    readonly exposedPort?: ContainerGroupExposedPort[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#ip_address_type ContainerGroup#ip_address_type}.
     *
     * @stability stable
     */
    readonly ipAddressType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#location ContainerGroup#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#name ContainerGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#network_profile_id ContainerGroup#network_profile_id}.
     *
     * @stability stable
     */
    readonly networkProfileId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#os_type ContainerGroup#os_type}.
     *
     * @stability stable
     */
    readonly osType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#resource_group_name ContainerGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#restart_policy ContainerGroup#restart_policy}.
     *
     * @stability stable
     */
    readonly restartPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#tags ContainerGroup#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * container block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#container ContainerGroup#container}
     *
     * @stability stable
     */
    readonly container: ContainerGroupContainer[];
    /**
     * diagnostics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#diagnostics ContainerGroup#diagnostics}
     *
     * @stability stable
     */
    readonly diagnostics?: ContainerGroupDiagnostics;
    /**
     * dns_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#dns_config ContainerGroup#dns_config}
     *
     * @stability stable
     */
    readonly dnsConfig?: ContainerGroupDnsConfig;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#identity ContainerGroup#identity}
     *
     * @stability stable
     */
    readonly identity?: ContainerGroupIdentity;
    /**
     * image_registry_credential block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#image_registry_credential ContainerGroup#image_registry_credential}
     *
     * @stability stable
     */
    readonly imageRegistryCredential?: ContainerGroupImageRegistryCredential[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#timeouts ContainerGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ContainerGroupExposedPort {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#port ContainerGroup#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#protocol ContainerGroup#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
}
export declare function containerGroupExposedPortToTerraform(struct?: ContainerGroupExposedPort): any;
/**
 * @stability stable
 */
export interface ContainerGroupContainerGpu {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#count ContainerGroup#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#sku ContainerGroup#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
}
export declare function containerGroupContainerGpuToTerraform(struct?: ContainerGroupContainerGpuOutputReference | ContainerGroupContainerGpu): any;
/**
 * @stability stable
 */
export declare class ContainerGroupContainerGpuOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupContainerGpu | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupContainerGpu | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupContainerLivenessProbeHttpGet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#path ContainerGroup#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#port ContainerGroup#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#scheme ContainerGroup#scheme}.
     *
     * @stability stable
     */
    readonly scheme?: string;
}
export declare function containerGroupContainerLivenessProbeHttpGetToTerraform(struct?: ContainerGroupContainerLivenessProbeHttpGet): any;
/**
 * @stability stable
 */
export interface ContainerGroupContainerLivenessProbe {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#exec ContainerGroup#exec}.
     *
     * @stability stable
     */
    readonly exec?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#failure_threshold ContainerGroup#failure_threshold}.
     *
     * @stability stable
     */
    readonly failureThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#initial_delay_seconds ContainerGroup#initial_delay_seconds}.
     *
     * @stability stable
     */
    readonly initialDelaySeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#period_seconds ContainerGroup#period_seconds}.
     *
     * @stability stable
     */
    readonly periodSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#success_threshold ContainerGroup#success_threshold}.
     *
     * @stability stable
     */
    readonly successThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#timeout_seconds ContainerGroup#timeout_seconds}.
     *
     * @stability stable
     */
    readonly timeoutSeconds?: number;
    /**
     * http_get block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#http_get ContainerGroup#http_get}
     *
     * @stability stable
     */
    readonly httpGet?: ContainerGroupContainerLivenessProbeHttpGet[];
}
export declare function containerGroupContainerLivenessProbeToTerraform(struct?: ContainerGroupContainerLivenessProbeOutputReference | ContainerGroupContainerLivenessProbe): any;
/**
 * @stability stable
 */
export declare class ContainerGroupContainerLivenessProbeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupContainerLivenessProbe | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupContainerLivenessProbe | undefined);
    private _exec?;
    /**
     * @stability stable
     */
    get exec(): string[];
    /**
     * @stability stable
     */
    set exec(value: string[]);
    /**
     * @stability stable
     */
    resetExec(): void;
    /**
     * @stability stable
     */
    get execInput(): string[] | undefined;
    private _failureThreshold?;
    /**
     * @stability stable
     */
    get failureThreshold(): number;
    /**
     * @stability stable
     */
    set failureThreshold(value: number);
    /**
     * @stability stable
     */
    resetFailureThreshold(): void;
    /**
     * @stability stable
     */
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    /**
     * @stability stable
     */
    get initialDelaySeconds(): number;
    /**
     * @stability stable
     */
    set initialDelaySeconds(value: number);
    /**
     * @stability stable
     */
    resetInitialDelaySeconds(): void;
    /**
     * @stability stable
     */
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    /**
     * @stability stable
     */
    get periodSeconds(): number;
    /**
     * @stability stable
     */
    set periodSeconds(value: number);
    /**
     * @stability stable
     */
    resetPeriodSeconds(): void;
    /**
     * @stability stable
     */
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    /**
     * @stability stable
     */
    get successThreshold(): number;
    /**
     * @stability stable
     */
    set successThreshold(value: number);
    /**
     * @stability stable
     */
    resetSuccessThreshold(): void;
    /**
     * @stability stable
     */
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    /**
     * @stability stable
     */
    get timeoutSeconds(): number;
    /**
     * @stability stable
     */
    set timeoutSeconds(value: number);
    /**
     * @stability stable
     */
    resetTimeoutSeconds(): void;
    /**
     * @stability stable
     */
    get timeoutSecondsInput(): number | undefined;
    private _httpGet?;
    /**
     * @stability stable
     */
    get httpGet(): ContainerGroupContainerLivenessProbeHttpGet[];
    /**
     * @stability stable
     */
    set httpGet(value: ContainerGroupContainerLivenessProbeHttpGet[]);
    /**
     * @stability stable
     */
    resetHttpGet(): void;
    /**
     * @stability stable
     */
    get httpGetInput(): ContainerGroupContainerLivenessProbeHttpGet[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupContainerPorts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#port ContainerGroup#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#protocol ContainerGroup#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
}
export declare function containerGroupContainerPortsToTerraform(struct?: ContainerGroupContainerPorts): any;
/**
 * @stability stable
 */
export interface ContainerGroupContainerReadinessProbeHttpGet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#path ContainerGroup#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#port ContainerGroup#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#scheme ContainerGroup#scheme}.
     *
     * @stability stable
     */
    readonly scheme?: string;
}
export declare function containerGroupContainerReadinessProbeHttpGetToTerraform(struct?: ContainerGroupContainerReadinessProbeHttpGet): any;
/**
 * @stability stable
 */
export interface ContainerGroupContainerReadinessProbe {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#exec ContainerGroup#exec}.
     *
     * @stability stable
     */
    readonly exec?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#failure_threshold ContainerGroup#failure_threshold}.
     *
     * @stability stable
     */
    readonly failureThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#initial_delay_seconds ContainerGroup#initial_delay_seconds}.
     *
     * @stability stable
     */
    readonly initialDelaySeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#period_seconds ContainerGroup#period_seconds}.
     *
     * @stability stable
     */
    readonly periodSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#success_threshold ContainerGroup#success_threshold}.
     *
     * @stability stable
     */
    readonly successThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#timeout_seconds ContainerGroup#timeout_seconds}.
     *
     * @stability stable
     */
    readonly timeoutSeconds?: number;
    /**
     * http_get block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#http_get ContainerGroup#http_get}
     *
     * @stability stable
     */
    readonly httpGet?: ContainerGroupContainerReadinessProbeHttpGet[];
}
export declare function containerGroupContainerReadinessProbeToTerraform(struct?: ContainerGroupContainerReadinessProbeOutputReference | ContainerGroupContainerReadinessProbe): any;
/**
 * @stability stable
 */
export declare class ContainerGroupContainerReadinessProbeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupContainerReadinessProbe | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupContainerReadinessProbe | undefined);
    private _exec?;
    /**
     * @stability stable
     */
    get exec(): string[];
    /**
     * @stability stable
     */
    set exec(value: string[]);
    /**
     * @stability stable
     */
    resetExec(): void;
    /**
     * @stability stable
     */
    get execInput(): string[] | undefined;
    private _failureThreshold?;
    /**
     * @stability stable
     */
    get failureThreshold(): number;
    /**
     * @stability stable
     */
    set failureThreshold(value: number);
    /**
     * @stability stable
     */
    resetFailureThreshold(): void;
    /**
     * @stability stable
     */
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    /**
     * @stability stable
     */
    get initialDelaySeconds(): number;
    /**
     * @stability stable
     */
    set initialDelaySeconds(value: number);
    /**
     * @stability stable
     */
    resetInitialDelaySeconds(): void;
    /**
     * @stability stable
     */
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    /**
     * @stability stable
     */
    get periodSeconds(): number;
    /**
     * @stability stable
     */
    set periodSeconds(value: number);
    /**
     * @stability stable
     */
    resetPeriodSeconds(): void;
    /**
     * @stability stable
     */
    get periodSecondsInput(): number | undefined;
    private _successThreshold?;
    /**
     * @stability stable
     */
    get successThreshold(): number;
    /**
     * @stability stable
     */
    set successThreshold(value: number);
    /**
     * @stability stable
     */
    resetSuccessThreshold(): void;
    /**
     * @stability stable
     */
    get successThresholdInput(): number | undefined;
    private _timeoutSeconds?;
    /**
     * @stability stable
     */
    get timeoutSeconds(): number;
    /**
     * @stability stable
     */
    set timeoutSeconds(value: number);
    /**
     * @stability stable
     */
    resetTimeoutSeconds(): void;
    /**
     * @stability stable
     */
    get timeoutSecondsInput(): number | undefined;
    private _httpGet?;
    /**
     * @stability stable
     */
    get httpGet(): ContainerGroupContainerReadinessProbeHttpGet[];
    /**
     * @stability stable
     */
    set httpGet(value: ContainerGroupContainerReadinessProbeHttpGet[]);
    /**
     * @stability stable
     */
    resetHttpGet(): void;
    /**
     * @stability stable
     */
    get httpGetInput(): ContainerGroupContainerReadinessProbeHttpGet[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupContainerVolumeGitRepo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#directory ContainerGroup#directory}.
     *
     * @stability stable
     */
    readonly directory?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#revision ContainerGroup#revision}.
     *
     * @stability stable
     */
    readonly revision?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#url ContainerGroup#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function containerGroupContainerVolumeGitRepoToTerraform(struct?: ContainerGroupContainerVolumeGitRepoOutputReference | ContainerGroupContainerVolumeGitRepo): any;
/**
 * @stability stable
 */
export declare class ContainerGroupContainerVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupContainerVolumeGitRepo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupContainerVolumeGitRepo | undefined);
    private _directory?;
    /**
     * @stability stable
     */
    get directory(): string;
    /**
     * @stability stable
     */
    set directory(value: string);
    /**
     * @stability stable
     */
    resetDirectory(): void;
    /**
     * @stability stable
     */
    get directoryInput(): string | undefined;
    private _revision?;
    /**
     * @stability stable
     */
    get revision(): string;
    /**
     * @stability stable
     */
    set revision(value: string);
    /**
     * @stability stable
     */
    resetRevision(): void;
    /**
     * @stability stable
     */
    get revisionInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupContainerVolume {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#empty_dir ContainerGroup#empty_dir}.
     *
     * @stability stable
     */
    readonly emptyDir?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#mount_path ContainerGroup#mount_path}.
     *
     * @stability stable
     */
    readonly mountPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#name ContainerGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#read_only ContainerGroup#read_only}.
     *
     * @stability stable
     */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#secret ContainerGroup#secret}.
     *
     * @stability stable
     */
    readonly secret?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#share_name ContainerGroup#share_name}.
     *
     * @stability stable
     */
    readonly shareName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#storage_account_key ContainerGroup#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#storage_account_name ContainerGroup#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName?: string;
    /**
     * git_repo block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#git_repo ContainerGroup#git_repo}
     *
     * @stability stable
     */
    readonly gitRepo?: ContainerGroupContainerVolumeGitRepo;
}
export declare function containerGroupContainerVolumeToTerraform(struct?: ContainerGroupContainerVolume): any;
/**
 * @stability stable
 */
export interface ContainerGroupContainer {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#commands ContainerGroup#commands}.
     *
     * @stability stable
     */
    readonly commands?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#cpu ContainerGroup#cpu}.
     *
     * @stability stable
     */
    readonly cpu: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#environment_variables ContainerGroup#environment_variables}.
     *
     * @stability stable
     */
    readonly environmentVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#image ContainerGroup#image}.
     *
     * @stability stable
     */
    readonly image: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#memory ContainerGroup#memory}.
     *
     * @stability stable
     */
    readonly memory: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#name ContainerGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#secure_environment_variables ContainerGroup#secure_environment_variables}.
     *
     * @stability stable
     */
    readonly secureEnvironmentVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * gpu block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#gpu ContainerGroup#gpu}
     *
     * @stability stable
     */
    readonly gpu?: ContainerGroupContainerGpu;
    /**
     * liveness_probe block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#liveness_probe ContainerGroup#liveness_probe}
     *
     * @stability stable
     */
    readonly livenessProbe?: ContainerGroupContainerLivenessProbe;
    /**
     * ports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#ports ContainerGroup#ports}
     *
     * @stability stable
     */
    readonly ports?: ContainerGroupContainerPorts[];
    /**
     * readiness_probe block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#readiness_probe ContainerGroup#readiness_probe}
     *
     * @stability stable
     */
    readonly readinessProbe?: ContainerGroupContainerReadinessProbe;
    /**
     * volume block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#volume ContainerGroup#volume}
     *
     * @stability stable
     */
    readonly volume?: ContainerGroupContainerVolume[];
}
export declare function containerGroupContainerToTerraform(struct?: ContainerGroupContainer): any;
/**
 * @stability stable
 */
export interface ContainerGroupDiagnosticsLogAnalytics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#log_type ContainerGroup#log_type}.
     *
     * @stability stable
     */
    readonly logType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#metadata ContainerGroup#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#workspace_id ContainerGroup#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#workspace_key ContainerGroup#workspace_key}.
     *
     * @stability stable
     */
    readonly workspaceKey: string;
}
export declare function containerGroupDiagnosticsLogAnalyticsToTerraform(struct?: ContainerGroupDiagnosticsLogAnalyticsOutputReference | ContainerGroupDiagnosticsLogAnalytics): any;
/**
 * @stability stable
 */
export declare class ContainerGroupDiagnosticsLogAnalyticsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupDiagnosticsLogAnalytics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupDiagnosticsLogAnalytics | undefined);
    private _logType?;
    /**
     * @stability stable
     */
    get logType(): string;
    /**
     * @stability stable
     */
    set logType(value: string);
    /**
     * @stability stable
     */
    resetLogType(): void;
    /**
     * @stability stable
     */
    get logTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    set workspaceId(value: string);
    /**
     * @stability stable
     */
    get workspaceIdInput(): string | undefined;
    private _workspaceKey?;
    /**
     * @stability stable
     */
    get workspaceKey(): string;
    /**
     * @stability stable
     */
    set workspaceKey(value: string);
    /**
     * @stability stable
     */
    get workspaceKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupDiagnostics {
    /**
     * log_analytics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#log_analytics ContainerGroup#log_analytics}
     *
     * @stability stable
     */
    readonly logAnalytics: ContainerGroupDiagnosticsLogAnalytics;
}
export declare function containerGroupDiagnosticsToTerraform(struct?: ContainerGroupDiagnosticsOutputReference | ContainerGroupDiagnostics): any;
/**
 * @stability stable
 */
export declare class ContainerGroupDiagnosticsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupDiagnostics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupDiagnostics | undefined);
    private _logAnalytics;
    /**
     * @stability stable
     */
    get logAnalytics(): ContainerGroupDiagnosticsLogAnalyticsOutputReference;
    /**
     * @stability stable
     */
    putLogAnalytics(value: ContainerGroupDiagnosticsLogAnalytics): void;
    /**
     * @stability stable
     */
    get logAnalyticsInput(): ContainerGroupDiagnosticsLogAnalytics | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupDnsConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#nameservers ContainerGroup#nameservers}.
     *
     * @stability stable
     */
    readonly nameservers: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#options ContainerGroup#options}.
     *
     * @stability stable
     */
    readonly options: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#search_domains ContainerGroup#search_domains}.
     *
     * @stability stable
     */
    readonly searchDomains: string[];
}
export declare function containerGroupDnsConfigToTerraform(struct?: ContainerGroupDnsConfigOutputReference | ContainerGroupDnsConfig): any;
/**
 * @stability stable
 */
export declare class ContainerGroupDnsConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupDnsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupDnsConfig | undefined);
    private _nameservers?;
    /**
     * @stability stable
     */
    get nameservers(): string[];
    /**
     * @stability stable
     */
    set nameservers(value: string[]);
    /**
     * @stability stable
     */
    get nameserversInput(): string[] | undefined;
    private _options?;
    /**
     * @stability stable
     */
    get options(): string[];
    /**
     * @stability stable
     */
    set options(value: string[]);
    /**
     * @stability stable
     */
    get optionsInput(): string[] | undefined;
    private _searchDomains?;
    /**
     * @stability stable
     */
    get searchDomains(): string[];
    /**
     * @stability stable
     */
    set searchDomains(value: string[]);
    /**
     * @stability stable
     */
    get searchDomainsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#identity_ids ContainerGroup#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#type ContainerGroup#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function containerGroupIdentityToTerraform(struct?: ContainerGroupIdentityOutputReference | ContainerGroupIdentity): any;
/**
 * @stability stable
 */
export declare class ContainerGroupIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerGroupImageRegistryCredential {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#password ContainerGroup#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#server ContainerGroup#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#username ContainerGroup#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function containerGroupImageRegistryCredentialToTerraform(struct?: ContainerGroupImageRegistryCredential): any;
/**
 * @stability stable
 */
export interface ContainerGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#create ContainerGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#delete ContainerGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#read ContainerGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html#update ContainerGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function containerGroupTimeoutsToTerraform(struct?: ContainerGroupTimeoutsOutputReference | ContainerGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class ContainerGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html azurerm_container_group}.
 *
 * @stability stable
 */
export declare class ContainerGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_group.html azurerm_container_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerGroupConfig);
    private _dnsNameLabel?;
    /**
     * @stability stable
     */
    get dnsNameLabel(): string;
    /**
     * @stability stable
     */
    set dnsNameLabel(value: string);
    /**
     * @stability stable
     */
    resetDnsNameLabel(): void;
    /**
     * @stability stable
     */
    get dnsNameLabelInput(): string | undefined;
    private _exposedPort?;
    /**
     * @stability stable
     */
    get exposedPort(): ContainerGroupExposedPort[];
    /**
     * @stability stable
     */
    set exposedPort(value: ContainerGroupExposedPort[]);
    /**
     * @stability stable
     */
    resetExposedPort(): void;
    /**
     * @stability stable
     */
    get exposedPortInput(): ContainerGroupExposedPort[] | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    private _ipAddressType?;
    /**
     * @stability stable
     */
    get ipAddressType(): string;
    /**
     * @stability stable
     */
    set ipAddressType(value: string);
    /**
     * @stability stable
     */
    resetIpAddressType(): void;
    /**
     * @stability stable
     */
    get ipAddressTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkProfileId?;
    /**
     * @stability stable
     */
    get networkProfileId(): string;
    /**
     * @stability stable
     */
    set networkProfileId(value: string);
    /**
     * @stability stable
     */
    resetNetworkProfileId(): void;
    /**
     * @stability stable
     */
    get networkProfileIdInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _restartPolicy?;
    /**
     * @stability stable
     */
    get restartPolicy(): string;
    /**
     * @stability stable
     */
    set restartPolicy(value: string);
    /**
     * @stability stable
     */
    resetRestartPolicy(): void;
    /**
     * @stability stable
     */
    get restartPolicyInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _container?;
    /**
     * @stability stable
     */
    get container(): ContainerGroupContainer[];
    /**
     * @stability stable
     */
    set container(value: ContainerGroupContainer[]);
    /**
     * @stability stable
     */
    get containerInput(): ContainerGroupContainer[] | undefined;
    private _diagnostics;
    /**
     * @stability stable
     */
    get diagnostics(): ContainerGroupDiagnosticsOutputReference;
    /**
     * @stability stable
     */
    putDiagnostics(value: ContainerGroupDiagnostics): void;
    /**
     * @stability stable
     */
    resetDiagnostics(): void;
    /**
     * @stability stable
     */
    get diagnosticsInput(): ContainerGroupDiagnostics | undefined;
    private _dnsConfig;
    /**
     * @stability stable
     */
    get dnsConfig(): ContainerGroupDnsConfigOutputReference;
    /**
     * @stability stable
     */
    putDnsConfig(value: ContainerGroupDnsConfig): void;
    /**
     * @stability stable
     */
    resetDnsConfig(): void;
    /**
     * @stability stable
     */
    get dnsConfigInput(): ContainerGroupDnsConfig | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): ContainerGroupIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: ContainerGroupIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): ContainerGroupIdentity | undefined;
    private _imageRegistryCredential?;
    /**
     * @stability stable
     */
    get imageRegistryCredential(): ContainerGroupImageRegistryCredential[];
    /**
     * @stability stable
     */
    set imageRegistryCredential(value: ContainerGroupImageRegistryCredential[]);
    /**
     * @stability stable
     */
    resetImageRegistryCredential(): void;
    /**
     * @stability stable
     */
    get imageRegistryCredentialInput(): ContainerGroupImageRegistryCredential[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ContainerGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ContainerGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
