import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbSqlTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#body CosmosdbSqlTrigger#body}.
     *
     * @stability stable
     */
    readonly body: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#container_id CosmosdbSqlTrigger#container_id}.
     *
     * @stability stable
     */
    readonly containerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#name CosmosdbSqlTrigger#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#operation CosmosdbSqlTrigger#operation}.
     *
     * @stability stable
     */
    readonly operation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#type CosmosdbSqlTrigger#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#timeouts CosmosdbSqlTrigger#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbSqlTriggerTimeouts;
}
/**
 * @stability stable
 */
export interface CosmosdbSqlTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#create CosmosdbSqlTrigger#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#delete CosmosdbSqlTrigger#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#read CosmosdbSqlTrigger#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html#update CosmosdbSqlTrigger#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbSqlTriggerTimeoutsToTerraform(struct?: CosmosdbSqlTriggerTimeoutsOutputReference | CosmosdbSqlTriggerTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbSqlTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbSqlTriggerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbSqlTriggerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html azurerm_cosmosdb_sql_trigger}.
 *
 * @stability stable
 */
export declare class CosmosdbSqlTrigger extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_trigger.html azurerm_cosmosdb_sql_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbSqlTriggerConfig);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _containerId?;
    /**
     * @stability stable
     */
    get containerId(): string;
    /**
     * @stability stable
     */
    set containerId(value: string);
    /**
     * @stability stable
     */
    get containerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operation?;
    /**
     * @stability stable
     */
    get operation(): string;
    /**
     * @stability stable
     */
    set operation(value: string);
    /**
     * @stability stable
     */
    get operationInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbSqlTriggerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbSqlTriggerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbSqlTriggerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
