import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermApiManagementApiConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html#api_management_name DataAzurermApiManagementApi#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html#name DataAzurermApiManagementApi#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html#resource_group_name DataAzurermApiManagementApi#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html#revision DataAzurermApiManagementApi#revision}.
     *
     * @stability stable
     */
    readonly revision: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html#timeouts DataAzurermApiManagementApi#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermApiManagementApiTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementApiSubscriptionKeyParameterNames extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get header(): string;
    /**
     * @stability stable
     */
    get query(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermApiManagementApiTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html#read DataAzurermApiManagementApi#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermApiManagementApiTimeoutsToTerraform(struct?: DataAzurermApiManagementApiTimeoutsOutputReference | DataAzurermApiManagementApiTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermApiManagementApiTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermApiManagementApiTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermApiManagementApiTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html azurerm_api_management_api}.
 *
 * @stability stable
 */
export declare class DataAzurermApiManagementApi extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management_api.html azurerm_api_management_api} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementApiConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get isCurrent(): any;
    /**
     * @stability stable
     */
    get isOnline(): any;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    get protocols(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _revision?;
    /**
     * @stability stable
     */
    get revision(): string;
    /**
     * @stability stable
     */
    set revision(value: string);
    /**
     * @stability stable
     */
    get revisionInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceUrl(): string;
    /**
     * @stability stable
     */
    get soapPassThrough(): any;
    /**
     * @stability stable
     */
    subscriptionKeyParameterNames(index: string): DataAzurermApiManagementApiSubscriptionKeyParameterNames;
    /**
     * @stability stable
     */
    get subscriptionRequired(): any;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    get versionSetId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermApiManagementApiTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermApiManagementApiTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermApiManagementApiTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
