import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAppServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan.html#name DataAzurermAppServicePlan#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan.html#resource_group_name DataAzurermAppServicePlan#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan.html#timeouts DataAzurermAppServicePlan#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAppServicePlanTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServicePlanSku extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    get size(): string;
    /**
     * @stability stable
     */
    get tier(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermAppServicePlanTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan.html#read DataAzurermAppServicePlan#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAppServicePlanTimeoutsToTerraform(struct?: DataAzurermAppServicePlanTimeoutsOutputReference | DataAzurermAppServicePlanTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermAppServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAppServicePlanTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAppServicePlanTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan.html azurerm_app_service_plan}.
 *
 * @stability stable
 */
export declare class DataAzurermAppServicePlan extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan.html azurerm_app_service_plan} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAppServicePlanConfig);
    /**
     * @stability stable
     */
    get appServiceEnvironmentId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get isXenon(): any;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get maximumElasticWorkerCount(): number;
    /**
     * @stability stable
     */
    get maximumNumberOfWorkers(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get perSiteScaling(): any;
    /**
     * @stability stable
     */
    get reserved(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    sku(index: string): DataAzurermAppServicePlanSku;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get zoneRedundant(): any;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAppServicePlanTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAppServicePlanTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAppServicePlanTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
