import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBackupPolicyVmConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm.html#name DataAzurermBackupPolicyVm#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm.html#recovery_vault_name DataAzurermBackupPolicyVm#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm.html#resource_group_name DataAzurermBackupPolicyVm#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm.html#timeouts DataAzurermBackupPolicyVm#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBackupPolicyVmTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermBackupPolicyVmTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm.html#read DataAzurermBackupPolicyVm#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBackupPolicyVmTimeoutsToTerraform(struct?: DataAzurermBackupPolicyVmTimeoutsOutputReference | DataAzurermBackupPolicyVmTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermBackupPolicyVmTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBackupPolicyVmTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBackupPolicyVmTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm.html azurerm_backup_policy_vm}.
 *
 * @stability stable
 */
export declare class DataAzurermBackupPolicyVm extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/backup_policy_vm.html azurerm_backup_policy_vm} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBackupPolicyVmConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBackupPolicyVmTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBackupPolicyVmTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBackupPolicyVmTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
