import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBatchPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#account_name DataAzurermBatchPool#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#name DataAzurermBatchPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#resource_group_name DataAzurermBatchPool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#certificate DataAzurermBatchPool#certificate}
     *
     * @stability stable
     */
    readonly certificate?: DataAzurermBatchPoolCertificate[];
    /**
     * start_task block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#start_task DataAzurermBatchPool#start_task}
     *
     * @stability stable
     */
    readonly startTask?: DataAzurermBatchPoolStartTask;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#timeouts DataAzurermBatchPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBatchPoolTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolAutoScale extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get evaluationInterval(): string;
    /**
     * @stability stable
     */
    get formula(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolContainerConfigurationContainerRegistries extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get registryServer(): string;
    /**
     * @stability stable
     */
    get userName(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolContainerConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get containerImageNames(): string[];
    /**
     * @stability stable
     */
    get containerRegistries(): any;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolFixedScale extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resizeTimeout(): string;
    /**
     * @stability stable
     */
    get targetDedicatedNodes(): number;
    /**
     * @stability stable
     */
    get targetLowPriorityNodes(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    get sourceAddressPrefix(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get backendPort(): number;
    /**
     * @stability stable
     */
    get frontendPortRange(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get networkSecurityGroupRules(): any;
    /**
     * @stability stable
     */
    get protocol(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolNetworkConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endpointConfiguration(): any;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolStorageImageReference extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermBatchPoolCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#id DataAzurermBatchPool#id}.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#store_location DataAzurermBatchPool#store_location}.
     *
     * @stability stable
     */
    readonly storeLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#store_name DataAzurermBatchPool#store_name}.
     *
     * @stability stable
     */
    readonly storeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#visibility DataAzurermBatchPool#visibility}.
     *
     * @stability stable
     */
    readonly visibility?: string[];
}
export declare function dataAzurermBatchPoolCertificateToTerraform(struct?: DataAzurermBatchPoolCertificate): any;
/**
 * @stability stable
 */
export interface DataAzurermBatchPoolStartTask {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#command_line DataAzurermBatchPool#command_line}.
     *
     * @stability stable
     */
    readonly commandLine: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#environment DataAzurermBatchPool#environment}.
     *
     * @stability stable
     */
    readonly environment?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#max_task_retry_count DataAzurermBatchPool#max_task_retry_count}.
     *
     * @stability stable
     */
    readonly maxTaskRetryCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#wait_for_success DataAzurermBatchPool#wait_for_success}.
     *
     * @stability stable
     */
    readonly waitForSuccess?: boolean | cdktf.IResolvable;
}
export declare function dataAzurermBatchPoolStartTaskToTerraform(struct?: DataAzurermBatchPoolStartTaskOutputReference | DataAzurermBatchPoolStartTask): any;
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolStartTaskOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBatchPoolStartTask | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBatchPoolStartTask | undefined);
    private _commandLine?;
    /**
     * @stability stable
     */
    get commandLine(): string;
    /**
     * @stability stable
     */
    set commandLine(value: string);
    /**
     * @stability stable
     */
    get commandLineInput(): string | undefined;
    private _environment?;
    /**
     * @stability stable
     */
    get environment(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set environment(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnvironment(): void;
    /**
     * @stability stable
     */
    get environmentInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maxTaskRetryCount?;
    /**
     * @stability stable
     */
    get maxTaskRetryCount(): number;
    /**
     * @stability stable
     */
    set maxTaskRetryCount(value: number);
    /**
     * @stability stable
     */
    resetMaxTaskRetryCount(): void;
    /**
     * @stability stable
     */
    get maxTaskRetryCountInput(): number | undefined;
    private _waitForSuccess?;
    /**
     * @stability stable
     */
    get waitForSuccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set waitForSuccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWaitForSuccess(): void;
    /**
     * @stability stable
     */
    get waitForSuccessInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermBatchPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#read DataAzurermBatchPool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBatchPoolTimeoutsToTerraform(struct?: DataAzurermBatchPoolTimeoutsOutputReference | DataAzurermBatchPoolTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBatchPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBatchPoolTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html azurerm_batch_pool}.
 *
 * @stability stable
 */
export declare class DataAzurermBatchPool extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html azurerm_batch_pool} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBatchPoolConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    autoScale(index: string): DataAzurermBatchPoolAutoScale;
    /**
     * @stability stable
     */
    containerConfiguration(index: string): DataAzurermBatchPoolContainerConfiguration;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    fixedScale(index: string): DataAzurermBatchPoolFixedScale;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get maxTasksPerNode(): number;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkConfiguration(index: string): DataAzurermBatchPoolNetworkConfiguration;
    /**
     * @stability stable
     */
    get nodeAgentSkuId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    storageImageReference(index: string): DataAzurermBatchPoolStorageImageReference;
    /**
     * @stability stable
     */
    get vmSize(): string;
    private _certificate?;
    /**
     * @stability stable
     */
    get certificate(): DataAzurermBatchPoolCertificate[];
    /**
     * @stability stable
     */
    set certificate(value: DataAzurermBatchPoolCertificate[]);
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): DataAzurermBatchPoolCertificate[] | undefined;
    private _startTask;
    /**
     * @stability stable
     */
    get startTask(): DataAzurermBatchPoolStartTaskOutputReference;
    /**
     * @stability stable
     */
    putStartTask(value: DataAzurermBatchPoolStartTask): void;
    /**
     * @stability stable
     */
    resetStartTask(): void;
    /**
     * @stability stable
     */
    get startTaskInput(): DataAzurermBatchPoolStartTask | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBatchPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBatchPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBatchPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
