import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDevTestVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network.html#lab_name DataAzurermDevTestVirtualNetwork#lab_name}.
     *
     * @stability stable
     */
    readonly labName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network.html#name DataAzurermDevTestVirtualNetwork#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network.html#resource_group_name DataAzurermDevTestVirtualNetwork#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network.html#timeouts DataAzurermDevTestVirtualNetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDevTestVirtualNetworkTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermDevTestVirtualNetworkAllowedSubnets extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowPublicIp(): string;
    /**
     * @stability stable
     */
    get labSubnetName(): string;
    /**
     * @stability stable
     */
    get resourceId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermDevTestVirtualNetworkSubnetOverrides extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get labSubnetName(): string;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    get useInVmCreationPermission(): string;
    /**
     * @stability stable
     */
    get usePublicIpAddressPermission(): string;
    /**
     * @stability stable
     */
    get virtualNetworkPoolName(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermDevTestVirtualNetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network.html#read DataAzurermDevTestVirtualNetwork#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDevTestVirtualNetworkTimeoutsToTerraform(struct?: DataAzurermDevTestVirtualNetworkTimeoutsOutputReference | DataAzurermDevTestVirtualNetworkTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermDevTestVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDevTestVirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDevTestVirtualNetworkTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network.html azurerm_dev_test_virtual_network}.
 *
 * @stability stable
 */
export declare class DataAzurermDevTestVirtualNetwork extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_virtual_network.html azurerm_dev_test_virtual_network} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDevTestVirtualNetworkConfig);
    /**
     * @stability stable
     */
    allowedSubnets(index: string): DataAzurermDevTestVirtualNetworkAllowedSubnets;
    /**
     * @stability stable
     */
    get id(): string;
    private _labName?;
    /**
     * @stability stable
     */
    get labName(): string;
    /**
     * @stability stable
     */
    set labName(value: string);
    /**
     * @stability stable
     */
    get labNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    subnetOverrides(index: string): DataAzurermDevTestVirtualNetworkSubnetOverrides;
    /**
     * @stability stable
     */
    get uniqueIdentifier(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDevTestVirtualNetworkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDevTestVirtualNetworkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDevTestVirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
