import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermImageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image.html#name DataAzurermImage#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image.html#name_regex DataAzurermImage#name_regex}.
     *
     * @stability stable
     */
    readonly nameRegex?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image.html#resource_group_name DataAzurermImage#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image.html#sort_descending DataAzurermImage#sort_descending}.
     *
     * @stability stable
     */
    readonly sortDescending?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image.html#timeouts DataAzurermImage#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermImageTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermImageDataDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get blobUri(): string;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    get lun(): number;
    /**
     * @stability stable
     */
    get managedDiskId(): string;
    /**
     * @stability stable
     */
    get sizeGb(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermImageOsDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get blobUri(): string;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    get managedDiskId(): string;
    /**
     * @stability stable
     */
    get osState(): string;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    get sizeGb(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermImageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/image.html#read DataAzurermImage#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermImageTimeoutsToTerraform(struct?: DataAzurermImageTimeoutsOutputReference | DataAzurermImageTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermImageTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermImageTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermImageTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/image.html azurerm_image}.
 *
 * @stability stable
 */
export declare class DataAzurermImage extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/image.html azurerm_image} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermImageConfig);
    /**
     * @stability stable
     */
    dataDisk(index: string): DataAzurermImageDataDisk;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nameRegex?;
    /**
     * @stability stable
     */
    get nameRegex(): string;
    /**
     * @stability stable
     */
    set nameRegex(value: string);
    /**
     * @stability stable
     */
    resetNameRegex(): void;
    /**
     * @stability stable
     */
    get nameRegexInput(): string | undefined;
    /**
     * @stability stable
     */
    osDisk(index: string): DataAzurermImageOsDisk;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sortDescending?;
    /**
     * @stability stable
     */
    get sortDescending(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sortDescending(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSortDescending(): void;
    /**
     * @stability stable
     */
    get sortDescendingInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get zoneResilient(): any;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermImageTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermImageTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermImageTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
