import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermLbConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb.html#name DataAzurermLb#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb.html#resource_group_name DataAzurermLb#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb.html#timeouts DataAzurermLb#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermLbTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermLbFrontendIpConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddressAllocation(): string;
    /**
     * @stability stable
     */
    get privateIpAddressVersion(): string;
    /**
     * @stability stable
     */
    get publicIpAddressId(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    get zones(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermLbTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb.html#read DataAzurermLb#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermLbTimeoutsToTerraform(struct?: DataAzurermLbTimeoutsOutputReference | DataAzurermLbTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermLbTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLbTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLbTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/lb.html azurerm_lb}.
 *
 * @stability stable
 */
export declare class DataAzurermLb extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/lb.html azurerm_lb} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermLbConfig);
    /**
     * @stability stable
     */
    frontendIpConfiguration(index: string): DataAzurermLbFrontendIpConfiguration;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermLbTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermLbTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermLbTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
