import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPrivateDnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone.html#name DataAzurermPrivateDnsZone#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone.html#resource_group_name DataAzurermPrivateDnsZone#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone.html#timeouts DataAzurermPrivateDnsZone#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPrivateDnsZoneTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermPrivateDnsZoneTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone.html#read DataAzurermPrivateDnsZone#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsZoneTimeoutsToTerraform(struct?: DataAzurermPrivateDnsZoneTimeoutsOutputReference | DataAzurermPrivateDnsZoneTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermPrivateDnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPrivateDnsZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPrivateDnsZoneTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone.html azurerm_private_dns_zone}.
 *
 * @stability stable
 */
export declare class DataAzurermPrivateDnsZone extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_dns_zone.html azurerm_private_dns_zone} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsZoneConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get maxNumberOfRecordSets(): number;
    /**
     * @stability stable
     */
    get maxNumberOfVirtualNetworkLinks(): number;
    /**
     * @stability stable
     */
    get maxNumberOfVirtualNetworkLinksWithRegistration(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetResourceGroupName(): void;
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPrivateDnsZoneTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPrivateDnsZoneTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPrivateDnsZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
