import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountSasConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#connection_string DataAzurermStorageAccountSas#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#expiry DataAzurermStorageAccountSas#expiry}.
     *
     * @stability stable
     */
    readonly expiry: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#https_only DataAzurermStorageAccountSas#https_only}.
     *
     * @stability stable
     */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#ip_addresses DataAzurermStorageAccountSas#ip_addresses}.
     *
     * @stability stable
     */
    readonly ipAddresses?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#signed_version DataAzurermStorageAccountSas#signed_version}.
     *
     * @stability stable
     */
    readonly signedVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#start DataAzurermStorageAccountSas#start}.
     *
     * @stability stable
     */
    readonly start: string;
    /**
     * permissions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#permissions DataAzurermStorageAccountSas#permissions}
     *
     * @stability stable
     */
    readonly permissions: DataAzurermStorageAccountSasPermissions;
    /**
     * resource_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#resource_types DataAzurermStorageAccountSas#resource_types}
     *
     * @stability stable
     */
    readonly resourceTypes: DataAzurermStorageAccountSasResourceTypes;
    /**
     * services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#services DataAzurermStorageAccountSas#services}
     *
     * @stability stable
     */
    readonly services: DataAzurermStorageAccountSasServices;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#timeouts DataAzurermStorageAccountSas#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageAccountSasTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountSasPermissions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#add DataAzurermStorageAccountSas#add}.
     *
     * @stability stable
     */
    readonly add: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#create DataAzurermStorageAccountSas#create}.
     *
     * @stability stable
     */
    readonly create: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#delete DataAzurermStorageAccountSas#delete}.
     *
     * @stability stable
     */
    readonly delete: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#list DataAzurermStorageAccountSas#list}.
     *
     * @stability stable
     */
    readonly list: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#process DataAzurermStorageAccountSas#process}.
     *
     * @stability stable
     */
    readonly process: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#read DataAzurermStorageAccountSas#read}.
     *
     * @stability stable
     */
    readonly read: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#update DataAzurermStorageAccountSas#update}.
     *
     * @stability stable
     */
    readonly update: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#write DataAzurermStorageAccountSas#write}.
     *
     * @stability stable
     */
    readonly write: boolean | cdktf.IResolvable;
}
export declare function dataAzurermStorageAccountSasPermissionsToTerraform(struct?: DataAzurermStorageAccountSasPermissionsOutputReference | DataAzurermStorageAccountSasPermissions): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountSasPermissionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageAccountSasPermissions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageAccountSasPermissions | undefined);
    private _add?;
    /**
     * @stability stable
     */
    get add(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set add(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get addInput(): boolean | cdktf.IResolvable | undefined;
    private _create?;
    /**
     * @stability stable
     */
    get create(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set create(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get createInput(): boolean | cdktf.IResolvable | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set delete(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get deleteInput(): boolean | cdktf.IResolvable | undefined;
    private _list?;
    /**
     * @stability stable
     */
    get list(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set list(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get listInput(): boolean | cdktf.IResolvable | undefined;
    private _process?;
    /**
     * @stability stable
     */
    get process(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set process(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get processInput(): boolean | cdktf.IResolvable | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set read(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get readInput(): boolean | cdktf.IResolvable | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set update(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get updateInput(): boolean | cdktf.IResolvable | undefined;
    private _write?;
    /**
     * @stability stable
     */
    get write(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set write(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get writeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountSasResourceTypes {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#container DataAzurermStorageAccountSas#container}.
     *
     * @stability stable
     */
    readonly container: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#object DataAzurermStorageAccountSas#object}.
     *
     * @stability stable
     */
    readonly object: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#service DataAzurermStorageAccountSas#service}.
     *
     * @stability stable
     */
    readonly service: boolean | cdktf.IResolvable;
}
export declare function dataAzurermStorageAccountSasResourceTypesToTerraform(struct?: DataAzurermStorageAccountSasResourceTypesOutputReference | DataAzurermStorageAccountSasResourceTypes): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountSasResourceTypesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageAccountSasResourceTypes | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageAccountSasResourceTypes | undefined);
    private _container?;
    /**
     * @stability stable
     */
    get container(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set container(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get containerInput(): boolean | cdktf.IResolvable | undefined;
    private _object?;
    /**
     * @stability stable
     */
    get object(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set object(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get objectInput(): boolean | cdktf.IResolvable | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set service(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get serviceInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountSasServices {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#blob DataAzurermStorageAccountSas#blob}.
     *
     * @stability stable
     */
    readonly blob: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#file DataAzurermStorageAccountSas#file}.
     *
     * @stability stable
     */
    readonly file: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#queue DataAzurermStorageAccountSas#queue}.
     *
     * @stability stable
     */
    readonly queue: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#table DataAzurermStorageAccountSas#table}.
     *
     * @stability stable
     */
    readonly table: boolean | cdktf.IResolvable;
}
export declare function dataAzurermStorageAccountSasServicesToTerraform(struct?: DataAzurermStorageAccountSasServicesOutputReference | DataAzurermStorageAccountSasServices): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountSasServicesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageAccountSasServices | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageAccountSasServices | undefined);
    private _blob?;
    /**
     * @stability stable
     */
    get blob(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set blob(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get blobInput(): boolean | cdktf.IResolvable | undefined;
    private _file?;
    /**
     * @stability stable
     */
    get file(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set file(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get fileInput(): boolean | cdktf.IResolvable | undefined;
    private _queue?;
    /**
     * @stability stable
     */
    get queue(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set queue(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get queueInput(): boolean | cdktf.IResolvable | undefined;
    private _table?;
    /**
     * @stability stable
     */
    get table(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set table(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get tableInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountSasTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html#read DataAzurermStorageAccountSas#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageAccountSasTimeoutsToTerraform(struct?: DataAzurermStorageAccountSasTimeoutsOutputReference | DataAzurermStorageAccountSasTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountSasTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageAccountSasTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageAccountSasTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html azurerm_storage_account_sas}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageAccountSas extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account_sas.html azurerm_storage_account_sas} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageAccountSasConfig);
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _expiry?;
    /**
     * @stability stable
     */
    get expiry(): string;
    /**
     * @stability stable
     */
    set expiry(value: string);
    /**
     * @stability stable
     */
    get expiryInput(): string | undefined;
    private _httpsOnly?;
    /**
     * @stability stable
     */
    get httpsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsOnly(): void;
    /**
     * @stability stable
     */
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddresses?;
    /**
     * @stability stable
     */
    get ipAddresses(): string;
    /**
     * @stability stable
     */
    set ipAddresses(value: string);
    /**
     * @stability stable
     */
    resetIpAddresses(): void;
    /**
     * @stability stable
     */
    get ipAddressesInput(): string | undefined;
    /**
     * @stability stable
     */
    get sas(): string;
    private _signedVersion?;
    /**
     * @stability stable
     */
    get signedVersion(): string;
    /**
     * @stability stable
     */
    set signedVersion(value: string);
    /**
     * @stability stable
     */
    resetSignedVersion(): void;
    /**
     * @stability stable
     */
    get signedVersionInput(): string | undefined;
    private _start?;
    /**
     * @stability stable
     */
    get start(): string;
    /**
     * @stability stable
     */
    set start(value: string);
    /**
     * @stability stable
     */
    get startInput(): string | undefined;
    private _permissions;
    /**
     * @stability stable
     */
    get permissions(): DataAzurermStorageAccountSasPermissionsOutputReference;
    /**
     * @stability stable
     */
    putPermissions(value: DataAzurermStorageAccountSasPermissions): void;
    /**
     * @stability stable
     */
    get permissionsInput(): DataAzurermStorageAccountSasPermissions | undefined;
    private _resourceTypes;
    /**
     * @stability stable
     */
    get resourceTypes(): DataAzurermStorageAccountSasResourceTypesOutputReference;
    /**
     * @stability stable
     */
    putResourceTypes(value: DataAzurermStorageAccountSasResourceTypes): void;
    /**
     * @stability stable
     */
    get resourceTypesInput(): DataAzurermStorageAccountSasResourceTypes | undefined;
    private _services;
    /**
     * @stability stable
     */
    get services(): DataAzurermStorageAccountSasServicesOutputReference;
    /**
     * @stability stable
     */
    putServices(value: DataAzurermStorageAccountSasServices): void;
    /**
     * @stability stable
     */
    get servicesInput(): DataAzurermStorageAccountSasServices | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageAccountSasTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageAccountSasTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageAccountSasTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
