import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account.html#min_tls_version DataAzurermStorageAccount#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account.html#name DataAzurermStorageAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account.html#resource_group_name DataAzurermStorageAccount#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account.html#timeouts DataAzurermStorageAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageAccountTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountCustomDomain extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account.html#read DataAzurermStorageAccount#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageAccountTimeoutsToTerraform(struct?: DataAzurermStorageAccountTimeoutsOutputReference | DataAzurermStorageAccountTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageAccountTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account.html azurerm_storage_account}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageAccount extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_account.html azurerm_storage_account} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageAccountConfig);
    /**
     * @stability stable
     */
    get accessTier(): string;
    /**
     * @stability stable
     */
    get accountKind(): string;
    /**
     * @stability stable
     */
    get accountReplicationType(): string;
    /**
     * @stability stable
     */
    get accountTier(): string;
    /**
     * @stability stable
     */
    get allowBlobPublicAccess(): any;
    /**
     * @stability stable
     */
    customDomain(index: string): DataAzurermStorageAccountCustomDomain;
    /**
     * @stability stable
     */
    get enableHttpsTrafficOnly(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get isHnsEnabled(): any;
    /**
     * @stability stable
     */
    get location(): string;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    /**
     * @stability stable
     */
    get primaryBlobConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryBlobEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryBlobHost(): string;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryDfsEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryDfsHost(): string;
    /**
     * @stability stable
     */
    get primaryFileEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryFileHost(): string;
    /**
     * @stability stable
     */
    get primaryLocation(): string;
    /**
     * @stability stable
     */
    get primaryQueueEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryQueueHost(): string;
    /**
     * @stability stable
     */
    get primaryTableEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryTableHost(): string;
    /**
     * @stability stable
     */
    get primaryWebEndpoint(): string;
    /**
     * @stability stable
     */
    get primaryWebHost(): string;
    /**
     * @stability stable
     */
    get queueEncryptionKeyType(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    /**
     * @stability stable
     */
    get secondaryBlobConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryBlobEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryBlobHost(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryDfsEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryDfsHost(): string;
    /**
     * @stability stable
     */
    get secondaryFileEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryFileHost(): string;
    /**
     * @stability stable
     */
    get secondaryLocation(): string;
    /**
     * @stability stable
     */
    get secondaryQueueEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryQueueHost(): string;
    /**
     * @stability stable
     */
    get secondaryTableEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryTableHost(): string;
    /**
     * @stability stable
     */
    get secondaryWebEndpoint(): string;
    /**
     * @stability stable
     */
    get secondaryWebHost(): string;
    /**
     * @stability stable
     */
    get tableEncryptionKeyType(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageAccountTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageAccountTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
