import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageTableEntityConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html#partition_key DataAzurermStorageTableEntity#partition_key}.
     *
     * @stability stable
     */
    readonly partitionKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html#row_key DataAzurermStorageTableEntity#row_key}.
     *
     * @stability stable
     */
    readonly rowKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html#storage_account_name DataAzurermStorageTableEntity#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html#table_name DataAzurermStorageTableEntity#table_name}.
     *
     * @stability stable
     */
    readonly tableName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html#timeouts DataAzurermStorageTableEntity#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageTableEntityTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageTableEntityTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html#read DataAzurermStorageTableEntity#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageTableEntityTimeoutsToTerraform(struct?: DataAzurermStorageTableEntityTimeoutsOutputReference | DataAzurermStorageTableEntityTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageTableEntityTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageTableEntityTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageTableEntityTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html azurerm_storage_table_entity}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageTableEntity extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_table_entity.html azurerm_storage_table_entity} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageTableEntityConfig);
    /**
     * @stability stable
     */
    entity(key: string): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _partitionKey?;
    /**
     * @stability stable
     */
    get partitionKey(): string;
    /**
     * @stability stable
     */
    set partitionKey(value: string);
    /**
     * @stability stable
     */
    get partitionKeyInput(): string | undefined;
    private _rowKey?;
    /**
     * @stability stable
     */
    get rowKey(): string;
    /**
     * @stability stable
     */
    set rowKey(value: string);
    /**
     * @stability stable
     */
    get rowKeyInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _tableName?;
    /**
     * @stability stable
     */
    get tableName(): string;
    /**
     * @stability stable
     */
    set tableName(value: string);
    /**
     * @stability stable
     */
    get tableNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageTableEntityTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageTableEntityTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageTableEntityTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
