import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryManagedPrivateEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#data_factory_id DataFactoryManagedPrivateEndpoint#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#name DataFactoryManagedPrivateEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#subresource_name DataFactoryManagedPrivateEndpoint#subresource_name}.
     *
     * @stability stable
     */
    readonly subresourceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#target_resource_id DataFactoryManagedPrivateEndpoint#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#timeouts DataFactoryManagedPrivateEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryManagedPrivateEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryManagedPrivateEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#create DataFactoryManagedPrivateEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#delete DataFactoryManagedPrivateEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html#read DataFactoryManagedPrivateEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataFactoryManagedPrivateEndpointTimeoutsToTerraform(struct?: DataFactoryManagedPrivateEndpointTimeoutsOutputReference | DataFactoryManagedPrivateEndpointTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryManagedPrivateEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryManagedPrivateEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryManagedPrivateEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html azurerm_data_factory_managed_private_endpoint}.
 *
 * @stability stable
 */
export declare class DataFactoryManagedPrivateEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_managed_private_endpoint.html azurerm_data_factory_managed_private_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryManagedPrivateEndpointConfig);
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _subresourceName?;
    /**
     * @stability stable
     */
    get subresourceName(): string;
    /**
     * @stability stable
     */
    set subresourceName(value: string);
    /**
     * @stability stable
     */
    get subresourceNameInput(): string | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryManagedPrivateEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryManagedPrivateEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryManagedPrivateEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
