import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataLakeStoreVirtualNetworkRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#account_name DataLakeStoreVirtualNetworkRule#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#name DataLakeStoreVirtualNetworkRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#resource_group_name DataLakeStoreVirtualNetworkRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#subnet_id DataLakeStoreVirtualNetworkRule#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#timeouts DataLakeStoreVirtualNetworkRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataLakeStoreVirtualNetworkRuleTimeouts;
}
/**
 * @stability stable
 */
export interface DataLakeStoreVirtualNetworkRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#create DataLakeStoreVirtualNetworkRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#delete DataLakeStoreVirtualNetworkRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#read DataLakeStoreVirtualNetworkRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html#update DataLakeStoreVirtualNetworkRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataLakeStoreVirtualNetworkRuleTimeoutsToTerraform(struct?: DataLakeStoreVirtualNetworkRuleTimeoutsOutputReference | DataLakeStoreVirtualNetworkRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class DataLakeStoreVirtualNetworkRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataLakeStoreVirtualNetworkRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataLakeStoreVirtualNetworkRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html azurerm_data_lake_store_virtual_network_rule}.
 *
 * @stability stable
 */
export declare class DataLakeStoreVirtualNetworkRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_lake_store_virtual_network_rule.html azurerm_data_lake_store_virtual_network_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataLakeStoreVirtualNetworkRuleConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataLakeStoreVirtualNetworkRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataLakeStoreVirtualNetworkRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataLakeStoreVirtualNetworkRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
