import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DigitalTwinsEndpointServicebusConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#dead_letter_storage_secret DigitalTwinsEndpointServicebus#dead_letter_storage_secret}.
     *
     * @stability stable
     */
    readonly deadLetterStorageSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#digital_twins_id DigitalTwinsEndpointServicebus#digital_twins_id}.
     *
     * @stability stable
     */
    readonly digitalTwinsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#name DigitalTwinsEndpointServicebus#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#servicebus_primary_connection_string DigitalTwinsEndpointServicebus#servicebus_primary_connection_string}.
     *
     * @stability stable
     */
    readonly servicebusPrimaryConnectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#servicebus_secondary_connection_string DigitalTwinsEndpointServicebus#servicebus_secondary_connection_string}.
     *
     * @stability stable
     */
    readonly servicebusSecondaryConnectionString: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#timeouts DigitalTwinsEndpointServicebus#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DigitalTwinsEndpointServicebusTimeouts;
}
/**
 * @stability stable
 */
export interface DigitalTwinsEndpointServicebusTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#create DigitalTwinsEndpointServicebus#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#delete DigitalTwinsEndpointServicebus#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#read DigitalTwinsEndpointServicebus#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html#update DigitalTwinsEndpointServicebus#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function digitalTwinsEndpointServicebusTimeoutsToTerraform(struct?: DigitalTwinsEndpointServicebusTimeoutsOutputReference | DigitalTwinsEndpointServicebusTimeouts): any;
/**
 * @stability stable
 */
export declare class DigitalTwinsEndpointServicebusTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DigitalTwinsEndpointServicebusTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DigitalTwinsEndpointServicebusTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html azurerm_digital_twins_endpoint_servicebus}.
 *
 * @stability stable
 */
export declare class DigitalTwinsEndpointServicebus extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_servicebus.html azurerm_digital_twins_endpoint_servicebus} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DigitalTwinsEndpointServicebusConfig);
    private _deadLetterStorageSecret?;
    /**
     * @stability stable
     */
    get deadLetterStorageSecret(): string;
    /**
     * @stability stable
     */
    set deadLetterStorageSecret(value: string);
    /**
     * @stability stable
     */
    resetDeadLetterStorageSecret(): void;
    /**
     * @stability stable
     */
    get deadLetterStorageSecretInput(): string | undefined;
    private _digitalTwinsId?;
    /**
     * @stability stable
     */
    get digitalTwinsId(): string;
    /**
     * @stability stable
     */
    set digitalTwinsId(value: string);
    /**
     * @stability stable
     */
    get digitalTwinsIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _servicebusPrimaryConnectionString?;
    /**
     * @stability stable
     */
    get servicebusPrimaryConnectionString(): string;
    /**
     * @stability stable
     */
    set servicebusPrimaryConnectionString(value: string);
    /**
     * @stability stable
     */
    get servicebusPrimaryConnectionStringInput(): string | undefined;
    private _servicebusSecondaryConnectionString?;
    /**
     * @stability stable
     */
    get servicebusSecondaryConnectionString(): string;
    /**
     * @stability stable
     */
    set servicebusSecondaryConnectionString(value: string);
    /**
     * @stability stable
     */
    get servicebusSecondaryConnectionStringInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DigitalTwinsEndpointServicebusTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DigitalTwinsEndpointServicebusTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DigitalTwinsEndpointServicebusTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
