import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventhubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#message_retention Eventhub#message_retention}.
     *
     * @stability stable
     */
    readonly messageRetention: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#name Eventhub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#namespace_name Eventhub#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#partition_count Eventhub#partition_count}.
     *
     * @stability stable
     */
    readonly partitionCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#resource_group_name Eventhub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#status Eventhub#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * capture_description block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#capture_description Eventhub#capture_description}
     *
     * @stability stable
     */
    readonly captureDescription?: EventhubCaptureDescription;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#timeouts Eventhub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventhubTimeouts;
}
/**
 * @stability stable
 */
export interface EventhubCaptureDescriptionDestination {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#archive_name_format Eventhub#archive_name_format}.
     *
     * @stability stable
     */
    readonly archiveNameFormat: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#blob_container_name Eventhub#blob_container_name}.
     *
     * @stability stable
     */
    readonly blobContainerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#name Eventhub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#storage_account_id Eventhub#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
}
export declare function eventhubCaptureDescriptionDestinationToTerraform(struct?: EventhubCaptureDescriptionDestinationOutputReference | EventhubCaptureDescriptionDestination): any;
/**
 * @stability stable
 */
export declare class EventhubCaptureDescriptionDestinationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventhubCaptureDescriptionDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventhubCaptureDescriptionDestination | undefined);
    private _archiveNameFormat?;
    /**
     * @stability stable
     */
    get archiveNameFormat(): string;
    /**
     * @stability stable
     */
    set archiveNameFormat(value: string);
    /**
     * @stability stable
     */
    get archiveNameFormatInput(): string | undefined;
    private _blobContainerName?;
    /**
     * @stability stable
     */
    get blobContainerName(): string;
    /**
     * @stability stable
     */
    set blobContainerName(value: string);
    /**
     * @stability stable
     */
    get blobContainerNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventhubCaptureDescription {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#enabled Eventhub#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#encoding Eventhub#encoding}.
     *
     * @stability stable
     */
    readonly encoding: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#interval_in_seconds Eventhub#interval_in_seconds}.
     *
     * @stability stable
     */
    readonly intervalInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#size_limit_in_bytes Eventhub#size_limit_in_bytes}.
     *
     * @stability stable
     */
    readonly sizeLimitInBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#skip_empty_archives Eventhub#skip_empty_archives}.
     *
     * @stability stable
     */
    readonly skipEmptyArchives?: boolean | cdktf.IResolvable;
    /**
     * destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#destination Eventhub#destination}
     *
     * @stability stable
     */
    readonly destination: EventhubCaptureDescriptionDestination;
}
export declare function eventhubCaptureDescriptionToTerraform(struct?: EventhubCaptureDescriptionOutputReference | EventhubCaptureDescription): any;
/**
 * @stability stable
 */
export declare class EventhubCaptureDescriptionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventhubCaptureDescription | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventhubCaptureDescription | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _intervalInSeconds?;
    /**
     * @stability stable
     */
    get intervalInSeconds(): number;
    /**
     * @stability stable
     */
    set intervalInSeconds(value: number);
    /**
     * @stability stable
     */
    resetIntervalInSeconds(): void;
    /**
     * @stability stable
     */
    get intervalInSecondsInput(): number | undefined;
    private _sizeLimitInBytes?;
    /**
     * @stability stable
     */
    get sizeLimitInBytes(): number;
    /**
     * @stability stable
     */
    set sizeLimitInBytes(value: number);
    /**
     * @stability stable
     */
    resetSizeLimitInBytes(): void;
    /**
     * @stability stable
     */
    get sizeLimitInBytesInput(): number | undefined;
    private _skipEmptyArchives?;
    /**
     * @stability stable
     */
    get skipEmptyArchives(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipEmptyArchives(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipEmptyArchives(): void;
    /**
     * @stability stable
     */
    get skipEmptyArchivesInput(): boolean | cdktf.IResolvable | undefined;
    private _destination;
    /**
     * @stability stable
     */
    get destination(): EventhubCaptureDescriptionDestinationOutputReference;
    /**
     * @stability stable
     */
    putDestination(value: EventhubCaptureDescriptionDestination): void;
    /**
     * @stability stable
     */
    get destinationInput(): EventhubCaptureDescriptionDestination | undefined;
}
/**
 * @stability stable
 */
export interface EventhubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#create Eventhub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#delete Eventhub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#read Eventhub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html#update Eventhub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventhubTimeoutsToTerraform(struct?: EventhubTimeoutsOutputReference | EventhubTimeouts): any;
/**
 * @stability stable
 */
export declare class EventhubTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventhubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html azurerm_eventhub}.
 *
 * @stability stable
 */
export declare class Eventhub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub.html azurerm_eventhub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventhubConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _messageRetention?;
    /**
     * @stability stable
     */
    get messageRetention(): number;
    /**
     * @stability stable
     */
    set messageRetention(value: number);
    /**
     * @stability stable
     */
    get messageRetentionInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _partitionCount?;
    /**
     * @stability stable
     */
    get partitionCount(): number;
    /**
     * @stability stable
     */
    set partitionCount(value: number);
    /**
     * @stability stable
     */
    get partitionCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get partitionIds(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _captureDescription;
    /**
     * @stability stable
     */
    get captureDescription(): EventhubCaptureDescriptionOutputReference;
    /**
     * @stability stable
     */
    putCaptureDescription(value: EventhubCaptureDescription): void;
    /**
     * @stability stable
     */
    resetCaptureDescription(): void;
    /**
     * @stability stable
     */
    get captureDescriptionInput(): EventhubCaptureDescription | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventhubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventhubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
