import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExpressRouteCircuitConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#address_prefix_ipv4 ExpressRouteCircuitConnection#address_prefix_ipv4}.
     *
     * @stability stable
     */
    readonly addressPrefixIpv4: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#address_prefix_ipv6 ExpressRouteCircuitConnection#address_prefix_ipv6}.
     *
     * @stability stable
     */
    readonly addressPrefixIpv6?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#authorization_key ExpressRouteCircuitConnection#authorization_key}.
     *
     * @stability stable
     */
    readonly authorizationKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#name ExpressRouteCircuitConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#peer_peering_id ExpressRouteCircuitConnection#peer_peering_id}.
     *
     * @stability stable
     */
    readonly peerPeeringId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#peering_id ExpressRouteCircuitConnection#peering_id}.
     *
     * @stability stable
     */
    readonly peeringId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#timeouts ExpressRouteCircuitConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ExpressRouteCircuitConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface ExpressRouteCircuitConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#create ExpressRouteCircuitConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#delete ExpressRouteCircuitConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#read ExpressRouteCircuitConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html#update ExpressRouteCircuitConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function expressRouteCircuitConnectionTimeoutsToTerraform(struct?: ExpressRouteCircuitConnectionTimeoutsOutputReference | ExpressRouteCircuitConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class ExpressRouteCircuitConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteCircuitConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteCircuitConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html azurerm_express_route_circuit_connection}.
 *
 * @stability stable
 */
export declare class ExpressRouteCircuitConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_connection.html azurerm_express_route_circuit_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExpressRouteCircuitConnectionConfig);
    private _addressPrefixIpv4?;
    /**
     * @stability stable
     */
    get addressPrefixIpv4(): string;
    /**
     * @stability stable
     */
    set addressPrefixIpv4(value: string);
    /**
     * @stability stable
     */
    get addressPrefixIpv4Input(): string | undefined;
    private _addressPrefixIpv6?;
    /**
     * @stability stable
     */
    get addressPrefixIpv6(): string;
    /**
     * @stability stable
     */
    set addressPrefixIpv6(value: string);
    /**
     * @stability stable
     */
    resetAddressPrefixIpv6(): void;
    /**
     * @stability stable
     */
    get addressPrefixIpv6Input(): string | undefined;
    private _authorizationKey?;
    /**
     * @stability stable
     */
    get authorizationKey(): string;
    /**
     * @stability stable
     */
    set authorizationKey(value: string);
    /**
     * @stability stable
     */
    resetAuthorizationKey(): void;
    /**
     * @stability stable
     */
    get authorizationKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _peerPeeringId?;
    /**
     * @stability stable
     */
    get peerPeeringId(): string;
    /**
     * @stability stable
     */
    set peerPeeringId(value: string);
    /**
     * @stability stable
     */
    get peerPeeringIdInput(): string | undefined;
    private _peeringId?;
    /**
     * @stability stable
     */
    get peeringId(): string;
    /**
     * @stability stable
     */
    set peeringId(value: string);
    /**
     * @stability stable
     */
    get peeringIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ExpressRouteCircuitConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ExpressRouteCircuitConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ExpressRouteCircuitConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
