import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#base_policy_id FirewallPolicy#base_policy_id}.
     *
     * @stability stable
     */
    readonly basePolicyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#location FirewallPolicy#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#name FirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#private_ip_ranges FirewallPolicy#private_ip_ranges}.
     *
     * @stability stable
     */
    readonly privateIpRanges?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#resource_group_name FirewallPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#sku FirewallPolicy#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#tags FirewallPolicy#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#threat_intelligence_mode FirewallPolicy#threat_intelligence_mode}.
     *
     * @stability stable
     */
    readonly threatIntelligenceMode?: string;
    /**
     * dns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#dns FirewallPolicy#dns}
     *
     * @stability stable
     */
    readonly dns?: FirewallPolicyDns;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#identity FirewallPolicy#identity}
     *
     * @stability stable
     */
    readonly identity?: FirewallPolicyIdentity;
    /**
     * insights block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#insights FirewallPolicy#insights}
     *
     * @stability stable
     */
    readonly insights?: FirewallPolicyInsights;
    /**
     * intrusion_detection block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#intrusion_detection FirewallPolicy#intrusion_detection}
     *
     * @stability stable
     */
    readonly intrusionDetection?: FirewallPolicyIntrusionDetection;
    /**
     * threat_intelligence_allowlist block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#threat_intelligence_allowlist FirewallPolicy#threat_intelligence_allowlist}
     *
     * @stability stable
     */
    readonly threatIntelligenceAllowlist?: FirewallPolicyThreatIntelligenceAllowlist;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#timeouts FirewallPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FirewallPolicyTimeouts;
    /**
     * tls_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#tls_certificate FirewallPolicy#tls_certificate}
     *
     * @stability stable
     */
    readonly tlsCertificate?: FirewallPolicyTlsCertificate;
}
/**
 * @stability stable
 */
export interface FirewallPolicyDns {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#network_rule_fqdn_enabled FirewallPolicy#network_rule_fqdn_enabled}.
     *
     * @stability stable
     */
    readonly networkRuleFqdnEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#proxy_enabled FirewallPolicy#proxy_enabled}.
     *
     * @stability stable
     */
    readonly proxyEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#servers FirewallPolicy#servers}.
     *
     * @stability stable
     */
    readonly servers?: string[];
}
export declare function firewallPolicyDnsToTerraform(struct?: FirewallPolicyDnsOutputReference | FirewallPolicyDns): any;
/**
 * @stability stable
 */
export declare class FirewallPolicyDnsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallPolicyDns | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallPolicyDns | undefined);
    private _networkRuleFqdnEnabled?;
    /**
     * @stability stable
     */
    get networkRuleFqdnEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set networkRuleFqdnEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNetworkRuleFqdnEnabled(): void;
    /**
     * @stability stable
     */
    get networkRuleFqdnEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _proxyEnabled?;
    /**
     * @stability stable
     */
    get proxyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set proxyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetProxyEnabled(): void;
    /**
     * @stability stable
     */
    get proxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _servers?;
    /**
     * @stability stable
     */
    get servers(): string[];
    /**
     * @stability stable
     */
    set servers(value: string[]);
    /**
     * @stability stable
     */
    resetServers(): void;
    /**
     * @stability stable
     */
    get serversInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FirewallPolicyIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#type FirewallPolicy#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#user_assigned_identity_ids FirewallPolicy#user_assigned_identity_ids}.
     *
     * @stability stable
     */
    readonly userAssignedIdentityIds?: string[];
}
export declare function firewallPolicyIdentityToTerraform(struct?: FirewallPolicyIdentityOutputReference | FirewallPolicyIdentity): any;
/**
 * @stability stable
 */
export declare class FirewallPolicyIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallPolicyIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallPolicyIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userAssignedIdentityIds?;
    /**
     * @stability stable
     */
    get userAssignedIdentityIds(): string[];
    /**
     * @stability stable
     */
    set userAssignedIdentityIds(value: string[]);
    /**
     * @stability stable
     */
    resetUserAssignedIdentityIds(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityIdsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FirewallPolicyInsightsLogAnalyticsWorkspace {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#firewall_location FirewallPolicy#firewall_location}.
     *
     * @stability stable
     */
    readonly firewallLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#id FirewallPolicy#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
export declare function firewallPolicyInsightsLogAnalyticsWorkspaceToTerraform(struct?: FirewallPolicyInsightsLogAnalyticsWorkspace): any;
/**
 * @stability stable
 */
export interface FirewallPolicyInsights {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#default_log_analytics_workspace_id FirewallPolicy#default_log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly defaultLogAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#enabled FirewallPolicy#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#retention_in_days FirewallPolicy#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays?: number;
    /**
     * log_analytics_workspace block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#log_analytics_workspace FirewallPolicy#log_analytics_workspace}
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspace?: FirewallPolicyInsightsLogAnalyticsWorkspace[];
}
export declare function firewallPolicyInsightsToTerraform(struct?: FirewallPolicyInsightsOutputReference | FirewallPolicyInsights): any;
/**
 * @stability stable
 */
export declare class FirewallPolicyInsightsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallPolicyInsights | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallPolicyInsights | undefined);
    private _defaultLogAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get defaultLogAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set defaultLogAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get defaultLogAnalyticsWorkspaceIdInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionInDays(): void;
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _logAnalyticsWorkspace?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspace(): FirewallPolicyInsightsLogAnalyticsWorkspace[];
    /**
     * @stability stable
     */
    set logAnalyticsWorkspace(value: FirewallPolicyInsightsLogAnalyticsWorkspace[]);
    /**
     * @stability stable
     */
    resetLogAnalyticsWorkspace(): void;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceInput(): FirewallPolicyInsightsLogAnalyticsWorkspace[] | undefined;
}
/**
 * @stability stable
 */
export interface FirewallPolicyIntrusionDetectionSignatureOverrides {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#id FirewallPolicy#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#state FirewallPolicy#state}.
     *
     * @stability stable
     */
    readonly state?: string;
}
export declare function firewallPolicyIntrusionDetectionSignatureOverridesToTerraform(struct?: FirewallPolicyIntrusionDetectionSignatureOverrides): any;
/**
 * @stability stable
 */
export interface FirewallPolicyIntrusionDetectionTrafficBypass {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#description FirewallPolicy#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#destination_addresses FirewallPolicy#destination_addresses}.
     *
     * @stability stable
     */
    readonly destinationAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#destination_ip_groups FirewallPolicy#destination_ip_groups}.
     *
     * @stability stable
     */
    readonly destinationIpGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#destination_ports FirewallPolicy#destination_ports}.
     *
     * @stability stable
     */
    readonly destinationPorts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#name FirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#protocol FirewallPolicy#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#source_addresses FirewallPolicy#source_addresses}.
     *
     * @stability stable
     */
    readonly sourceAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#source_ip_groups FirewallPolicy#source_ip_groups}.
     *
     * @stability stable
     */
    readonly sourceIpGroups?: string[];
}
export declare function firewallPolicyIntrusionDetectionTrafficBypassToTerraform(struct?: FirewallPolicyIntrusionDetectionTrafficBypass): any;
/**
 * @stability stable
 */
export interface FirewallPolicyIntrusionDetection {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#mode FirewallPolicy#mode}.
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * signature_overrides block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#signature_overrides FirewallPolicy#signature_overrides}
     *
     * @stability stable
     */
    readonly signatureOverrides?: FirewallPolicyIntrusionDetectionSignatureOverrides[];
    /**
     * traffic_bypass block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#traffic_bypass FirewallPolicy#traffic_bypass}
     *
     * @stability stable
     */
    readonly trafficBypass?: FirewallPolicyIntrusionDetectionTrafficBypass[];
}
export declare function firewallPolicyIntrusionDetectionToTerraform(struct?: FirewallPolicyIntrusionDetectionOutputReference | FirewallPolicyIntrusionDetection): any;
/**
 * @stability stable
 */
export declare class FirewallPolicyIntrusionDetectionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallPolicyIntrusionDetection | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallPolicyIntrusionDetection | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _signatureOverrides?;
    /**
     * @stability stable
     */
    get signatureOverrides(): FirewallPolicyIntrusionDetectionSignatureOverrides[];
    /**
     * @stability stable
     */
    set signatureOverrides(value: FirewallPolicyIntrusionDetectionSignatureOverrides[]);
    /**
     * @stability stable
     */
    resetSignatureOverrides(): void;
    /**
     * @stability stable
     */
    get signatureOverridesInput(): FirewallPolicyIntrusionDetectionSignatureOverrides[] | undefined;
    private _trafficBypass?;
    /**
     * @stability stable
     */
    get trafficBypass(): FirewallPolicyIntrusionDetectionTrafficBypass[];
    /**
     * @stability stable
     */
    set trafficBypass(value: FirewallPolicyIntrusionDetectionTrafficBypass[]);
    /**
     * @stability stable
     */
    resetTrafficBypass(): void;
    /**
     * @stability stable
     */
    get trafficBypassInput(): FirewallPolicyIntrusionDetectionTrafficBypass[] | undefined;
}
/**
 * @stability stable
 */
export interface FirewallPolicyThreatIntelligenceAllowlist {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#fqdns FirewallPolicy#fqdns}.
     *
     * @stability stable
     */
    readonly fqdns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#ip_addresses FirewallPolicy#ip_addresses}.
     *
     * @stability stable
     */
    readonly ipAddresses?: string[];
}
export declare function firewallPolicyThreatIntelligenceAllowlistToTerraform(struct?: FirewallPolicyThreatIntelligenceAllowlistOutputReference | FirewallPolicyThreatIntelligenceAllowlist): any;
/**
 * @stability stable
 */
export declare class FirewallPolicyThreatIntelligenceAllowlistOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallPolicyThreatIntelligenceAllowlist | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallPolicyThreatIntelligenceAllowlist | undefined);
    private _fqdns?;
    /**
     * @stability stable
     */
    get fqdns(): string[];
    /**
     * @stability stable
     */
    set fqdns(value: string[]);
    /**
     * @stability stable
     */
    resetFqdns(): void;
    /**
     * @stability stable
     */
    get fqdnsInput(): string[] | undefined;
    private _ipAddresses?;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    set ipAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetIpAddresses(): void;
    /**
     * @stability stable
     */
    get ipAddressesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FirewallPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#create FirewallPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#delete FirewallPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#read FirewallPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#update FirewallPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function firewallPolicyTimeoutsToTerraform(struct?: FirewallPolicyTimeoutsOutputReference | FirewallPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class FirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FirewallPolicyTlsCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#key_vault_secret_id FirewallPolicy#key_vault_secret_id}.
     *
     * @stability stable
     */
    readonly keyVaultSecretId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html#name FirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function firewallPolicyTlsCertificateToTerraform(struct?: FirewallPolicyTlsCertificateOutputReference | FirewallPolicyTlsCertificate): any;
/**
 * @stability stable
 */
export declare class FirewallPolicyTlsCertificateOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallPolicyTlsCertificate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallPolicyTlsCertificate | undefined);
    private _keyVaultSecretId?;
    /**
     * @stability stable
     */
    get keyVaultSecretId(): string;
    /**
     * @stability stable
     */
    set keyVaultSecretId(value: string);
    /**
     * @stability stable
     */
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html azurerm_firewall_policy}.
 *
 * @stability stable
 */
export declare class FirewallPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_policy.html azurerm_firewall_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FirewallPolicyConfig);
    private _basePolicyId?;
    /**
     * @stability stable
     */
    get basePolicyId(): string;
    /**
     * @stability stable
     */
    set basePolicyId(value: string);
    /**
     * @stability stable
     */
    resetBasePolicyId(): void;
    /**
     * @stability stable
     */
    get basePolicyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get childPolicies(): string[];
    /**
     * @stability stable
     */
    get firewalls(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _privateIpRanges?;
    /**
     * @stability stable
     */
    get privateIpRanges(): string[];
    /**
     * @stability stable
     */
    set privateIpRanges(value: string[]);
    /**
     * @stability stable
     */
    resetPrivateIpRanges(): void;
    /**
     * @stability stable
     */
    get privateIpRangesInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get ruleCollectionGroups(): string[];
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _threatIntelligenceMode?;
    /**
     * @stability stable
     */
    get threatIntelligenceMode(): string;
    /**
     * @stability stable
     */
    set threatIntelligenceMode(value: string);
    /**
     * @stability stable
     */
    resetThreatIntelligenceMode(): void;
    /**
     * @stability stable
     */
    get threatIntelligenceModeInput(): string | undefined;
    private _dns;
    /**
     * @stability stable
     */
    get dns(): FirewallPolicyDnsOutputReference;
    /**
     * @stability stable
     */
    putDns(value: FirewallPolicyDns): void;
    /**
     * @stability stable
     */
    resetDns(): void;
    /**
     * @stability stable
     */
    get dnsInput(): FirewallPolicyDns | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): FirewallPolicyIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: FirewallPolicyIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): FirewallPolicyIdentity | undefined;
    private _insights;
    /**
     * @stability stable
     */
    get insights(): FirewallPolicyInsightsOutputReference;
    /**
     * @stability stable
     */
    putInsights(value: FirewallPolicyInsights): void;
    /**
     * @stability stable
     */
    resetInsights(): void;
    /**
     * @stability stable
     */
    get insightsInput(): FirewallPolicyInsights | undefined;
    private _intrusionDetection;
    /**
     * @stability stable
     */
    get intrusionDetection(): FirewallPolicyIntrusionDetectionOutputReference;
    /**
     * @stability stable
     */
    putIntrusionDetection(value: FirewallPolicyIntrusionDetection): void;
    /**
     * @stability stable
     */
    resetIntrusionDetection(): void;
    /**
     * @stability stable
     */
    get intrusionDetectionInput(): FirewallPolicyIntrusionDetection | undefined;
    private _threatIntelligenceAllowlist;
    /**
     * @stability stable
     */
    get threatIntelligenceAllowlist(): FirewallPolicyThreatIntelligenceAllowlistOutputReference;
    /**
     * @stability stable
     */
    putThreatIntelligenceAllowlist(value: FirewallPolicyThreatIntelligenceAllowlist): void;
    /**
     * @stability stable
     */
    resetThreatIntelligenceAllowlist(): void;
    /**
     * @stability stable
     */
    get threatIntelligenceAllowlistInput(): FirewallPolicyThreatIntelligenceAllowlist | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FirewallPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FirewallPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FirewallPolicyTimeouts | undefined;
    private _tlsCertificate;
    /**
     * @stability stable
     */
    get tlsCertificate(): FirewallPolicyTlsCertificateOutputReference;
    /**
     * @stability stable
     */
    putTlsCertificate(value: FirewallPolicyTlsCertificate): void;
    /**
     * @stability stable
     */
    resetTlsCertificate(): void;
    /**
     * @stability stable
     */
    get tlsCertificateInput(): FirewallPolicyTlsCertificate | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
