import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FrontdoorRulesEngineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#enabled FrontdoorRulesEngine#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#frontdoor_name FrontdoorRulesEngine#frontdoor_name}.
     *
     * @stability stable
     */
    readonly frontdoorName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#name FrontdoorRulesEngine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#resource_group_name FrontdoorRulesEngine#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#rule FrontdoorRulesEngine#rule}
     *
     * @stability stable
     */
    readonly rule?: FrontdoorRulesEngineRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#timeouts FrontdoorRulesEngine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FrontdoorRulesEngineTimeouts;
}
/**
 * @stability stable
 */
export interface FrontdoorRulesEngineRuleActionRequestHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#header_action_type FrontdoorRulesEngine#header_action_type}.
     *
     * @stability stable
     */
    readonly headerActionType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#header_name FrontdoorRulesEngine#header_name}.
     *
     * @stability stable
     */
    readonly headerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#value FrontdoorRulesEngine#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function frontdoorRulesEngineRuleActionRequestHeaderToTerraform(struct?: FrontdoorRulesEngineRuleActionRequestHeader): any;
/**
 * @stability stable
 */
export interface FrontdoorRulesEngineRuleActionResponseHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#header_action_type FrontdoorRulesEngine#header_action_type}.
     *
     * @stability stable
     */
    readonly headerActionType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#header_name FrontdoorRulesEngine#header_name}.
     *
     * @stability stable
     */
    readonly headerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#value FrontdoorRulesEngine#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function frontdoorRulesEngineRuleActionResponseHeaderToTerraform(struct?: FrontdoorRulesEngineRuleActionResponseHeader): any;
/**
 * @stability stable
 */
export interface FrontdoorRulesEngineRuleAction {
    /**
     * request_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#request_header FrontdoorRulesEngine#request_header}
     *
     * @stability stable
     */
    readonly requestHeader?: FrontdoorRulesEngineRuleActionRequestHeader[];
    /**
     * response_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#response_header FrontdoorRulesEngine#response_header}
     *
     * @stability stable
     */
    readonly responseHeader?: FrontdoorRulesEngineRuleActionResponseHeader[];
}
export declare function frontdoorRulesEngineRuleActionToTerraform(struct?: FrontdoorRulesEngineRuleActionOutputReference | FrontdoorRulesEngineRuleAction): any;
/**
 * @stability stable
 */
export declare class FrontdoorRulesEngineRuleActionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorRulesEngineRuleAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorRulesEngineRuleAction | undefined);
    private _requestHeader?;
    /**
     * @stability stable
     */
    get requestHeader(): FrontdoorRulesEngineRuleActionRequestHeader[];
    /**
     * @stability stable
     */
    set requestHeader(value: FrontdoorRulesEngineRuleActionRequestHeader[]);
    /**
     * @stability stable
     */
    resetRequestHeader(): void;
    /**
     * @stability stable
     */
    get requestHeaderInput(): FrontdoorRulesEngineRuleActionRequestHeader[] | undefined;
    private _responseHeader?;
    /**
     * @stability stable
     */
    get responseHeader(): FrontdoorRulesEngineRuleActionResponseHeader[];
    /**
     * @stability stable
     */
    set responseHeader(value: FrontdoorRulesEngineRuleActionResponseHeader[]);
    /**
     * @stability stable
     */
    resetResponseHeader(): void;
    /**
     * @stability stable
     */
    get responseHeaderInput(): FrontdoorRulesEngineRuleActionResponseHeader[] | undefined;
}
/**
 * @stability stable
 */
export interface FrontdoorRulesEngineRuleMatchCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#negate_condition FrontdoorRulesEngine#negate_condition}.
     *
     * @stability stable
     */
    readonly negateCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#operator FrontdoorRulesEngine#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#selector FrontdoorRulesEngine#selector}.
     *
     * @stability stable
     */
    readonly selector?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#transform FrontdoorRulesEngine#transform}.
     *
     * @stability stable
     */
    readonly transform?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#value FrontdoorRulesEngine#value}.
     *
     * @stability stable
     */
    readonly value?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#variable FrontdoorRulesEngine#variable}.
     *
     * @stability stable
     */
    readonly variable?: string;
}
export declare function frontdoorRulesEngineRuleMatchConditionToTerraform(struct?: FrontdoorRulesEngineRuleMatchCondition): any;
/**
 * @stability stable
 */
export interface FrontdoorRulesEngineRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#name FrontdoorRulesEngine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#priority FrontdoorRulesEngine#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#action FrontdoorRulesEngine#action}
     *
     * @stability stable
     */
    readonly action?: FrontdoorRulesEngineRuleAction;
    /**
     * match_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#match_condition FrontdoorRulesEngine#match_condition}
     *
     * @stability stable
     */
    readonly matchCondition?: FrontdoorRulesEngineRuleMatchCondition[];
}
export declare function frontdoorRulesEngineRuleToTerraform(struct?: FrontdoorRulesEngineRule): any;
/**
 * @stability stable
 */
export interface FrontdoorRulesEngineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#create FrontdoorRulesEngine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#delete FrontdoorRulesEngine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#read FrontdoorRulesEngine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html#update FrontdoorRulesEngine#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function frontdoorRulesEngineTimeoutsToTerraform(struct?: FrontdoorRulesEngineTimeoutsOutputReference | FrontdoorRulesEngineTimeouts): any;
/**
 * @stability stable
 */
export declare class FrontdoorRulesEngineTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorRulesEngineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorRulesEngineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html azurerm_frontdoor_rules_engine}.
 *
 * @stability stable
 */
export declare class FrontdoorRulesEngine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_rules_engine.html azurerm_frontdoor_rules_engine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FrontdoorRulesEngineConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frontdoorName?;
    /**
     * @stability stable
     */
    get frontdoorName(): string;
    /**
     * @stability stable
     */
    set frontdoorName(value: string);
    /**
     * @stability stable
     */
    get frontdoorNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _rule?;
    /**
     * @stability stable
     */
    get rule(): FrontdoorRulesEngineRule[];
    /**
     * @stability stable
     */
    set rule(value: FrontdoorRulesEngineRule[]);
    /**
     * @stability stable
     */
    resetRule(): void;
    /**
     * @stability stable
     */
    get ruleInput(): FrontdoorRulesEngineRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FrontdoorRulesEngineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FrontdoorRulesEngineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FrontdoorRulesEngineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
