import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HpcCacheNfsTargetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#cache_name HpcCacheNfsTarget#cache_name}.
     *
     * @stability stable
     */
    readonly cacheName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#name HpcCacheNfsTarget#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#resource_group_name HpcCacheNfsTarget#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#target_host_name HpcCacheNfsTarget#target_host_name}.
     *
     * @stability stable
     */
    readonly targetHostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#usage_model HpcCacheNfsTarget#usage_model}.
     *
     * @stability stable
     */
    readonly usageModel: string;
    /**
     * namespace_junction block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#namespace_junction HpcCacheNfsTarget#namespace_junction}
     *
     * @stability stable
     */
    readonly namespaceJunction: HpcCacheNfsTargetNamespaceJunction[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#timeouts HpcCacheNfsTarget#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HpcCacheNfsTargetTimeouts;
}
/**
 * @stability stable
 */
export interface HpcCacheNfsTargetNamespaceJunction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#access_policy_name HpcCacheNfsTarget#access_policy_name}.
     *
     * @stability stable
     */
    readonly accessPolicyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#namespace_path HpcCacheNfsTarget#namespace_path}.
     *
     * @stability stable
     */
    readonly namespacePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#nfs_export HpcCacheNfsTarget#nfs_export}.
     *
     * @stability stable
     */
    readonly nfsExport: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#target_path HpcCacheNfsTarget#target_path}.
     *
     * @stability stable
     */
    readonly targetPath?: string;
}
export declare function hpcCacheNfsTargetNamespaceJunctionToTerraform(struct?: HpcCacheNfsTargetNamespaceJunction): any;
/**
 * @stability stable
 */
export interface HpcCacheNfsTargetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#create HpcCacheNfsTarget#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#delete HpcCacheNfsTarget#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#read HpcCacheNfsTarget#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html#update HpcCacheNfsTarget#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hpcCacheNfsTargetTimeoutsToTerraform(struct?: HpcCacheNfsTargetTimeoutsOutputReference | HpcCacheNfsTargetTimeouts): any;
/**
 * @stability stable
 */
export declare class HpcCacheNfsTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheNfsTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheNfsTargetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html azurerm_hpc_cache_nfs_target}.
 *
 * @stability stable
 */
export declare class HpcCacheNfsTarget extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_nfs_target.html azurerm_hpc_cache_nfs_target} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HpcCacheNfsTargetConfig);
    private _cacheName?;
    /**
     * @stability stable
     */
    get cacheName(): string;
    /**
     * @stability stable
     */
    set cacheName(value: string);
    /**
     * @stability stable
     */
    get cacheNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _targetHostName?;
    /**
     * @stability stable
     */
    get targetHostName(): string;
    /**
     * @stability stable
     */
    set targetHostName(value: string);
    /**
     * @stability stable
     */
    get targetHostNameInput(): string | undefined;
    private _usageModel?;
    /**
     * @stability stable
     */
    get usageModel(): string;
    /**
     * @stability stable
     */
    set usageModel(value: string);
    /**
     * @stability stable
     */
    get usageModelInput(): string | undefined;
    private _namespaceJunction?;
    /**
     * @stability stable
     */
    get namespaceJunction(): HpcCacheNfsTargetNamespaceJunction[];
    /**
     * @stability stable
     */
    set namespaceJunction(value: HpcCacheNfsTargetNamespaceJunction[]);
    /**
     * @stability stable
     */
    get namespaceJunctionInput(): HpcCacheNfsTargetNamespaceJunction[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HpcCacheNfsTargetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HpcCacheNfsTargetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HpcCacheNfsTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
