import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KeyVaultKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#curve KeyVaultKey#curve}.
     *
     * @stability stable
     */
    readonly curve?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#expiration_date KeyVaultKey#expiration_date}.
     *
     * @stability stable
     */
    readonly expirationDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#key_opts KeyVaultKey#key_opts}.
     *
     * @stability stable
     */
    readonly keyOpts: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#key_size KeyVaultKey#key_size}.
     *
     * @stability stable
     */
    readonly keySize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#key_type KeyVaultKey#key_type}.
     *
     * @stability stable
     */
    readonly keyType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#key_vault_id KeyVaultKey#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#name KeyVaultKey#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#not_before_date KeyVaultKey#not_before_date}.
     *
     * @stability stable
     */
    readonly notBeforeDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#tags KeyVaultKey#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#timeouts KeyVaultKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KeyVaultKeyTimeouts;
}
/**
 * @stability stable
 */
export interface KeyVaultKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#create KeyVaultKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#delete KeyVaultKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#read KeyVaultKey#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html#update KeyVaultKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function keyVaultKeyTimeoutsToTerraform(struct?: KeyVaultKeyTimeoutsOutputReference | KeyVaultKeyTimeouts): any;
/**
 * @stability stable
 */
export declare class KeyVaultKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultKeyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html azurerm_key_vault_key}.
 *
 * @stability stable
 */
export declare class KeyVaultKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_key.html azurerm_key_vault_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KeyVaultKeyConfig);
    private _curve?;
    /**
     * @stability stable
     */
    get curve(): string;
    /**
     * @stability stable
     */
    set curve(value: string);
    /**
     * @stability stable
     */
    resetCurve(): void;
    /**
     * @stability stable
     */
    get curveInput(): string | undefined;
    /**
     * @stability stable
     */
    get e(): string;
    private _expirationDate?;
    /**
     * @stability stable
     */
    get expirationDate(): string;
    /**
     * @stability stable
     */
    set expirationDate(value: string);
    /**
     * @stability stable
     */
    resetExpirationDate(): void;
    /**
     * @stability stable
     */
    get expirationDateInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyOpts?;
    /**
     * @stability stable
     */
    get keyOpts(): string[];
    /**
     * @stability stable
     */
    set keyOpts(value: string[]);
    /**
     * @stability stable
     */
    get keyOptsInput(): string[] | undefined;
    private _keySize?;
    /**
     * @stability stable
     */
    get keySize(): number;
    /**
     * @stability stable
     */
    set keySize(value: number);
    /**
     * @stability stable
     */
    resetKeySize(): void;
    /**
     * @stability stable
     */
    get keySizeInput(): number | undefined;
    private _keyType?;
    /**
     * @stability stable
     */
    get keyType(): string;
    /**
     * @stability stable
     */
    set keyType(value: string);
    /**
     * @stability stable
     */
    get keyTypeInput(): string | undefined;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get n(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _notBeforeDate?;
    /**
     * @stability stable
     */
    get notBeforeDate(): string;
    /**
     * @stability stable
     */
    set notBeforeDate(value: string);
    /**
     * @stability stable
     */
    resetNotBeforeDate(): void;
    /**
     * @stability stable
     */
    get notBeforeDateInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicKeyOpenssh(): string;
    /**
     * @stability stable
     */
    get publicKeyPem(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    get versionlessId(): string;
    /**
     * @stability stable
     */
    get x(): string;
    /**
     * @stability stable
     */
    get y(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KeyVaultKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KeyVaultKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KeyVaultKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
