"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesClusterNodePool = exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = exports.KubernetesClusterNodePoolTimeoutsOutputReference = exports.kubernetesClusterNodePoolTimeoutsToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = exports.KubernetesClusterNodePoolKubeletConfigOutputReference = exports.kubernetesClusterNodePoolKubeletConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function kubernetesClusterNodePoolKubeletConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_unsafe_sysctls: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedUnsafeSysctls),
        container_log_max_line: cdktf.numberToTerraform(struct.containerLogMaxLine),
        container_log_max_size_mb: cdktf.numberToTerraform(struct.containerLogMaxSizeMb),
        cpu_cfs_quota_enabled: cdktf.booleanToTerraform(struct.cpuCfsQuotaEnabled),
        cpu_cfs_quota_period: cdktf.stringToTerraform(struct.cpuCfsQuotaPeriod),
        cpu_manager_policy: cdktf.stringToTerraform(struct.cpuManagerPolicy),
        image_gc_high_threshold: cdktf.numberToTerraform(struct.imageGcHighThreshold),
        image_gc_low_threshold: cdktf.numberToTerraform(struct.imageGcLowThreshold),
        pod_max_pid: cdktf.numberToTerraform(struct.podMaxPid),
        topology_manager_policy: cdktf.stringToTerraform(struct.topologyManagerPolicy),
    };
}
exports.kubernetesClusterNodePoolKubeletConfigToTerraform = kubernetesClusterNodePoolKubeletConfigToTerraform;
/**
 * @stability stable
 */
class KubernetesClusterNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._allowedUnsafeSysctls) {
            hasAnyValues = true;
            internalValueResult.allowedUnsafeSysctls = this._allowedUnsafeSysctls;
        }
        if (this._containerLogMaxLine) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxLine = this._containerLogMaxLine;
        }
        if (this._containerLogMaxSizeMb) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxSizeMb = this._containerLogMaxSizeMb;
        }
        if (this._cpuCfsQuotaEnabled) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaEnabled = this._cpuCfsQuotaEnabled;
        }
        if (this._cpuCfsQuotaPeriod) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaPeriod = this._cpuCfsQuotaPeriod;
        }
        if (this._cpuManagerPolicy) {
            hasAnyValues = true;
            internalValueResult.cpuManagerPolicy = this._cpuManagerPolicy;
        }
        if (this._imageGcHighThreshold) {
            hasAnyValues = true;
            internalValueResult.imageGcHighThreshold = this._imageGcHighThreshold;
        }
        if (this._imageGcLowThreshold) {
            hasAnyValues = true;
            internalValueResult.imageGcLowThreshold = this._imageGcLowThreshold;
        }
        if (this._podMaxPid) {
            hasAnyValues = true;
            internalValueResult.podMaxPid = this._podMaxPid;
        }
        if (this._topologyManagerPolicy) {
            hasAnyValues = true;
            internalValueResult.topologyManagerPolicy = this._topologyManagerPolicy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._allowedUnsafeSysctls = undefined;
            this._containerLogMaxLine = undefined;
            this._containerLogMaxSizeMb = undefined;
            this._cpuCfsQuotaEnabled = undefined;
            this._cpuCfsQuotaPeriod = undefined;
            this._cpuManagerPolicy = undefined;
            this._imageGcHighThreshold = undefined;
            this._imageGcLowThreshold = undefined;
            this._podMaxPid = undefined;
            this._topologyManagerPolicy = undefined;
        }
        else {
            this._allowedUnsafeSysctls = value.allowedUnsafeSysctls;
            this._containerLogMaxLine = value.containerLogMaxLine;
            this._containerLogMaxSizeMb = value.containerLogMaxSizeMb;
            this._cpuCfsQuotaEnabled = value.cpuCfsQuotaEnabled;
            this._cpuCfsQuotaPeriod = value.cpuCfsQuotaPeriod;
            this._cpuManagerPolicy = value.cpuManagerPolicy;
            this._imageGcHighThreshold = value.imageGcHighThreshold;
            this._imageGcLowThreshold = value.imageGcLowThreshold;
            this._podMaxPid = value.podMaxPid;
            this._topologyManagerPolicy = value.topologyManagerPolicy;
        }
    }
    /**
     * @stability stable
     */
    get allowedUnsafeSysctls() {
        return this.getListAttribute('allowed_unsafe_sysctls');
    }
    /**
     * @stability stable
     */
    set allowedUnsafeSysctls(value) {
        this._allowedUnsafeSysctls = value;
    }
    /**
     * @stability stable
     */
    resetAllowedUnsafeSysctls() {
        this._allowedUnsafeSysctls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get allowedUnsafeSysctlsInput() {
        return this._allowedUnsafeSysctls;
    }
    /**
     * @stability stable
     */
    get containerLogMaxLine() {
        return this.getNumberAttribute('container_log_max_line');
    }
    /**
     * @stability stable
     */
    set containerLogMaxLine(value) {
        this._containerLogMaxLine = value;
    }
    /**
     * @stability stable
     */
    resetContainerLogMaxLine() {
        this._containerLogMaxLine = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerLogMaxLineInput() {
        return this._containerLogMaxLine;
    }
    /**
     * @stability stable
     */
    get containerLogMaxSizeMb() {
        return this.getNumberAttribute('container_log_max_size_mb');
    }
    /**
     * @stability stable
     */
    set containerLogMaxSizeMb(value) {
        this._containerLogMaxSizeMb = value;
    }
    /**
     * @stability stable
     */
    resetContainerLogMaxSizeMb() {
        this._containerLogMaxSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get containerLogMaxSizeMbInput() {
        return this._containerLogMaxSizeMb;
    }
    /**
     * @stability stable
     */
    get cpuCfsQuotaEnabled() {
        return this.getBooleanAttribute('cpu_cfs_quota_enabled');
    }
    /**
     * @stability stable
     */
    set cpuCfsQuotaEnabled(value) {
        this._cpuCfsQuotaEnabled = value;
    }
    /**
     * @stability stable
     */
    resetCpuCfsQuotaEnabled() {
        this._cpuCfsQuotaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cpuCfsQuotaEnabledInput() {
        return this._cpuCfsQuotaEnabled;
    }
    /**
     * @stability stable
     */
    get cpuCfsQuotaPeriod() {
        return this.getStringAttribute('cpu_cfs_quota_period');
    }
    /**
     * @stability stable
     */
    set cpuCfsQuotaPeriod(value) {
        this._cpuCfsQuotaPeriod = value;
    }
    /**
     * @stability stable
     */
    resetCpuCfsQuotaPeriod() {
        this._cpuCfsQuotaPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cpuCfsQuotaPeriodInput() {
        return this._cpuCfsQuotaPeriod;
    }
    /**
     * @stability stable
     */
    get cpuManagerPolicy() {
        return this.getStringAttribute('cpu_manager_policy');
    }
    /**
     * @stability stable
     */
    set cpuManagerPolicy(value) {
        this._cpuManagerPolicy = value;
    }
    /**
     * @stability stable
     */
    resetCpuManagerPolicy() {
        this._cpuManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get cpuManagerPolicyInput() {
        return this._cpuManagerPolicy;
    }
    /**
     * @stability stable
     */
    get imageGcHighThreshold() {
        return this.getNumberAttribute('image_gc_high_threshold');
    }
    /**
     * @stability stable
     */
    set imageGcHighThreshold(value) {
        this._imageGcHighThreshold = value;
    }
    /**
     * @stability stable
     */
    resetImageGcHighThreshold() {
        this._imageGcHighThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get imageGcHighThresholdInput() {
        return this._imageGcHighThreshold;
    }
    /**
     * @stability stable
     */
    get imageGcLowThreshold() {
        return this.getNumberAttribute('image_gc_low_threshold');
    }
    /**
     * @stability stable
     */
    set imageGcLowThreshold(value) {
        this._imageGcLowThreshold = value;
    }
    /**
     * @stability stable
     */
    resetImageGcLowThreshold() {
        this._imageGcLowThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get imageGcLowThresholdInput() {
        return this._imageGcLowThreshold;
    }
    /**
     * @stability stable
     */
    get podMaxPid() {
        return this.getNumberAttribute('pod_max_pid');
    }
    /**
     * @stability stable
     */
    set podMaxPid(value) {
        this._podMaxPid = value;
    }
    /**
     * @stability stable
     */
    resetPodMaxPid() {
        this._podMaxPid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get podMaxPidInput() {
        return this._podMaxPid;
    }
    /**
     * @stability stable
     */
    get topologyManagerPolicy() {
        return this.getStringAttribute('topology_manager_policy');
    }
    /**
     * @stability stable
     */
    set topologyManagerPolicy(value) {
        this._topologyManagerPolicy = value;
    }
    /**
     * @stability stable
     */
    resetTopologyManagerPolicy() {
        this._topologyManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get topologyManagerPolicyInput() {
        return this._topologyManagerPolicy;
    }
}
exports.KubernetesClusterNodePoolKubeletConfigOutputReference = KubernetesClusterNodePoolKubeletConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolKubeletConfigOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolKubeletConfigOutputReference", version: "0.3.0" };
function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fs_aio_max_nr: cdktf.numberToTerraform(struct.fsAioMaxNr),
        fs_file_max: cdktf.numberToTerraform(struct.fsFileMax),
        fs_inotify_max_user_watches: cdktf.numberToTerraform(struct.fsInotifyMaxUserWatches),
        fs_nr_open: cdktf.numberToTerraform(struct.fsNrOpen),
        kernel_threads_max: cdktf.numberToTerraform(struct.kernelThreadsMax),
        net_core_netdev_max_backlog: cdktf.numberToTerraform(struct.netCoreNetdevMaxBacklog),
        net_core_optmem_max: cdktf.numberToTerraform(struct.netCoreOptmemMax),
        net_core_rmem_default: cdktf.numberToTerraform(struct.netCoreRmemDefault),
        net_core_rmem_max: cdktf.numberToTerraform(struct.netCoreRmemMax),
        net_core_somaxconn: cdktf.numberToTerraform(struct.netCoreSomaxconn),
        net_core_wmem_default: cdktf.numberToTerraform(struct.netCoreWmemDefault),
        net_core_wmem_max: cdktf.numberToTerraform(struct.netCoreWmemMax),
        net_ipv4_ip_local_port_range_max: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMax),
        net_ipv4_ip_local_port_range_min: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMin),
        net_ipv4_neigh_default_gc_thresh1: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh1),
        net_ipv4_neigh_default_gc_thresh2: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh2),
        net_ipv4_neigh_default_gc_thresh3: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh3),
        net_ipv4_tcp_fin_timeout: cdktf.numberToTerraform(struct.netIpv4TcpFinTimeout),
        net_ipv4_tcp_keepalive_intvl: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveIntvl),
        net_ipv4_tcp_keepalive_probes: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveProbes),
        net_ipv4_tcp_keepalive_time: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveTime),
        net_ipv4_tcp_max_syn_backlog: cdktf.numberToTerraform(struct.netIpv4TcpMaxSynBacklog),
        net_ipv4_tcp_max_tw_buckets: cdktf.numberToTerraform(struct.netIpv4TcpMaxTwBuckets),
        net_ipv4_tcp_tw_reuse: cdktf.booleanToTerraform(struct.netIpv4TcpTwReuse),
        net_netfilter_nf_conntrack_buckets: cdktf.numberToTerraform(struct.netNetfilterNfConntrackBuckets),
        net_netfilter_nf_conntrack_max: cdktf.numberToTerraform(struct.netNetfilterNfConntrackMax),
        vm_max_map_count: cdktf.numberToTerraform(struct.vmMaxMapCount),
        vm_swappiness: cdktf.numberToTerraform(struct.vmSwappiness),
        vm_vfs_cache_pressure: cdktf.numberToTerraform(struct.vmVfsCachePressure),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform;
/**
 * @stability stable
 */
class KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._fsAioMaxNr) {
            hasAnyValues = true;
            internalValueResult.fsAioMaxNr = this._fsAioMaxNr;
        }
        if (this._fsFileMax) {
            hasAnyValues = true;
            internalValueResult.fsFileMax = this._fsFileMax;
        }
        if (this._fsInotifyMaxUserWatches) {
            hasAnyValues = true;
            internalValueResult.fsInotifyMaxUserWatches = this._fsInotifyMaxUserWatches;
        }
        if (this._fsNrOpen) {
            hasAnyValues = true;
            internalValueResult.fsNrOpen = this._fsNrOpen;
        }
        if (this._kernelThreadsMax) {
            hasAnyValues = true;
            internalValueResult.kernelThreadsMax = this._kernelThreadsMax;
        }
        if (this._netCoreNetdevMaxBacklog) {
            hasAnyValues = true;
            internalValueResult.netCoreNetdevMaxBacklog = this._netCoreNetdevMaxBacklog;
        }
        if (this._netCoreOptmemMax) {
            hasAnyValues = true;
            internalValueResult.netCoreOptmemMax = this._netCoreOptmemMax;
        }
        if (this._netCoreRmemDefault) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemDefault = this._netCoreRmemDefault;
        }
        if (this._netCoreRmemMax) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemMax = this._netCoreRmemMax;
        }
        if (this._netCoreSomaxconn) {
            hasAnyValues = true;
            internalValueResult.netCoreSomaxconn = this._netCoreSomaxconn;
        }
        if (this._netCoreWmemDefault) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemDefault = this._netCoreWmemDefault;
        }
        if (this._netCoreWmemMax) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemMax = this._netCoreWmemMax;
        }
        if (this._netIpv4IpLocalPortRangeMax) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMax = this._netIpv4IpLocalPortRangeMax;
        }
        if (this._netIpv4IpLocalPortRangeMin) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMin = this._netIpv4IpLocalPortRangeMin;
        }
        if (this._netIpv4NeighDefaultGcThresh1) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh1 = this._netIpv4NeighDefaultGcThresh1;
        }
        if (this._netIpv4NeighDefaultGcThresh2) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh2 = this._netIpv4NeighDefaultGcThresh2;
        }
        if (this._netIpv4NeighDefaultGcThresh3) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh3 = this._netIpv4NeighDefaultGcThresh3;
        }
        if (this._netIpv4TcpFinTimeout) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpFinTimeout = this._netIpv4TcpFinTimeout;
        }
        if (this._netIpv4TcpKeepaliveIntvl) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveIntvl = this._netIpv4TcpKeepaliveIntvl;
        }
        if (this._netIpv4TcpKeepaliveProbes) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveProbes = this._netIpv4TcpKeepaliveProbes;
        }
        if (this._netIpv4TcpKeepaliveTime) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveTime = this._netIpv4TcpKeepaliveTime;
        }
        if (this._netIpv4TcpMaxSynBacklog) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxSynBacklog = this._netIpv4TcpMaxSynBacklog;
        }
        if (this._netIpv4TcpMaxTwBuckets) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxTwBuckets = this._netIpv4TcpMaxTwBuckets;
        }
        if (this._netIpv4TcpTwReuse) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpTwReuse = this._netIpv4TcpTwReuse;
        }
        if (this._netNetfilterNfConntrackBuckets) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackBuckets = this._netNetfilterNfConntrackBuckets;
        }
        if (this._netNetfilterNfConntrackMax) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackMax = this._netNetfilterNfConntrackMax;
        }
        if (this._vmMaxMapCount) {
            hasAnyValues = true;
            internalValueResult.vmMaxMapCount = this._vmMaxMapCount;
        }
        if (this._vmSwappiness) {
            hasAnyValues = true;
            internalValueResult.vmSwappiness = this._vmSwappiness;
        }
        if (this._vmVfsCachePressure) {
            hasAnyValues = true;
            internalValueResult.vmVfsCachePressure = this._vmVfsCachePressure;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._fsAioMaxNr = undefined;
            this._fsFileMax = undefined;
            this._fsInotifyMaxUserWatches = undefined;
            this._fsNrOpen = undefined;
            this._kernelThreadsMax = undefined;
            this._netCoreNetdevMaxBacklog = undefined;
            this._netCoreOptmemMax = undefined;
            this._netCoreRmemDefault = undefined;
            this._netCoreRmemMax = undefined;
            this._netCoreSomaxconn = undefined;
            this._netCoreWmemDefault = undefined;
            this._netCoreWmemMax = undefined;
            this._netIpv4IpLocalPortRangeMax = undefined;
            this._netIpv4IpLocalPortRangeMin = undefined;
            this._netIpv4NeighDefaultGcThresh1 = undefined;
            this._netIpv4NeighDefaultGcThresh2 = undefined;
            this._netIpv4NeighDefaultGcThresh3 = undefined;
            this._netIpv4TcpFinTimeout = undefined;
            this._netIpv4TcpKeepaliveIntvl = undefined;
            this._netIpv4TcpKeepaliveProbes = undefined;
            this._netIpv4TcpKeepaliveTime = undefined;
            this._netIpv4TcpMaxSynBacklog = undefined;
            this._netIpv4TcpMaxTwBuckets = undefined;
            this._netIpv4TcpTwReuse = undefined;
            this._netNetfilterNfConntrackBuckets = undefined;
            this._netNetfilterNfConntrackMax = undefined;
            this._vmMaxMapCount = undefined;
            this._vmSwappiness = undefined;
            this._vmVfsCachePressure = undefined;
        }
        else {
            this._fsAioMaxNr = value.fsAioMaxNr;
            this._fsFileMax = value.fsFileMax;
            this._fsInotifyMaxUserWatches = value.fsInotifyMaxUserWatches;
            this._fsNrOpen = value.fsNrOpen;
            this._kernelThreadsMax = value.kernelThreadsMax;
            this._netCoreNetdevMaxBacklog = value.netCoreNetdevMaxBacklog;
            this._netCoreOptmemMax = value.netCoreOptmemMax;
            this._netCoreRmemDefault = value.netCoreRmemDefault;
            this._netCoreRmemMax = value.netCoreRmemMax;
            this._netCoreSomaxconn = value.netCoreSomaxconn;
            this._netCoreWmemDefault = value.netCoreWmemDefault;
            this._netCoreWmemMax = value.netCoreWmemMax;
            this._netIpv4IpLocalPortRangeMax = value.netIpv4IpLocalPortRangeMax;
            this._netIpv4IpLocalPortRangeMin = value.netIpv4IpLocalPortRangeMin;
            this._netIpv4NeighDefaultGcThresh1 = value.netIpv4NeighDefaultGcThresh1;
            this._netIpv4NeighDefaultGcThresh2 = value.netIpv4NeighDefaultGcThresh2;
            this._netIpv4NeighDefaultGcThresh3 = value.netIpv4NeighDefaultGcThresh3;
            this._netIpv4TcpFinTimeout = value.netIpv4TcpFinTimeout;
            this._netIpv4TcpKeepaliveIntvl = value.netIpv4TcpKeepaliveIntvl;
            this._netIpv4TcpKeepaliveProbes = value.netIpv4TcpKeepaliveProbes;
            this._netIpv4TcpKeepaliveTime = value.netIpv4TcpKeepaliveTime;
            this._netIpv4TcpMaxSynBacklog = value.netIpv4TcpMaxSynBacklog;
            this._netIpv4TcpMaxTwBuckets = value.netIpv4TcpMaxTwBuckets;
            this._netIpv4TcpTwReuse = value.netIpv4TcpTwReuse;
            this._netNetfilterNfConntrackBuckets = value.netNetfilterNfConntrackBuckets;
            this._netNetfilterNfConntrackMax = value.netNetfilterNfConntrackMax;
            this._vmMaxMapCount = value.vmMaxMapCount;
            this._vmSwappiness = value.vmSwappiness;
            this._vmVfsCachePressure = value.vmVfsCachePressure;
        }
    }
    /**
     * @stability stable
     */
    get fsAioMaxNr() {
        return this.getNumberAttribute('fs_aio_max_nr');
    }
    /**
     * @stability stable
     */
    set fsAioMaxNr(value) {
        this._fsAioMaxNr = value;
    }
    /**
     * @stability stable
     */
    resetFsAioMaxNr() {
        this._fsAioMaxNr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get fsAioMaxNrInput() {
        return this._fsAioMaxNr;
    }
    /**
     * @stability stable
     */
    get fsFileMax() {
        return this.getNumberAttribute('fs_file_max');
    }
    /**
     * @stability stable
     */
    set fsFileMax(value) {
        this._fsFileMax = value;
    }
    /**
     * @stability stable
     */
    resetFsFileMax() {
        this._fsFileMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get fsFileMaxInput() {
        return this._fsFileMax;
    }
    /**
     * @stability stable
     */
    get fsInotifyMaxUserWatches() {
        return this.getNumberAttribute('fs_inotify_max_user_watches');
    }
    /**
     * @stability stable
     */
    set fsInotifyMaxUserWatches(value) {
        this._fsInotifyMaxUserWatches = value;
    }
    /**
     * @stability stable
     */
    resetFsInotifyMaxUserWatches() {
        this._fsInotifyMaxUserWatches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get fsInotifyMaxUserWatchesInput() {
        return this._fsInotifyMaxUserWatches;
    }
    /**
     * @stability stable
     */
    get fsNrOpen() {
        return this.getNumberAttribute('fs_nr_open');
    }
    /**
     * @stability stable
     */
    set fsNrOpen(value) {
        this._fsNrOpen = value;
    }
    /**
     * @stability stable
     */
    resetFsNrOpen() {
        this._fsNrOpen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get fsNrOpenInput() {
        return this._fsNrOpen;
    }
    /**
     * @stability stable
     */
    get kernelThreadsMax() {
        return this.getNumberAttribute('kernel_threads_max');
    }
    /**
     * @stability stable
     */
    set kernelThreadsMax(value) {
        this._kernelThreadsMax = value;
    }
    /**
     * @stability stable
     */
    resetKernelThreadsMax() {
        this._kernelThreadsMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get kernelThreadsMaxInput() {
        return this._kernelThreadsMax;
    }
    /**
     * @stability stable
     */
    get netCoreNetdevMaxBacklog() {
        return this.getNumberAttribute('net_core_netdev_max_backlog');
    }
    /**
     * @stability stable
     */
    set netCoreNetdevMaxBacklog(value) {
        this._netCoreNetdevMaxBacklog = value;
    }
    /**
     * @stability stable
     */
    resetNetCoreNetdevMaxBacklog() {
        this._netCoreNetdevMaxBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netCoreNetdevMaxBacklogInput() {
        return this._netCoreNetdevMaxBacklog;
    }
    /**
     * @stability stable
     */
    get netCoreOptmemMax() {
        return this.getNumberAttribute('net_core_optmem_max');
    }
    /**
     * @stability stable
     */
    set netCoreOptmemMax(value) {
        this._netCoreOptmemMax = value;
    }
    /**
     * @stability stable
     */
    resetNetCoreOptmemMax() {
        this._netCoreOptmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netCoreOptmemMaxInput() {
        return this._netCoreOptmemMax;
    }
    /**
     * @stability stable
     */
    get netCoreRmemDefault() {
        return this.getNumberAttribute('net_core_rmem_default');
    }
    /**
     * @stability stable
     */
    set netCoreRmemDefault(value) {
        this._netCoreRmemDefault = value;
    }
    /**
     * @stability stable
     */
    resetNetCoreRmemDefault() {
        this._netCoreRmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netCoreRmemDefaultInput() {
        return this._netCoreRmemDefault;
    }
    /**
     * @stability stable
     */
    get netCoreRmemMax() {
        return this.getNumberAttribute('net_core_rmem_max');
    }
    /**
     * @stability stable
     */
    set netCoreRmemMax(value) {
        this._netCoreRmemMax = value;
    }
    /**
     * @stability stable
     */
    resetNetCoreRmemMax() {
        this._netCoreRmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netCoreRmemMaxInput() {
        return this._netCoreRmemMax;
    }
    /**
     * @stability stable
     */
    get netCoreSomaxconn() {
        return this.getNumberAttribute('net_core_somaxconn');
    }
    /**
     * @stability stable
     */
    set netCoreSomaxconn(value) {
        this._netCoreSomaxconn = value;
    }
    /**
     * @stability stable
     */
    resetNetCoreSomaxconn() {
        this._netCoreSomaxconn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netCoreSomaxconnInput() {
        return this._netCoreSomaxconn;
    }
    /**
     * @stability stable
     */
    get netCoreWmemDefault() {
        return this.getNumberAttribute('net_core_wmem_default');
    }
    /**
     * @stability stable
     */
    set netCoreWmemDefault(value) {
        this._netCoreWmemDefault = value;
    }
    /**
     * @stability stable
     */
    resetNetCoreWmemDefault() {
        this._netCoreWmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netCoreWmemDefaultInput() {
        return this._netCoreWmemDefault;
    }
    /**
     * @stability stable
     */
    get netCoreWmemMax() {
        return this.getNumberAttribute('net_core_wmem_max');
    }
    /**
     * @stability stable
     */
    set netCoreWmemMax(value) {
        this._netCoreWmemMax = value;
    }
    /**
     * @stability stable
     */
    resetNetCoreWmemMax() {
        this._netCoreWmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netCoreWmemMaxInput() {
        return this._netCoreWmemMax;
    }
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMax() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_max');
    }
    /**
     * @stability stable
     */
    set netIpv4IpLocalPortRangeMax(value) {
        this._netIpv4IpLocalPortRangeMax = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4IpLocalPortRangeMax() {
        this._netIpv4IpLocalPortRangeMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMaxInput() {
        return this._netIpv4IpLocalPortRangeMax;
    }
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMin() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_min');
    }
    /**
     * @stability stable
     */
    set netIpv4IpLocalPortRangeMin(value) {
        this._netIpv4IpLocalPortRangeMin = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4IpLocalPortRangeMin() {
        this._netIpv4IpLocalPortRangeMin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMinInput() {
        return this._netIpv4IpLocalPortRangeMin;
    }
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh1() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh1');
    }
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh1(value) {
        this._netIpv4NeighDefaultGcThresh1 = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh1() {
        this._netIpv4NeighDefaultGcThresh1 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh1Input() {
        return this._netIpv4NeighDefaultGcThresh1;
    }
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh2() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh2');
    }
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh2(value) {
        this._netIpv4NeighDefaultGcThresh2 = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh2() {
        this._netIpv4NeighDefaultGcThresh2 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh2Input() {
        return this._netIpv4NeighDefaultGcThresh2;
    }
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh3() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh3');
    }
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh3(value) {
        this._netIpv4NeighDefaultGcThresh3 = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh3() {
        this._netIpv4NeighDefaultGcThresh3 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh3Input() {
        return this._netIpv4NeighDefaultGcThresh3;
    }
    /**
     * @stability stable
     */
    get netIpv4TcpFinTimeout() {
        return this.getNumberAttribute('net_ipv4_tcp_fin_timeout');
    }
    /**
     * @stability stable
     */
    set netIpv4TcpFinTimeout(value) {
        this._netIpv4TcpFinTimeout = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4TcpFinTimeout() {
        this._netIpv4TcpFinTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4TcpFinTimeoutInput() {
        return this._netIpv4TcpFinTimeout;
    }
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveIntvl() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_intvl');
    }
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveIntvl(value) {
        this._netIpv4TcpKeepaliveIntvl = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveIntvl() {
        this._netIpv4TcpKeepaliveIntvl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveIntvlInput() {
        return this._netIpv4TcpKeepaliveIntvl;
    }
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveProbes() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_probes');
    }
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveProbes(value) {
        this._netIpv4TcpKeepaliveProbes = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveProbes() {
        this._netIpv4TcpKeepaliveProbes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveProbesInput() {
        return this._netIpv4TcpKeepaliveProbes;
    }
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveTime() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_time');
    }
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveTime(value) {
        this._netIpv4TcpKeepaliveTime = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveTime() {
        this._netIpv4TcpKeepaliveTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveTimeInput() {
        return this._netIpv4TcpKeepaliveTime;
    }
    /**
     * @stability stable
     */
    get netIpv4TcpMaxSynBacklog() {
        return this.getNumberAttribute('net_ipv4_tcp_max_syn_backlog');
    }
    /**
     * @stability stable
     */
    set netIpv4TcpMaxSynBacklog(value) {
        this._netIpv4TcpMaxSynBacklog = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4TcpMaxSynBacklog() {
        this._netIpv4TcpMaxSynBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4TcpMaxSynBacklogInput() {
        return this._netIpv4TcpMaxSynBacklog;
    }
    /**
     * @stability stable
     */
    get netIpv4TcpMaxTwBuckets() {
        return this.getNumberAttribute('net_ipv4_tcp_max_tw_buckets');
    }
    /**
     * @stability stable
     */
    set netIpv4TcpMaxTwBuckets(value) {
        this._netIpv4TcpMaxTwBuckets = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4TcpMaxTwBuckets() {
        this._netIpv4TcpMaxTwBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4TcpMaxTwBucketsInput() {
        return this._netIpv4TcpMaxTwBuckets;
    }
    /**
     * @stability stable
     */
    get netIpv4TcpTwReuse() {
        return this.getBooleanAttribute('net_ipv4_tcp_tw_reuse');
    }
    /**
     * @stability stable
     */
    set netIpv4TcpTwReuse(value) {
        this._netIpv4TcpTwReuse = value;
    }
    /**
     * @stability stable
     */
    resetNetIpv4TcpTwReuse() {
        this._netIpv4TcpTwReuse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netIpv4TcpTwReuseInput() {
        return this._netIpv4TcpTwReuse;
    }
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackBuckets() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_buckets');
    }
    /**
     * @stability stable
     */
    set netNetfilterNfConntrackBuckets(value) {
        this._netNetfilterNfConntrackBuckets = value;
    }
    /**
     * @stability stable
     */
    resetNetNetfilterNfConntrackBuckets() {
        this._netNetfilterNfConntrackBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackBucketsInput() {
        return this._netNetfilterNfConntrackBuckets;
    }
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackMax() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_max');
    }
    /**
     * @stability stable
     */
    set netNetfilterNfConntrackMax(value) {
        this._netNetfilterNfConntrackMax = value;
    }
    /**
     * @stability stable
     */
    resetNetNetfilterNfConntrackMax() {
        this._netNetfilterNfConntrackMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackMaxInput() {
        return this._netNetfilterNfConntrackMax;
    }
    /**
     * @stability stable
     */
    get vmMaxMapCount() {
        return this.getNumberAttribute('vm_max_map_count');
    }
    /**
     * @stability stable
     */
    set vmMaxMapCount(value) {
        this._vmMaxMapCount = value;
    }
    /**
     * @stability stable
     */
    resetVmMaxMapCount() {
        this._vmMaxMapCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vmMaxMapCountInput() {
        return this._vmMaxMapCount;
    }
    /**
     * @stability stable
     */
    get vmSwappiness() {
        return this.getNumberAttribute('vm_swappiness');
    }
    /**
     * @stability stable
     */
    set vmSwappiness(value) {
        this._vmSwappiness = value;
    }
    /**
     * @stability stable
     */
    resetVmSwappiness() {
        this._vmSwappiness = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vmSwappinessInput() {
        return this._vmSwappiness;
    }
    /**
     * @stability stable
     */
    get vmVfsCachePressure() {
        return this.getNumberAttribute('vm_vfs_cache_pressure');
    }
    /**
     * @stability stable
     */
    set vmVfsCachePressure(value) {
        this._vmVfsCachePressure = value;
    }
    /**
     * @stability stable
     */
    resetVmVfsCachePressure() {
        this._vmVfsCachePressure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vmVfsCachePressureInput() {
        return this._vmVfsCachePressure;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference", version: "0.3.0" };
function kubernetesClusterNodePoolLinuxOsConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        swap_file_size_mb: cdktf.numberToTerraform(struct.swapFileSizeMb),
        transparent_huge_page_defrag: cdktf.stringToTerraform(struct.transparentHugePageDefrag),
        transparent_huge_page_enabled: cdktf.stringToTerraform(struct.transparentHugePageEnabled),
        sysctl_config: kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct.sysctlConfig),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigToTerraform;
/**
 * @stability stable
 */
class KubernetesClusterNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        // sysctl_config - computed: false, optional: true, required: false
        this._sysctlConfig = new KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference(this, "sysctl_config", true);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        var _g;
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._swapFileSizeMb) {
            hasAnyValues = true;
            internalValueResult.swapFileSizeMb = this._swapFileSizeMb;
        }
        if (this._transparentHugePageDefrag) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageDefrag = this._transparentHugePageDefrag;
        }
        if (this._transparentHugePageEnabled) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageEnabled = this._transparentHugePageEnabled;
        }
        if (this._sysctlConfig) {
            hasAnyValues = true;
            internalValueResult.sysctlConfig = (_g = this._sysctlConfig) === null || _g === void 0 ? void 0 : _g.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._swapFileSizeMb = undefined;
            this._transparentHugePageDefrag = undefined;
            this._transparentHugePageEnabled = undefined;
            this._sysctlConfig.internalValue = undefined;
        }
        else {
            this._swapFileSizeMb = value.swapFileSizeMb;
            this._transparentHugePageDefrag = value.transparentHugePageDefrag;
            this._transparentHugePageEnabled = value.transparentHugePageEnabled;
            this._sysctlConfig.internalValue = value.sysctlConfig;
        }
    }
    /**
     * @stability stable
     */
    get swapFileSizeMb() {
        return this.getNumberAttribute('swap_file_size_mb');
    }
    /**
     * @stability stable
     */
    set swapFileSizeMb(value) {
        this._swapFileSizeMb = value;
    }
    /**
     * @stability stable
     */
    resetSwapFileSizeMb() {
        this._swapFileSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get swapFileSizeMbInput() {
        return this._swapFileSizeMb;
    }
    /**
     * @stability stable
     */
    get transparentHugePageDefrag() {
        return this.getStringAttribute('transparent_huge_page_defrag');
    }
    /**
     * @stability stable
     */
    set transparentHugePageDefrag(value) {
        this._transparentHugePageDefrag = value;
    }
    /**
     * @stability stable
     */
    resetTransparentHugePageDefrag() {
        this._transparentHugePageDefrag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get transparentHugePageDefragInput() {
        return this._transparentHugePageDefrag;
    }
    /**
     * @stability stable
     */
    get transparentHugePageEnabled() {
        return this.getStringAttribute('transparent_huge_page_enabled');
    }
    /**
     * @stability stable
     */
    set transparentHugePageEnabled(value) {
        this._transparentHugePageEnabled = value;
    }
    /**
     * @stability stable
     */
    resetTransparentHugePageEnabled() {
        this._transparentHugePageEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get transparentHugePageEnabledInput() {
        return this._transparentHugePageEnabled;
    }
    /**
     * @stability stable
     */
    get sysctlConfig() {
        return this._sysctlConfig;
    }
    /**
     * @stability stable
     */
    putSysctlConfig(value) {
        this._sysctlConfig.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetSysctlConfig() {
        this._sysctlConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get sysctlConfigInput() {
        return this._sysctlConfig.internalValue;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigOutputReference;
_c = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolLinuxOsConfigOutputReference", version: "0.3.0" };
function kubernetesClusterNodePoolTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.kubernetesClusterNodePoolTimeoutsToTerraform = kubernetesClusterNodePoolTimeoutsToTerraform;
/**
 * @stability stable
 */
class KubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._create) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    /**
     * @stability stable
     */
    get create() {
        return this.getStringAttribute('create');
    }
    /**
     * @stability stable
     */
    set create(value) {
        this._create = value;
    }
    /**
     * @stability stable
     */
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get createInput() {
        return this._create;
    }
    /**
     * @stability stable
     */
    get delete() {
        return this.getStringAttribute('delete');
    }
    /**
     * @stability stable
     */
    set delete(value) {
        this._delete = value;
    }
    /**
     * @stability stable
     */
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteInput() {
        return this._delete;
    }
    /**
     * @stability stable
     */
    get read() {
        return this.getStringAttribute('read');
    }
    /**
     * @stability stable
     */
    set read(value) {
        this._read = value;
    }
    /**
     * @stability stable
     */
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get readInput() {
        return this._read;
    }
    /**
     * @stability stable
     */
    get update() {
        return this.getStringAttribute('update');
    }
    /**
     * @stability stable
     */
    set update(value) {
        this._update = value;
    }
    /**
     * @stability stable
     */
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get updateInput() {
        return this._update;
    }
}
exports.KubernetesClusterNodePoolTimeoutsOutputReference = KubernetesClusterNodePoolTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolTimeoutsOutputReference", version: "0.3.0" };
function kubernetesClusterNodePoolUpgradeSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_surge: cdktf.stringToTerraform(struct.maxSurge),
    };
}
exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = kubernetesClusterNodePoolUpgradeSettingsToTerraform;
/**
 * @stability stable
 */
class KubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._maxSurge) {
            hasAnyValues = true;
            internalValueResult.maxSurge = this._maxSurge;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._maxSurge = undefined;
        }
        else {
            this._maxSurge = value.maxSurge;
        }
    }
    /**
     * @stability stable
     */
    get maxSurge() {
        return this.getStringAttribute('max_surge');
    }
    /**
     * @stability stable
     */
    set maxSurge(value) {
        this._maxSurge = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get maxSurgeInput() {
        return this._maxSurge;
    }
}
exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = KubernetesClusterNodePoolUpgradeSettingsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolUpgradeSettingsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePoolUpgradeSettingsOutputReference", version: "0.3.0" };
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html azurerm_kubernetes_cluster_node_pool}.
 *
 * @stability stable
 */
class KubernetesClusterNodePool extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool.html azurerm_kubernetes_cluster_node_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_kubernetes_cluster_node_pool',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // kubelet_config - computed: false, optional: true, required: false
        this._kubeletConfig = new KubernetesClusterNodePoolKubeletConfigOutputReference(this, "kubelet_config", true);
        // linux_os_config - computed: false, optional: true, required: false
        this._linuxOsConfig = new KubernetesClusterNodePoolLinuxOsConfigOutputReference(this, "linux_os_config", true);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new KubernetesClusterNodePoolTimeoutsOutputReference(this, "timeouts", true);
        // upgrade_settings - computed: false, optional: true, required: false
        this._upgradeSettings = new KubernetesClusterNodePoolUpgradeSettingsOutputReference(this, "upgrade_settings", true);
        this._availabilityZones = config.availabilityZones;
        this._enableAutoScaling = config.enableAutoScaling;
        this._enableHostEncryption = config.enableHostEncryption;
        this._enableNodePublicIp = config.enableNodePublicIp;
        this._evictionPolicy = config.evictionPolicy;
        this._fipsEnabled = config.fipsEnabled;
        this._kubeletDiskType = config.kubeletDiskType;
        this._kubernetesClusterId = config.kubernetesClusterId;
        this._maxCount = config.maxCount;
        this._maxPods = config.maxPods;
        this._minCount = config.minCount;
        this._mode = config.mode;
        this._name = config.name;
        this._nodeCount = config.nodeCount;
        this._nodeLabels = config.nodeLabels;
        this._nodePublicIpPrefixId = config.nodePublicIpPrefixId;
        this._nodeTaints = config.nodeTaints;
        this._orchestratorVersion = config.orchestratorVersion;
        this._osDiskSizeGb = config.osDiskSizeGb;
        this._osDiskType = config.osDiskType;
        this._osSku = config.osSku;
        this._osType = config.osType;
        this._podSubnetId = config.podSubnetId;
        this._priority = config.priority;
        this._proximityPlacementGroupId = config.proximityPlacementGroupId;
        this._spotMaxPrice = config.spotMaxPrice;
        this._tags = config.tags;
        this._ultraSsdEnabled = config.ultraSsdEnabled;
        this._vmSize = config.vmSize;
        this._vnetSubnetId = config.vnetSubnetId;
        this._kubeletConfig.internalValue = config.kubeletConfig;
        this._linuxOsConfig.internalValue = config.linuxOsConfig;
        this._timeouts.internalValue = config.timeouts;
        this._upgradeSettings.internalValue = config.upgradeSettings;
    }
    /**
     * @stability stable
     */
    get availabilityZones() {
        return this.getListAttribute('availability_zones');
    }
    /**
     * @stability stable
     */
    set availabilityZones(value) {
        this._availabilityZones = value;
    }
    /**
     * @stability stable
     */
    resetAvailabilityZones() {
        this._availabilityZones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get availabilityZonesInput() {
        return this._availabilityZones;
    }
    /**
     * @stability stable
     */
    get enableAutoScaling() {
        return this.getBooleanAttribute('enable_auto_scaling');
    }
    /**
     * @stability stable
     */
    set enableAutoScaling(value) {
        this._enableAutoScaling = value;
    }
    /**
     * @stability stable
     */
    resetEnableAutoScaling() {
        this._enableAutoScaling = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get enableAutoScalingInput() {
        return this._enableAutoScaling;
    }
    /**
     * @stability stable
     */
    get enableHostEncryption() {
        return this.getBooleanAttribute('enable_host_encryption');
    }
    /**
     * @stability stable
     */
    set enableHostEncryption(value) {
        this._enableHostEncryption = value;
    }
    /**
     * @stability stable
     */
    resetEnableHostEncryption() {
        this._enableHostEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get enableHostEncryptionInput() {
        return this._enableHostEncryption;
    }
    /**
     * @stability stable
     */
    get enableNodePublicIp() {
        return this.getBooleanAttribute('enable_node_public_ip');
    }
    /**
     * @stability stable
     */
    set enableNodePublicIp(value) {
        this._enableNodePublicIp = value;
    }
    /**
     * @stability stable
     */
    resetEnableNodePublicIp() {
        this._enableNodePublicIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get enableNodePublicIpInput() {
        return this._enableNodePublicIp;
    }
    /**
     * @stability stable
     */
    get evictionPolicy() {
        return this.getStringAttribute('eviction_policy');
    }
    /**
     * @stability stable
     */
    set evictionPolicy(value) {
        this._evictionPolicy = value;
    }
    /**
     * @stability stable
     */
    resetEvictionPolicy() {
        this._evictionPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get evictionPolicyInput() {
        return this._evictionPolicy;
    }
    /**
     * @stability stable
     */
    get fipsEnabled() {
        return this.getBooleanAttribute('fips_enabled');
    }
    /**
     * @stability stable
     */
    set fipsEnabled(value) {
        this._fipsEnabled = value;
    }
    /**
     * @stability stable
     */
    resetFipsEnabled() {
        this._fipsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get fipsEnabledInput() {
        return this._fipsEnabled;
    }
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get kubeletDiskType() {
        return this.getStringAttribute('kubelet_disk_type');
    }
    /**
     * @stability stable
     */
    set kubeletDiskType(value) {
        this._kubeletDiskType = value;
    }
    /**
     * @stability stable
     */
    resetKubeletDiskType() {
        this._kubeletDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get kubeletDiskTypeInput() {
        return this._kubeletDiskType;
    }
    /**
     * @stability stable
     */
    get kubernetesClusterId() {
        return this.getStringAttribute('kubernetes_cluster_id');
    }
    /**
     * @stability stable
     */
    set kubernetesClusterId(value) {
        this._kubernetesClusterId = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get kubernetesClusterIdInput() {
        return this._kubernetesClusterId;
    }
    /**
     * @stability stable
     */
    get maxCount() {
        return this.getNumberAttribute('max_count');
    }
    /**
     * @stability stable
     */
    set maxCount(value) {
        this._maxCount = value;
    }
    /**
     * @stability stable
     */
    resetMaxCount() {
        this._maxCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get maxCountInput() {
        return this._maxCount;
    }
    /**
     * @stability stable
     */
    get maxPods() {
        return this.getNumberAttribute('max_pods');
    }
    /**
     * @stability stable
     */
    set maxPods(value) {
        this._maxPods = value;
    }
    /**
     * @stability stable
     */
    resetMaxPods() {
        this._maxPods = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get maxPodsInput() {
        return this._maxPods;
    }
    /**
     * @stability stable
     */
    get minCount() {
        return this.getNumberAttribute('min_count');
    }
    /**
     * @stability stable
     */
    set minCount(value) {
        this._minCount = value;
    }
    /**
     * @stability stable
     */
    resetMinCount() {
        this._minCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get minCountInput() {
        return this._minCount;
    }
    /**
     * @stability stable
     */
    get mode() {
        return this.getStringAttribute('mode');
    }
    /**
     * @stability stable
     */
    set mode(value) {
        this._mode = value;
    }
    /**
     * @stability stable
     */
    resetMode() {
        this._mode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get modeInput() {
        return this._mode;
    }
    /**
     * @stability stable
     */
    get name() {
        return this.getStringAttribute('name');
    }
    /**
     * @stability stable
     */
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nameInput() {
        return this._name;
    }
    /**
     * @stability stable
     */
    get nodeCount() {
        return this.getNumberAttribute('node_count');
    }
    /**
     * @stability stable
     */
    set nodeCount(value) {
        this._nodeCount = value;
    }
    /**
     * @stability stable
     */
    resetNodeCount() {
        this._nodeCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nodeCountInput() {
        return this._nodeCount;
    }
    /**
     * @stability stable
     */
    get nodeLabels() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('node_labels');
    }
    /**
     * @stability stable
     */
    set nodeLabels(value) {
        this._nodeLabels = value;
    }
    /**
     * @stability stable
     */
    resetNodeLabels() {
        this._nodeLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nodeLabelsInput() {
        return this._nodeLabels;
    }
    /**
     * @stability stable
     */
    get nodePublicIpPrefixId() {
        return this.getStringAttribute('node_public_ip_prefix_id');
    }
    /**
     * @stability stable
     */
    set nodePublicIpPrefixId(value) {
        this._nodePublicIpPrefixId = value;
    }
    /**
     * @stability stable
     */
    resetNodePublicIpPrefixId() {
        this._nodePublicIpPrefixId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nodePublicIpPrefixIdInput() {
        return this._nodePublicIpPrefixId;
    }
    /**
     * @stability stable
     */
    get nodeTaints() {
        return this.getListAttribute('node_taints');
    }
    /**
     * @stability stable
     */
    set nodeTaints(value) {
        this._nodeTaints = value;
    }
    /**
     * @stability stable
     */
    resetNodeTaints() {
        this._nodeTaints = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nodeTaintsInput() {
        return this._nodeTaints;
    }
    /**
     * @stability stable
     */
    get orchestratorVersion() {
        return this.getStringAttribute('orchestrator_version');
    }
    /**
     * @stability stable
     */
    set orchestratorVersion(value) {
        this._orchestratorVersion = value;
    }
    /**
     * @stability stable
     */
    resetOrchestratorVersion() {
        this._orchestratorVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get orchestratorVersionInput() {
        return this._orchestratorVersion;
    }
    /**
     * @stability stable
     */
    get osDiskSizeGb() {
        return this.getNumberAttribute('os_disk_size_gb');
    }
    /**
     * @stability stable
     */
    set osDiskSizeGb(value) {
        this._osDiskSizeGb = value;
    }
    /**
     * @stability stable
     */
    resetOsDiskSizeGb() {
        this._osDiskSizeGb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osDiskSizeGbInput() {
        return this._osDiskSizeGb;
    }
    /**
     * @stability stable
     */
    get osDiskType() {
        return this.getStringAttribute('os_disk_type');
    }
    /**
     * @stability stable
     */
    set osDiskType(value) {
        this._osDiskType = value;
    }
    /**
     * @stability stable
     */
    resetOsDiskType() {
        this._osDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osDiskTypeInput() {
        return this._osDiskType;
    }
    /**
     * @stability stable
     */
    get osSku() {
        return this.getStringAttribute('os_sku');
    }
    /**
     * @stability stable
     */
    set osSku(value) {
        this._osSku = value;
    }
    /**
     * @stability stable
     */
    resetOsSku() {
        this._osSku = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osSkuInput() {
        return this._osSku;
    }
    /**
     * @stability stable
     */
    get osType() {
        return this.getStringAttribute('os_type');
    }
    /**
     * @stability stable
     */
    set osType(value) {
        this._osType = value;
    }
    /**
     * @stability stable
     */
    resetOsType() {
        this._osType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get osTypeInput() {
        return this._osType;
    }
    /**
     * @stability stable
     */
    get podSubnetId() {
        return this.getStringAttribute('pod_subnet_id');
    }
    /**
     * @stability stable
     */
    set podSubnetId(value) {
        this._podSubnetId = value;
    }
    /**
     * @stability stable
     */
    resetPodSubnetId() {
        this._podSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get podSubnetIdInput() {
        return this._podSubnetId;
    }
    /**
     * @stability stable
     */
    get priority() {
        return this.getStringAttribute('priority');
    }
    /**
     * @stability stable
     */
    set priority(value) {
        this._priority = value;
    }
    /**
     * @stability stable
     */
    resetPriority() {
        this._priority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get priorityInput() {
        return this._priority;
    }
    /**
     * @stability stable
     */
    get proximityPlacementGroupId() {
        return this.getStringAttribute('proximity_placement_group_id');
    }
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value) {
        this._proximityPlacementGroupId = value;
    }
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId() {
        this._proximityPlacementGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput() {
        return this._proximityPlacementGroupId;
    }
    /**
     * @stability stable
     */
    get spotMaxPrice() {
        return this.getNumberAttribute('spot_max_price');
    }
    /**
     * @stability stable
     */
    set spotMaxPrice(value) {
        this._spotMaxPrice = value;
    }
    /**
     * @stability stable
     */
    resetSpotMaxPrice() {
        this._spotMaxPrice = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get spotMaxPriceInput() {
        return this._spotMaxPrice;
    }
    /**
     * @stability stable
     */
    get tags() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('tags');
    }
    /**
     * @stability stable
     */
    set tags(value) {
        this._tags = value;
    }
    /**
     * @stability stable
     */
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tagsInput() {
        return this._tags;
    }
    /**
     * @stability stable
     */
    get ultraSsdEnabled() {
        return this.getBooleanAttribute('ultra_ssd_enabled');
    }
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value) {
        this._ultraSsdEnabled = value;
    }
    /**
     * @stability stable
     */
    resetUltraSsdEnabled() {
        this._ultraSsdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput() {
        return this._ultraSsdEnabled;
    }
    /**
     * @stability stable
     */
    get vmSize() {
        return this.getStringAttribute('vm_size');
    }
    /**
     * @stability stable
     */
    set vmSize(value) {
        this._vmSize = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vmSizeInput() {
        return this._vmSize;
    }
    /**
     * @stability stable
     */
    get vnetSubnetId() {
        return this.getStringAttribute('vnet_subnet_id');
    }
    /**
     * @stability stable
     */
    set vnetSubnetId(value) {
        this._vnetSubnetId = value;
    }
    /**
     * @stability stable
     */
    resetVnetSubnetId() {
        this._vnetSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get vnetSubnetIdInput() {
        return this._vnetSubnetId;
    }
    /**
     * @stability stable
     */
    get kubeletConfig() {
        return this._kubeletConfig;
    }
    /**
     * @stability stable
     */
    putKubeletConfig(value) {
        this._kubeletConfig.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetKubeletConfig() {
        this._kubeletConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get kubeletConfigInput() {
        return this._kubeletConfig.internalValue;
    }
    /**
     * @stability stable
     */
    get linuxOsConfig() {
        return this._linuxOsConfig;
    }
    /**
     * @stability stable
     */
    putLinuxOsConfig(value) {
        this._linuxOsConfig.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetLinuxOsConfig() {
        this._linuxOsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get linuxOsConfigInput() {
        return this._linuxOsConfig.internalValue;
    }
    /**
     * @stability stable
     */
    get timeouts() {
        return this._timeouts;
    }
    /**
     * @stability stable
     */
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    /**
     * @stability stable
     */
    get upgradeSettings() {
        return this._upgradeSettings;
    }
    /**
     * @stability stable
     */
    putUpgradeSettings(value) {
        this._upgradeSettings.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetUpgradeSettings() {
        this._upgradeSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get upgradeSettingsInput() {
        return this._upgradeSettings.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            availability_zones: cdktf.listMapper(cdktf.stringToTerraform)(this._availabilityZones),
            enable_auto_scaling: cdktf.booleanToTerraform(this._enableAutoScaling),
            enable_host_encryption: cdktf.booleanToTerraform(this._enableHostEncryption),
            enable_node_public_ip: cdktf.booleanToTerraform(this._enableNodePublicIp),
            eviction_policy: cdktf.stringToTerraform(this._evictionPolicy),
            fips_enabled: cdktf.booleanToTerraform(this._fipsEnabled),
            kubelet_disk_type: cdktf.stringToTerraform(this._kubeletDiskType),
            kubernetes_cluster_id: cdktf.stringToTerraform(this._kubernetesClusterId),
            max_count: cdktf.numberToTerraform(this._maxCount),
            max_pods: cdktf.numberToTerraform(this._maxPods),
            min_count: cdktf.numberToTerraform(this._minCount),
            mode: cdktf.stringToTerraform(this._mode),
            name: cdktf.stringToTerraform(this._name),
            node_count: cdktf.numberToTerraform(this._nodeCount),
            node_labels: cdktf.hashMapper(cdktf.anyToTerraform)(this._nodeLabels),
            node_public_ip_prefix_id: cdktf.stringToTerraform(this._nodePublicIpPrefixId),
            node_taints: cdktf.listMapper(cdktf.stringToTerraform)(this._nodeTaints),
            orchestrator_version: cdktf.stringToTerraform(this._orchestratorVersion),
            os_disk_size_gb: cdktf.numberToTerraform(this._osDiskSizeGb),
            os_disk_type: cdktf.stringToTerraform(this._osDiskType),
            os_sku: cdktf.stringToTerraform(this._osSku),
            os_type: cdktf.stringToTerraform(this._osType),
            pod_subnet_id: cdktf.stringToTerraform(this._podSubnetId),
            priority: cdktf.stringToTerraform(this._priority),
            proximity_placement_group_id: cdktf.stringToTerraform(this._proximityPlacementGroupId),
            spot_max_price: cdktf.numberToTerraform(this._spotMaxPrice),
            tags: cdktf.hashMapper(cdktf.anyToTerraform)(this._tags),
            ultra_ssd_enabled: cdktf.booleanToTerraform(this._ultraSsdEnabled),
            vm_size: cdktf.stringToTerraform(this._vmSize),
            vnet_subnet_id: cdktf.stringToTerraform(this._vnetSubnetId),
            kubelet_config: kubernetesClusterNodePoolKubeletConfigToTerraform(this._kubeletConfig.internalValue),
            linux_os_config: kubernetesClusterNodePoolLinuxOsConfigToTerraform(this._linuxOsConfig.internalValue),
            timeouts: kubernetesClusterNodePoolTimeoutsToTerraform(this._timeouts.internalValue),
            upgrade_settings: kubernetesClusterNodePoolUpgradeSettingsToTerraform(this._upgradeSettings.internalValue),
        };
    }
}
exports.KubernetesClusterNodePool = KubernetesClusterNodePool;
_f = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePool[_f] = { fqn: "@cdktf/provider-azurerm.KubernetesClusterNodePool", version: "0.3.0" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
KubernetesClusterNodePool.tfResourceType = "azurerm_kubernetes_cluster_node_pool";
//# sourceMappingURL=data:application/json;base64,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