import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbOutboundRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#allocated_outbound_ports LbOutboundRule#allocated_outbound_ports}.
     *
     * @stability stable
     */
    readonly allocatedOutboundPorts?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#backend_address_pool_id LbOutboundRule#backend_address_pool_id}.
     *
     * @stability stable
     */
    readonly backendAddressPoolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#enable_tcp_reset LbOutboundRule#enable_tcp_reset}.
     *
     * @stability stable
     */
    readonly enableTcpReset?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#idle_timeout_in_minutes LbOutboundRule#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#loadbalancer_id LbOutboundRule#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#name LbOutboundRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#protocol LbOutboundRule#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#resource_group_name LbOutboundRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * frontend_ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#frontend_ip_configuration LbOutboundRule#frontend_ip_configuration}
     *
     * @stability stable
     */
    readonly frontendIpConfiguration?: LbOutboundRuleFrontendIpConfiguration[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#timeouts LbOutboundRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbOutboundRuleTimeouts;
}
/**
 * @stability stable
 */
export interface LbOutboundRuleFrontendIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#name LbOutboundRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function lbOutboundRuleFrontendIpConfigurationToTerraform(struct?: LbOutboundRuleFrontendIpConfiguration): any;
/**
 * @stability stable
 */
export interface LbOutboundRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#create LbOutboundRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#delete LbOutboundRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#read LbOutboundRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html#update LbOutboundRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function lbOutboundRuleTimeoutsToTerraform(struct?: LbOutboundRuleTimeoutsOutputReference | LbOutboundRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class LbOutboundRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LbOutboundRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LbOutboundRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html azurerm_lb_outbound_rule}.
 *
 * @stability stable
 */
export declare class LbOutboundRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lb_outbound_rule.html azurerm_lb_outbound_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbOutboundRuleConfig);
    private _allocatedOutboundPorts?;
    /**
     * @stability stable
     */
    get allocatedOutboundPorts(): number;
    /**
     * @stability stable
     */
    set allocatedOutboundPorts(value: number);
    /**
     * @stability stable
     */
    resetAllocatedOutboundPorts(): void;
    /**
     * @stability stable
     */
    get allocatedOutboundPortsInput(): number | undefined;
    private _backendAddressPoolId?;
    /**
     * @stability stable
     */
    get backendAddressPoolId(): string;
    /**
     * @stability stable
     */
    set backendAddressPoolId(value: string);
    /**
     * @stability stable
     */
    get backendAddressPoolIdInput(): string | undefined;
    private _enableTcpReset?;
    /**
     * @stability stable
     */
    get enableTcpReset(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableTcpReset(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableTcpReset(): void;
    /**
     * @stability stable
     */
    get enableTcpResetInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _idleTimeoutInMinutes?;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    set idleTimeoutInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIdleTimeoutInMinutes(): void;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _frontendIpConfiguration?;
    /**
     * @stability stable
     */
    get frontendIpConfiguration(): LbOutboundRuleFrontendIpConfiguration[];
    /**
     * @stability stable
     */
    set frontendIpConfiguration(value: LbOutboundRuleFrontendIpConfiguration[]);
    /**
     * @stability stable
     */
    resetFrontendIpConfiguration(): void;
    /**
     * @stability stable
     */
    get frontendIpConfigurationInput(): LbOutboundRuleFrontendIpConfiguration[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LbOutboundRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbOutboundRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbOutboundRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
