import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogAnalyticsWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#daily_quota_gb LogAnalyticsWorkspace#daily_quota_gb}.
     *
     * @stability stable
     */
    readonly dailyQuotaGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#internet_ingestion_enabled LogAnalyticsWorkspace#internet_ingestion_enabled}.
     *
     * @stability stable
     */
    readonly internetIngestionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#internet_query_enabled LogAnalyticsWorkspace#internet_query_enabled}.
     *
     * @stability stable
     */
    readonly internetQueryEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#location LogAnalyticsWorkspace#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#name LogAnalyticsWorkspace#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#reservation_capcity_in_gb_per_day LogAnalyticsWorkspace#reservation_capcity_in_gb_per_day}.
     *
     * @stability stable
     */
    readonly reservationCapcityInGbPerDay?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#resource_group_name LogAnalyticsWorkspace#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#retention_in_days LogAnalyticsWorkspace#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#sku LogAnalyticsWorkspace#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#tags LogAnalyticsWorkspace#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#timeouts LogAnalyticsWorkspace#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogAnalyticsWorkspaceTimeouts;
}
/**
 * @stability stable
 */
export interface LogAnalyticsWorkspaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#create LogAnalyticsWorkspace#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#delete LogAnalyticsWorkspace#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#read LogAnalyticsWorkspace#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html#update LogAnalyticsWorkspace#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logAnalyticsWorkspaceTimeoutsToTerraform(struct?: LogAnalyticsWorkspaceTimeoutsOutputReference | LogAnalyticsWorkspaceTimeouts): any;
/**
 * @stability stable
 */
export declare class LogAnalyticsWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogAnalyticsWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogAnalyticsWorkspaceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html azurerm_log_analytics_workspace}.
 *
 * @stability stable
 */
export declare class LogAnalyticsWorkspace extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_workspace.html azurerm_log_analytics_workspace} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogAnalyticsWorkspaceConfig);
    private _dailyQuotaGb?;
    /**
     * @stability stable
     */
    get dailyQuotaGb(): number;
    /**
     * @stability stable
     */
    set dailyQuotaGb(value: number);
    /**
     * @stability stable
     */
    resetDailyQuotaGb(): void;
    /**
     * @stability stable
     */
    get dailyQuotaGbInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _internetIngestionEnabled?;
    /**
     * @stability stable
     */
    get internetIngestionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internetIngestionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternetIngestionEnabled(): void;
    /**
     * @stability stable
     */
    get internetIngestionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _internetQueryEnabled?;
    /**
     * @stability stable
     */
    get internetQueryEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internetQueryEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternetQueryEnabled(): void;
    /**
     * @stability stable
     */
    get internetQueryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get portalUrl(): string;
    /**
     * @stability stable
     */
    get primarySharedKey(): string;
    private _reservationCapcityInGbPerDay?;
    /**
     * @stability stable
     */
    get reservationCapcityInGbPerDay(): number;
    /**
     * @stability stable
     */
    set reservationCapcityInGbPerDay(value: number);
    /**
     * @stability stable
     */
    resetReservationCapcityInGbPerDay(): void;
    /**
     * @stability stable
     */
    get reservationCapcityInGbPerDayInput(): number | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionInDays(): void;
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    /**
     * @stability stable
     */
    get secondarySharedKey(): string;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogAnalyticsWorkspaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogAnalyticsWorkspaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogAnalyticsWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
