import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountBatchConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#batch_group_name LogicAppIntegrationAccountBatchConfiguration#batch_group_name}.
     *
     * @stability stable
     */
    readonly batchGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#integration_account_name LogicAppIntegrationAccountBatchConfiguration#integration_account_name}.
     *
     * @stability stable
     */
    readonly integrationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#metadata LogicAppIntegrationAccountBatchConfiguration#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#name LogicAppIntegrationAccountBatchConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#resource_group_name LogicAppIntegrationAccountBatchConfiguration#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * release_criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#release_criteria LogicAppIntegrationAccountBatchConfiguration#release_criteria}
     *
     * @stability stable
     */
    readonly releaseCriteria: LogicAppIntegrationAccountBatchConfigurationReleaseCriteria;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#timeouts LogicAppIntegrationAccountBatchConfiguration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppIntegrationAccountBatchConfigurationTimeouts;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#week LogicAppIntegrationAccountBatchConfiguration#week}.
     *
     * @stability stable
     */
    readonly week: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#weekday LogicAppIntegrationAccountBatchConfiguration#weekday}.
     *
     * @stability stable
     */
    readonly weekday: string;
}
export declare function logicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthlyToTerraform(struct?: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly): any;
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#hours LogicAppIntegrationAccountBatchConfiguration#hours}.
     *
     * @stability stable
     */
    readonly hours?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#minutes LogicAppIntegrationAccountBatchConfiguration#minutes}.
     *
     * @stability stable
     */
    readonly minutes?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#month_days LogicAppIntegrationAccountBatchConfiguration#month_days}.
     *
     * @stability stable
     */
    readonly monthDays?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#week_days LogicAppIntegrationAccountBatchConfiguration#week_days}.
     *
     * @stability stable
     */
    readonly weekDays?: string[];
    /**
     * monthly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#monthly LogicAppIntegrationAccountBatchConfiguration#monthly}
     *
     * @stability stable
     */
    readonly monthly?: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly[];
}
export declare function logicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleToTerraform(struct?: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleOutputReference | LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule | undefined);
    private _hours?;
    /**
     * @stability stable
     */
    get hours(): number[];
    /**
     * @stability stable
     */
    set hours(value: number[]);
    /**
     * @stability stable
     */
    resetHours(): void;
    /**
     * @stability stable
     */
    get hoursInput(): number[] | undefined;
    private _minutes?;
    /**
     * @stability stable
     */
    get minutes(): number[];
    /**
     * @stability stable
     */
    set minutes(value: number[]);
    /**
     * @stability stable
     */
    resetMinutes(): void;
    /**
     * @stability stable
     */
    get minutesInput(): number[] | undefined;
    private _monthDays?;
    /**
     * @stability stable
     */
    get monthDays(): number[];
    /**
     * @stability stable
     */
    set monthDays(value: number[]);
    /**
     * @stability stable
     */
    resetMonthDays(): void;
    /**
     * @stability stable
     */
    get monthDaysInput(): number[] | undefined;
    private _weekDays?;
    /**
     * @stability stable
     */
    get weekDays(): string[];
    /**
     * @stability stable
     */
    set weekDays(value: string[]);
    /**
     * @stability stable
     */
    resetWeekDays(): void;
    /**
     * @stability stable
     */
    get weekDaysInput(): string[] | undefined;
    private _monthly?;
    /**
     * @stability stable
     */
    get monthly(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly[];
    /**
     * @stability stable
     */
    set monthly(value: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly[]);
    /**
     * @stability stable
     */
    resetMonthly(): void;
    /**
     * @stability stable
     */
    get monthlyInput(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly[] | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#end_time LogicAppIntegrationAccountBatchConfiguration#end_time}.
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#frequency LogicAppIntegrationAccountBatchConfiguration#frequency}.
     *
     * @stability stable
     */
    readonly frequency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#interval LogicAppIntegrationAccountBatchConfiguration#interval}.
     *
     * @stability stable
     */
    readonly interval: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#start_time LogicAppIntegrationAccountBatchConfiguration#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#time_zone LogicAppIntegrationAccountBatchConfiguration#time_zone}.
     *
     * @stability stable
     */
    readonly timeZone?: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#schedule LogicAppIntegrationAccountBatchConfiguration#schedule}
     *
     * @stability stable
     */
    readonly schedule?: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule;
}
export declare function logicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceToTerraform(struct?: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceOutputReference | LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrence): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrence | undefined);
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _timeZone?;
    /**
     * @stability stable
     */
    get timeZone(): string;
    /**
     * @stability stable
     */
    set timeZone(value: string);
    /**
     * @stability stable
     */
    resetTimeZone(): void;
    /**
     * @stability stable
     */
    get timeZoneInput(): string | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleOutputReference;
    /**
     * @stability stable
     */
    putSchedule(value: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule): void;
    /**
     * @stability stable
     */
    resetSchedule(): void;
    /**
     * @stability stable
     */
    get scheduleInput(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountBatchConfigurationReleaseCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#batch_size LogicAppIntegrationAccountBatchConfiguration#batch_size}.
     *
     * @stability stable
     */
    readonly batchSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#message_count LogicAppIntegrationAccountBatchConfiguration#message_count}.
     *
     * @stability stable
     */
    readonly messageCount?: number;
    /**
     * recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#recurrence LogicAppIntegrationAccountBatchConfiguration#recurrence}
     *
     * @stability stable
     */
    readonly recurrence?: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrence;
}
export declare function logicAppIntegrationAccountBatchConfigurationReleaseCriteriaToTerraform(struct?: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaOutputReference | LogicAppIntegrationAccountBatchConfigurationReleaseCriteria): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteria | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountBatchConfigurationReleaseCriteria | undefined);
    private _batchSize?;
    /**
     * @stability stable
     */
    get batchSize(): number;
    /**
     * @stability stable
     */
    set batchSize(value: number);
    /**
     * @stability stable
     */
    resetBatchSize(): void;
    /**
     * @stability stable
     */
    get batchSizeInput(): number | undefined;
    private _messageCount?;
    /**
     * @stability stable
     */
    get messageCount(): number;
    /**
     * @stability stable
     */
    set messageCount(value: number);
    /**
     * @stability stable
     */
    resetMessageCount(): void;
    /**
     * @stability stable
     */
    get messageCountInput(): number | undefined;
    private _recurrence;
    /**
     * @stability stable
     */
    get recurrence(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putRecurrence(value: LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrence): void;
    /**
     * @stability stable
     */
    resetRecurrence(): void;
    /**
     * @stability stable
     */
    get recurrenceInput(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaRecurrence | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppIntegrationAccountBatchConfigurationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#create LogicAppIntegrationAccountBatchConfiguration#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#delete LogicAppIntegrationAccountBatchConfiguration#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#read LogicAppIntegrationAccountBatchConfiguration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html#update LogicAppIntegrationAccountBatchConfiguration#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppIntegrationAccountBatchConfigurationTimeoutsToTerraform(struct?: LogicAppIntegrationAccountBatchConfigurationTimeoutsOutputReference | LogicAppIntegrationAccountBatchConfigurationTimeouts): any;
/**
 * @stability stable
 */
export declare class LogicAppIntegrationAccountBatchConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppIntegrationAccountBatchConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppIntegrationAccountBatchConfigurationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html azurerm_logic_app_integration_account_batch_configuration}.
 *
 * @stability stable
 */
export declare class LogicAppIntegrationAccountBatchConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_integration_account_batch_configuration.html azurerm_logic_app_integration_account_batch_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppIntegrationAccountBatchConfigurationConfig);
    private _batchGroupName?;
    /**
     * @stability stable
     */
    get batchGroupName(): string;
    /**
     * @stability stable
     */
    set batchGroupName(value: string);
    /**
     * @stability stable
     */
    get batchGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationAccountName?;
    /**
     * @stability stable
     */
    get integrationAccountName(): string;
    /**
     * @stability stable
     */
    set integrationAccountName(value: string);
    /**
     * @stability stable
     */
    get integrationAccountNameInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _releaseCriteria;
    /**
     * @stability stable
     */
    get releaseCriteria(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteriaOutputReference;
    /**
     * @stability stable
     */
    putReleaseCriteria(value: LogicAppIntegrationAccountBatchConfigurationReleaseCriteria): void;
    /**
     * @stability stable
     */
    get releaseCriteriaInput(): LogicAppIntegrationAccountBatchConfigurationReleaseCriteria | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppIntegrationAccountBatchConfigurationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppIntegrationAccountBatchConfigurationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppIntegrationAccountBatchConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
