import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppStandardConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#app_service_plan_id LogicAppStandard#app_service_plan_id}.
     *
     * @stability stable
     */
    readonly appServicePlanId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#app_settings LogicAppStandard#app_settings}.
     *
     * @stability stable
     */
    readonly appSettings?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#bundle_version LogicAppStandard#bundle_version}.
     *
     * @stability stable
     */
    readonly bundleVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#client_affinity_enabled LogicAppStandard#client_affinity_enabled}.
     *
     * @stability stable
     */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#client_certificate_mode LogicAppStandard#client_certificate_mode}.
     *
     * @stability stable
     */
    readonly clientCertificateMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#enabled LogicAppStandard#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#https_only LogicAppStandard#https_only}.
     *
     * @stability stable
     */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#location LogicAppStandard#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#name LogicAppStandard#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#resource_group_name LogicAppStandard#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#storage_account_access_key LogicAppStandard#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#storage_account_name LogicAppStandard#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#storage_account_share_name LogicAppStandard#storage_account_share_name}.
     *
     * @stability stable
     */
    readonly storageAccountShareName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#tags LogicAppStandard#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#use_extension_bundle LogicAppStandard#use_extension_bundle}.
     *
     * @stability stable
     */
    readonly useExtensionBundle?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#version LogicAppStandard#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * connection_string block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#connection_string LogicAppStandard#connection_string}
     *
     * @stability stable
     */
    readonly connectionString?: LogicAppStandardConnectionString[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#identity LogicAppStandard#identity}
     *
     * @stability stable
     */
    readonly identity?: LogicAppStandardIdentity;
    /**
     * site_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#site_config LogicAppStandard#site_config}
     *
     * @stability stable
     */
    readonly siteConfig?: LogicAppStandardSiteConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#timeouts LogicAppStandard#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppStandardTimeouts;
}
/**
 * @stability stable
 */
export declare class LogicAppStandardSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface LogicAppStandardConnectionString {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#name LogicAppStandard#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#type LogicAppStandard#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#value LogicAppStandard#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function logicAppStandardConnectionStringToTerraform(struct?: LogicAppStandardConnectionString): any;
/**
 * @stability stable
 */
export interface LogicAppStandardIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#type LogicAppStandard#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function logicAppStandardIdentityToTerraform(struct?: LogicAppStandardIdentityOutputReference | LogicAppStandardIdentity): any;
/**
 * @stability stable
 */
export declare class LogicAppStandardIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppStandardIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppStandardIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppStandardSiteConfigIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#x_azure_fdid LogicAppStandard#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#x_fd_health_probe LogicAppStandard#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#x_forwarded_for LogicAppStandard#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#x_forwarded_host LogicAppStandard#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function logicAppStandardSiteConfigIpRestrictionHeadersToTerraform(struct?: LogicAppStandardSiteConfigIpRestrictionHeaders): any;
/**
 * @stability stable
 */
export interface LogicAppStandardSiteConfigIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#action LogicAppStandard#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#headers LogicAppStandard#headers}.
     *
     * @stability stable
     */
    readonly headers?: LogicAppStandardSiteConfigIpRestrictionHeaders[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#ip_address LogicAppStandard#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#name LogicAppStandard#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#priority LogicAppStandard#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#service_tag LogicAppStandard#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#virtual_network_subnet_id LogicAppStandard#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function logicAppStandardSiteConfigIpRestrictionToTerraform(struct?: LogicAppStandardSiteConfigIpRestriction): any;
/**
 * @stability stable
 */
export interface LogicAppStandardSiteConfigCors {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#allowed_origins LogicAppStandard#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#support_credentials LogicAppStandard#support_credentials}.
     *
     * @stability stable
     */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function logicAppStandardSiteConfigCorsToTerraform(struct?: LogicAppStandardSiteConfigCorsOutputReference | LogicAppStandardSiteConfigCors): any;
/**
 * @stability stable
 */
export declare class LogicAppStandardSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppStandardSiteConfigCors | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppStandardSiteConfigCors | undefined);
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    /**
     * @stability stable
     */
    get supportCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportCredentials(): void;
    /**
     * @stability stable
     */
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppStandardSiteConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#always_on LogicAppStandard#always_on}.
     *
     * @stability stable
     */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#app_scale_limit LogicAppStandard#app_scale_limit}.
     *
     * @stability stable
     */
    readonly appScaleLimit?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#dotnet_framework_version LogicAppStandard#dotnet_framework_version}.
     *
     * @stability stable
     */
    readonly dotnetFrameworkVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#elastic_instance_minimum LogicAppStandard#elastic_instance_minimum}.
     *
     * @stability stable
     */
    readonly elasticInstanceMinimum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#ftps_state LogicAppStandard#ftps_state}.
     *
     * @stability stable
     */
    readonly ftpsState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#health_check_path LogicAppStandard#health_check_path}.
     *
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#http2_enabled LogicAppStandard#http2_enabled}.
     *
     * @stability stable
     */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#ip_restriction LogicAppStandard#ip_restriction}.
     *
     * @stability stable
     */
    readonly ipRestriction?: LogicAppStandardSiteConfigIpRestriction[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#linux_fx_version LogicAppStandard#linux_fx_version}.
     *
     * @stability stable
     */
    readonly linuxFxVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#min_tls_version LogicAppStandard#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#pre_warmed_instance_count LogicAppStandard#pre_warmed_instance_count}.
     *
     * @stability stable
     */
    readonly preWarmedInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#runtime_scale_monitoring_enabled LogicAppStandard#runtime_scale_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#use_32_bit_worker_process LogicAppStandard#use_32_bit_worker_process}.
     *
     * @stability stable
     */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#vnet_route_all_enabled LogicAppStandard#vnet_route_all_enabled}.
     *
     * @stability stable
     */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#websockets_enabled LogicAppStandard#websockets_enabled}.
     *
     * @stability stable
     */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#cors LogicAppStandard#cors}
     *
     * @stability stable
     */
    readonly cors?: LogicAppStandardSiteConfigCors;
}
export declare function logicAppStandardSiteConfigToTerraform(struct?: LogicAppStandardSiteConfigOutputReference | LogicAppStandardSiteConfig): any;
/**
 * @stability stable
 */
export declare class LogicAppStandardSiteConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppStandardSiteConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppStandardSiteConfig | undefined);
    private _alwaysOn?;
    /**
     * @stability stable
     */
    get alwaysOn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysOn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysOn(): void;
    /**
     * @stability stable
     */
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appScaleLimit?;
    /**
     * @stability stable
     */
    get appScaleLimit(): number;
    /**
     * @stability stable
     */
    set appScaleLimit(value: number);
    /**
     * @stability stable
     */
    resetAppScaleLimit(): void;
    /**
     * @stability stable
     */
    get appScaleLimitInput(): number | undefined;
    private _dotnetFrameworkVersion?;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    set dotnetFrameworkVersion(value: string);
    /**
     * @stability stable
     */
    resetDotnetFrameworkVersion(): void;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersionInput(): string | undefined;
    private _elasticInstanceMinimum?;
    /**
     * @stability stable
     */
    get elasticInstanceMinimum(): number;
    /**
     * @stability stable
     */
    set elasticInstanceMinimum(value: number);
    /**
     * @stability stable
     */
    resetElasticInstanceMinimum(): void;
    /**
     * @stability stable
     */
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    set ftpsState(value: string);
    /**
     * @stability stable
     */
    resetFtpsState(): void;
    /**
     * @stability stable
     */
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    set healthCheckPath(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckPath(): void;
    /**
     * @stability stable
     */
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    /**
     * @stability stable
     */
    get http2Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set http2Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttp2Enabled(): void;
    /**
     * @stability stable
     */
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    /**
     * @stability stable
     */
    get ipRestriction(): LogicAppStandardSiteConfigIpRestriction[];
    /**
     * @stability stable
     */
    set ipRestriction(value: LogicAppStandardSiteConfigIpRestriction[]);
    /**
     * @stability stable
     */
    resetIpRestriction(): void;
    /**
     * @stability stable
     */
    get ipRestrictionInput(): LogicAppStandardSiteConfigIpRestriction[] | undefined;
    private _linuxFxVersion?;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    set linuxFxVersion(value: string);
    /**
     * @stability stable
     */
    resetLinuxFxVersion(): void;
    /**
     * @stability stable
     */
    get linuxFxVersionInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    /**
     * @stability stable
     */
    get preWarmedInstanceCount(): number;
    /**
     * @stability stable
     */
    set preWarmedInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetPreWarmedInstanceCount(): void;
    /**
     * @stability stable
     */
    get preWarmedInstanceCountInput(): number | undefined;
    private _runtimeScaleMonitoringEnabled?;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRuntimeScaleMonitoringEnabled(): void;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUse32BitWorkerProcess(): void;
    /**
     * @stability stable
     */
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVnetRouteAllEnabled(): void;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    /**
     * @stability stable
     */
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWebsocketsEnabled(): void;
    /**
     * @stability stable
     */
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    /**
     * @stability stable
     */
    get cors(): LogicAppStandardSiteConfigCorsOutputReference;
    /**
     * @stability stable
     */
    putCors(value: LogicAppStandardSiteConfigCors): void;
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): LogicAppStandardSiteConfigCors | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppStandardTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#create LogicAppStandard#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#delete LogicAppStandard#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#read LogicAppStandard#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html#update LogicAppStandard#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppStandardTimeoutsToTerraform(struct?: LogicAppStandardTimeoutsOutputReference | LogicAppStandardTimeouts): any;
/**
 * @stability stable
 */
export declare class LogicAppStandardTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppStandardTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppStandardTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html azurerm_logic_app_standard}.
 *
 * @stability stable
 */
export declare class LogicAppStandard extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_standard.html azurerm_logic_app_standard} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppStandardConfig);
    private _appServicePlanId?;
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    set appServicePlanId(value: string);
    /**
     * @stability stable
     */
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    /**
     * @stability stable
     */
    get appSettings(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set appSettings(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAppSettings(): void;
    /**
     * @stability stable
     */
    get appSettingsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _bundleVersion?;
    /**
     * @stability stable
     */
    get bundleVersion(): string;
    /**
     * @stability stable
     */
    set bundleVersion(value: string);
    /**
     * @stability stable
     */
    resetBundleVersion(): void;
    /**
     * @stability stable
     */
    get bundleVersionInput(): string | undefined;
    private _clientAffinityEnabled?;
    /**
     * @stability stable
     */
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAffinityEnabled(): void;
    /**
     * @stability stable
     */
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateMode?;
    /**
     * @stability stable
     */
    get clientCertificateMode(): string;
    /**
     * @stability stable
     */
    set clientCertificateMode(value: string);
    /**
     * @stability stable
     */
    resetClientCertificateMode(): void;
    /**
     * @stability stable
     */
    get clientCertificateModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get customDomainVerificationId(): string;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpsOnly?;
    /**
     * @stability stable
     */
    get httpsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsOnly(): void;
    /**
     * @stability stable
     */
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string;
    /**
     * @stability stable
     */
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteCredential(index: string): LogicAppStandardSiteCredential;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _storageAccountShareName?;
    /**
     * @stability stable
     */
    get storageAccountShareName(): string;
    /**
     * @stability stable
     */
    set storageAccountShareName(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountShareName(): void;
    /**
     * @stability stable
     */
    get storageAccountShareNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _useExtensionBundle?;
    /**
     * @stability stable
     */
    get useExtensionBundle(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useExtensionBundle(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseExtensionBundle(): void;
    /**
     * @stability stable
     */
    get useExtensionBundleInput(): boolean | cdktf.IResolvable | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): LogicAppStandardConnectionString[];
    /**
     * @stability stable
     */
    set connectionString(value: LogicAppStandardConnectionString[]);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): LogicAppStandardConnectionString[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): LogicAppStandardIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: LogicAppStandardIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): LogicAppStandardIdentity | undefined;
    private _siteConfig;
    /**
     * @stability stable
     */
    get siteConfig(): LogicAppStandardSiteConfigOutputReference;
    /**
     * @stability stable
     */
    putSiteConfig(value: LogicAppStandardSiteConfig): void;
    /**
     * @stability stable
     */
    resetSiteConfig(): void;
    /**
     * @stability stable
     */
    get siteConfigInput(): LogicAppStandardSiteConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppStandardTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppStandardTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppStandardTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
