import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MaintenanceAssignmentDedicatedHostConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html#dedicated_host_id MaintenanceAssignmentDedicatedHost#dedicated_host_id}.
     *
     * @stability stable
     */
    readonly dedicatedHostId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html#location MaintenanceAssignmentDedicatedHost#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html#maintenance_configuration_id MaintenanceAssignmentDedicatedHost#maintenance_configuration_id}.
     *
     * @stability stable
     */
    readonly maintenanceConfigurationId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html#timeouts MaintenanceAssignmentDedicatedHost#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MaintenanceAssignmentDedicatedHostTimeouts;
}
/**
 * @stability stable
 */
export interface MaintenanceAssignmentDedicatedHostTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html#create MaintenanceAssignmentDedicatedHost#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html#delete MaintenanceAssignmentDedicatedHost#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html#read MaintenanceAssignmentDedicatedHost#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function maintenanceAssignmentDedicatedHostTimeoutsToTerraform(struct?: MaintenanceAssignmentDedicatedHostTimeoutsOutputReference | MaintenanceAssignmentDedicatedHostTimeouts): any;
/**
 * @stability stable
 */
export declare class MaintenanceAssignmentDedicatedHostTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MaintenanceAssignmentDedicatedHostTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MaintenanceAssignmentDedicatedHostTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html azurerm_maintenance_assignment_dedicated_host}.
 *
 * @stability stable
 */
export declare class MaintenanceAssignmentDedicatedHost extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/maintenance_assignment_dedicated_host.html azurerm_maintenance_assignment_dedicated_host} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MaintenanceAssignmentDedicatedHostConfig);
    private _dedicatedHostId?;
    /**
     * @stability stable
     */
    get dedicatedHostId(): string;
    /**
     * @stability stable
     */
    set dedicatedHostId(value: string);
    /**
     * @stability stable
     */
    get dedicatedHostIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maintenanceConfigurationId?;
    /**
     * @stability stable
     */
    get maintenanceConfigurationId(): string;
    /**
     * @stability stable
     */
    set maintenanceConfigurationId(value: string);
    /**
     * @stability stable
     */
    get maintenanceConfigurationIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MaintenanceAssignmentDedicatedHostTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MaintenanceAssignmentDedicatedHostTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MaintenanceAssignmentDedicatedHostTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
