import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaAssetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#alternate_id MediaAsset#alternate_id}.
     *
     * @stability stable
     */
    readonly alternateId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#container MediaAsset#container}.
     *
     * @stability stable
     */
    readonly container?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#description MediaAsset#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#media_services_account_name MediaAsset#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#name MediaAsset#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#resource_group_name MediaAsset#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#storage_account_name MediaAsset#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#timeouts MediaAsset#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaAssetTimeouts;
}
/**
 * @stability stable
 */
export interface MediaAssetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#create MediaAsset#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#delete MediaAsset#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#read MediaAsset#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html#update MediaAsset#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaAssetTimeoutsToTerraform(struct?: MediaAssetTimeoutsOutputReference | MediaAssetTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaAssetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaAssetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaAssetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html azurerm_media_asset}.
 *
 * @stability stable
 */
export declare class MediaAsset extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_asset.html azurerm_media_asset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaAssetConfig);
    private _alternateId?;
    /**
     * @stability stable
     */
    get alternateId(): string;
    /**
     * @stability stable
     */
    set alternateId(value: string);
    /**
     * @stability stable
     */
    resetAlternateId(): void;
    /**
     * @stability stable
     */
    get alternateIdInput(): string | undefined;
    private _container?;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    set container(value: string);
    /**
     * @stability stable
     */
    resetContainer(): void;
    /**
     * @stability stable
     */
    get containerInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountName(): void;
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaAssetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaAssetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaAssetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
