import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaStreamingLocatorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#alternative_media_id MediaStreamingLocator#alternative_media_id}.
     *
     * @stability stable
     */
    readonly alternativeMediaId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#asset_name MediaStreamingLocator#asset_name}.
     *
     * @stability stable
     */
    readonly assetName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#default_content_key_policy_name MediaStreamingLocator#default_content_key_policy_name}.
     *
     * @stability stable
     */
    readonly defaultContentKeyPolicyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#end_time MediaStreamingLocator#end_time}.
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#media_services_account_name MediaStreamingLocator#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#name MediaStreamingLocator#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#resource_group_name MediaStreamingLocator#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#start_time MediaStreamingLocator#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#streaming_locator_id MediaStreamingLocator#streaming_locator_id}.
     *
     * @stability stable
     */
    readonly streamingLocatorId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#streaming_policy_name MediaStreamingLocator#streaming_policy_name}.
     *
     * @stability stable
     */
    readonly streamingPolicyName: string;
    /**
     * content_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#content_key MediaStreamingLocator#content_key}
     *
     * @stability stable
     */
    readonly contentKey?: MediaStreamingLocatorContentKey[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#timeouts MediaStreamingLocator#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaStreamingLocatorTimeouts;
}
/**
 * @stability stable
 */
export interface MediaStreamingLocatorContentKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#content_key_id MediaStreamingLocator#content_key_id}.
     *
     * @stability stable
     */
    readonly contentKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#label_reference_in_streaming_policy MediaStreamingLocator#label_reference_in_streaming_policy}.
     *
     * @stability stable
     */
    readonly labelReferenceInStreamingPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#policy_name MediaStreamingLocator#policy_name}.
     *
     * @stability stable
     */
    readonly policyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#type MediaStreamingLocator#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#value MediaStreamingLocator#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function mediaStreamingLocatorContentKeyToTerraform(struct?: MediaStreamingLocatorContentKey): any;
/**
 * @stability stable
 */
export interface MediaStreamingLocatorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#create MediaStreamingLocator#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#delete MediaStreamingLocator#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html#read MediaStreamingLocator#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function mediaStreamingLocatorTimeoutsToTerraform(struct?: MediaStreamingLocatorTimeoutsOutputReference | MediaStreamingLocatorTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaStreamingLocatorTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaStreamingLocatorTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaStreamingLocatorTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html azurerm_media_streaming_locator}.
 *
 * @stability stable
 */
export declare class MediaStreamingLocator extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_locator.html azurerm_media_streaming_locator} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaStreamingLocatorConfig);
    private _alternativeMediaId?;
    /**
     * @stability stable
     */
    get alternativeMediaId(): string;
    /**
     * @stability stable
     */
    set alternativeMediaId(value: string);
    /**
     * @stability stable
     */
    resetAlternativeMediaId(): void;
    /**
     * @stability stable
     */
    get alternativeMediaIdInput(): string | undefined;
    private _assetName?;
    /**
     * @stability stable
     */
    get assetName(): string;
    /**
     * @stability stable
     */
    set assetName(value: string);
    /**
     * @stability stable
     */
    get assetNameInput(): string | undefined;
    private _defaultContentKeyPolicyName?;
    /**
     * @stability stable
     */
    get defaultContentKeyPolicyName(): string;
    /**
     * @stability stable
     */
    set defaultContentKeyPolicyName(value: string);
    /**
     * @stability stable
     */
    resetDefaultContentKeyPolicyName(): void;
    /**
     * @stability stable
     */
    get defaultContentKeyPolicyNameInput(): string | undefined;
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _streamingLocatorId?;
    /**
     * @stability stable
     */
    get streamingLocatorId(): string;
    /**
     * @stability stable
     */
    set streamingLocatorId(value: string);
    /**
     * @stability stable
     */
    resetStreamingLocatorId(): void;
    /**
     * @stability stable
     */
    get streamingLocatorIdInput(): string | undefined;
    private _streamingPolicyName?;
    /**
     * @stability stable
     */
    get streamingPolicyName(): string;
    /**
     * @stability stable
     */
    set streamingPolicyName(value: string);
    /**
     * @stability stable
     */
    get streamingPolicyNameInput(): string | undefined;
    private _contentKey?;
    /**
     * @stability stable
     */
    get contentKey(): MediaStreamingLocatorContentKey[];
    /**
     * @stability stable
     */
    set contentKey(value: MediaStreamingLocatorContentKey[]);
    /**
     * @stability stable
     */
    resetContentKey(): void;
    /**
     * @stability stable
     */
    get contentKeyInput(): MediaStreamingLocatorContentKey[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaStreamingLocatorTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaStreamingLocatorTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaStreamingLocatorTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
