import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkInterfaceSecurityGroupAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html#network_interface_id NetworkInterfaceSecurityGroupAssociation#network_interface_id}.
     *
     * @stability stable
     */
    readonly networkInterfaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html#network_security_group_id NetworkInterfaceSecurityGroupAssociation#network_security_group_id}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html#timeouts NetworkInterfaceSecurityGroupAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkInterfaceSecurityGroupAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkInterfaceSecurityGroupAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html#create NetworkInterfaceSecurityGroupAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html#delete NetworkInterfaceSecurityGroupAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html#read NetworkInterfaceSecurityGroupAssociation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html#update NetworkInterfaceSecurityGroupAssociation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkInterfaceSecurityGroupAssociationTimeoutsToTerraform(struct?: NetworkInterfaceSecurityGroupAssociationTimeoutsOutputReference | NetworkInterfaceSecurityGroupAssociationTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkInterfaceSecurityGroupAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkInterfaceSecurityGroupAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkInterfaceSecurityGroupAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html azurerm_network_interface_security_group_association}.
 *
 * @stability stable
 */
export declare class NetworkInterfaceSecurityGroupAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_security_group_association.html azurerm_network_interface_security_group_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkInterfaceSecurityGroupAssociationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _networkInterfaceId?;
    /**
     * @stability stable
     */
    get networkInterfaceId(): string;
    /**
     * @stability stable
     */
    set networkInterfaceId(value: string);
    /**
     * @stability stable
     */
    get networkInterfaceIdInput(): string | undefined;
    private _networkSecurityGroupId?;
    /**
     * @stability stable
     */
    get networkSecurityGroupId(): string;
    /**
     * @stability stable
     */
    set networkSecurityGroupId(value: string);
    /**
     * @stability stable
     */
    get networkSecurityGroupIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkInterfaceSecurityGroupAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkInterfaceSecurityGroupAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkInterfaceSecurityGroupAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
