import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NotificationHubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#location NotificationHub#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#name NotificationHub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#namespace_name NotificationHub#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#resource_group_name NotificationHub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#tags NotificationHub#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * apns_credential block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#apns_credential NotificationHub#apns_credential}
     *
     * @stability stable
     */
    readonly apnsCredential?: NotificationHubApnsCredential;
    /**
     * gcm_credential block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#gcm_credential NotificationHub#gcm_credential}
     *
     * @stability stable
     */
    readonly gcmCredential?: NotificationHubGcmCredential;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#timeouts NotificationHub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NotificationHubTimeouts;
}
/**
 * @stability stable
 */
export interface NotificationHubApnsCredential {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#application_mode NotificationHub#application_mode}.
     *
     * @stability stable
     */
    readonly applicationMode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#bundle_id NotificationHub#bundle_id}.
     *
     * @stability stable
     */
    readonly bundleId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#key_id NotificationHub#key_id}.
     *
     * @stability stable
     */
    readonly keyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#team_id NotificationHub#team_id}.
     *
     * @stability stable
     */
    readonly teamId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#token NotificationHub#token}.
     *
     * @stability stable
     */
    readonly token: string;
}
export declare function notificationHubApnsCredentialToTerraform(struct?: NotificationHubApnsCredentialOutputReference | NotificationHubApnsCredential): any;
/**
 * @stability stable
 */
export declare class NotificationHubApnsCredentialOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotificationHubApnsCredential | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotificationHubApnsCredential | undefined);
    private _applicationMode?;
    /**
     * @stability stable
     */
    get applicationMode(): string;
    /**
     * @stability stable
     */
    set applicationMode(value: string);
    /**
     * @stability stable
     */
    get applicationModeInput(): string | undefined;
    private _bundleId?;
    /**
     * @stability stable
     */
    get bundleId(): string;
    /**
     * @stability stable
     */
    set bundleId(value: string);
    /**
     * @stability stable
     */
    get bundleIdInput(): string | undefined;
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    set keyId(value: string);
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    private _teamId?;
    /**
     * @stability stable
     */
    get teamId(): string;
    /**
     * @stability stable
     */
    set teamId(value: string);
    /**
     * @stability stable
     */
    get teamIdInput(): string | undefined;
    private _token?;
    /**
     * @stability stable
     */
    get token(): string;
    /**
     * @stability stable
     */
    set token(value: string);
    /**
     * @stability stable
     */
    get tokenInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NotificationHubGcmCredential {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#api_key NotificationHub#api_key}.
     *
     * @stability stable
     */
    readonly apiKey: string;
}
export declare function notificationHubGcmCredentialToTerraform(struct?: NotificationHubGcmCredentialOutputReference | NotificationHubGcmCredential): any;
/**
 * @stability stable
 */
export declare class NotificationHubGcmCredentialOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotificationHubGcmCredential | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotificationHubGcmCredential | undefined);
    private _apiKey?;
    /**
     * @stability stable
     */
    get apiKey(): string;
    /**
     * @stability stable
     */
    set apiKey(value: string);
    /**
     * @stability stable
     */
    get apiKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NotificationHubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#create NotificationHub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#delete NotificationHub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#read NotificationHub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html#update NotificationHub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function notificationHubTimeoutsToTerraform(struct?: NotificationHubTimeoutsOutputReference | NotificationHubTimeouts): any;
/**
 * @stability stable
 */
export declare class NotificationHubTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotificationHubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotificationHubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html azurerm_notification_hub}.
 *
 * @stability stable
 */
export declare class NotificationHub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/notification_hub.html azurerm_notification_hub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NotificationHubConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _apnsCredential;
    /**
     * @stability stable
     */
    get apnsCredential(): NotificationHubApnsCredentialOutputReference;
    /**
     * @stability stable
     */
    putApnsCredential(value: NotificationHubApnsCredential): void;
    /**
     * @stability stable
     */
    resetApnsCredential(): void;
    /**
     * @stability stable
     */
    get apnsCredentialInput(): NotificationHubApnsCredential | undefined;
    private _gcmCredential;
    /**
     * @stability stable
     */
    get gcmCredential(): NotificationHubGcmCredentialOutputReference;
    /**
     * @stability stable
     */
    putGcmCredential(value: NotificationHubGcmCredential): void;
    /**
     * @stability stable
     */
    resetGcmCredential(): void;
    /**
     * @stability stable
     */
    get gcmCredentialInput(): NotificationHubGcmCredential | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NotificationHubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NotificationHubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NotificationHubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
