import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourceGroupCostManagementExportConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#active ResourceGroupCostManagementExport#active}.
     *
     * @stability stable
     */
    readonly active?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#name ResourceGroupCostManagementExport#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#recurrence_period_end_date ResourceGroupCostManagementExport#recurrence_period_end_date}.
     *
     * @stability stable
     */
    readonly recurrencePeriodEndDate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#recurrence_period_start_date ResourceGroupCostManagementExport#recurrence_period_start_date}.
     *
     * @stability stable
     */
    readonly recurrencePeriodStartDate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#recurrence_type ResourceGroupCostManagementExport#recurrence_type}.
     *
     * @stability stable
     */
    readonly recurrenceType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#resource_group_id ResourceGroupCostManagementExport#resource_group_id}.
     *
     * @stability stable
     */
    readonly resourceGroupId: string;
    /**
     * export_data_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#export_data_options ResourceGroupCostManagementExport#export_data_options}
     *
     * @stability stable
     */
    readonly exportDataOptions: ResourceGroupCostManagementExportExportDataOptions;
    /**
     * export_data_storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#export_data_storage_location ResourceGroupCostManagementExport#export_data_storage_location}
     *
     * @stability stable
     */
    readonly exportDataStorageLocation: ResourceGroupCostManagementExportExportDataStorageLocation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#timeouts ResourceGroupCostManagementExport#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ResourceGroupCostManagementExportTimeouts;
}
/**
 * @stability stable
 */
export interface ResourceGroupCostManagementExportExportDataOptions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#time_frame ResourceGroupCostManagementExport#time_frame}.
     *
     * @stability stable
     */
    readonly timeFrame: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#type ResourceGroupCostManagementExport#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function resourceGroupCostManagementExportExportDataOptionsToTerraform(struct?: ResourceGroupCostManagementExportExportDataOptionsOutputReference | ResourceGroupCostManagementExportExportDataOptions): any;
/**
 * @stability stable
 */
export declare class ResourceGroupCostManagementExportExportDataOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ResourceGroupCostManagementExportExportDataOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ResourceGroupCostManagementExportExportDataOptions | undefined);
    private _timeFrame?;
    /**
     * @stability stable
     */
    get timeFrame(): string;
    /**
     * @stability stable
     */
    set timeFrame(value: string);
    /**
     * @stability stable
     */
    get timeFrameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ResourceGroupCostManagementExportExportDataStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#container_id ResourceGroupCostManagementExport#container_id}.
     *
     * @stability stable
     */
    readonly containerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#root_folder_path ResourceGroupCostManagementExport#root_folder_path}.
     *
     * @stability stable
     */
    readonly rootFolderPath: string;
}
export declare function resourceGroupCostManagementExportExportDataStorageLocationToTerraform(struct?: ResourceGroupCostManagementExportExportDataStorageLocationOutputReference | ResourceGroupCostManagementExportExportDataStorageLocation): any;
/**
 * @stability stable
 */
export declare class ResourceGroupCostManagementExportExportDataStorageLocationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ResourceGroupCostManagementExportExportDataStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ResourceGroupCostManagementExportExportDataStorageLocation | undefined);
    private _containerId?;
    /**
     * @stability stable
     */
    get containerId(): string;
    /**
     * @stability stable
     */
    set containerId(value: string);
    /**
     * @stability stable
     */
    get containerIdInput(): string | undefined;
    private _rootFolderPath?;
    /**
     * @stability stable
     */
    get rootFolderPath(): string;
    /**
     * @stability stable
     */
    set rootFolderPath(value: string);
    /**
     * @stability stable
     */
    get rootFolderPathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ResourceGroupCostManagementExportTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#create ResourceGroupCostManagementExport#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#delete ResourceGroupCostManagementExport#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#read ResourceGroupCostManagementExport#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html#update ResourceGroupCostManagementExport#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function resourceGroupCostManagementExportTimeoutsToTerraform(struct?: ResourceGroupCostManagementExportTimeoutsOutputReference | ResourceGroupCostManagementExportTimeouts): any;
/**
 * @stability stable
 */
export declare class ResourceGroupCostManagementExportTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ResourceGroupCostManagementExportTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ResourceGroupCostManagementExportTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html azurerm_resource_group_cost_management_export}.
 *
 * @stability stable
 */
export declare class ResourceGroupCostManagementExport extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_cost_management_export.html azurerm_resource_group_cost_management_export} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ResourceGroupCostManagementExportConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActive(): void;
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recurrencePeriodEndDate?;
    /**
     * @stability stable
     */
    get recurrencePeriodEndDate(): string;
    /**
     * @stability stable
     */
    set recurrencePeriodEndDate(value: string);
    /**
     * @stability stable
     */
    get recurrencePeriodEndDateInput(): string | undefined;
    private _recurrencePeriodStartDate?;
    /**
     * @stability stable
     */
    get recurrencePeriodStartDate(): string;
    /**
     * @stability stable
     */
    set recurrencePeriodStartDate(value: string);
    /**
     * @stability stable
     */
    get recurrencePeriodStartDateInput(): string | undefined;
    private _recurrenceType?;
    /**
     * @stability stable
     */
    get recurrenceType(): string;
    /**
     * @stability stable
     */
    set recurrenceType(value: string);
    /**
     * @stability stable
     */
    get recurrenceTypeInput(): string | undefined;
    private _resourceGroupId?;
    /**
     * @stability stable
     */
    get resourceGroupId(): string;
    /**
     * @stability stable
     */
    set resourceGroupId(value: string);
    /**
     * @stability stable
     */
    get resourceGroupIdInput(): string | undefined;
    private _exportDataOptions;
    /**
     * @stability stable
     */
    get exportDataOptions(): ResourceGroupCostManagementExportExportDataOptionsOutputReference;
    /**
     * @stability stable
     */
    putExportDataOptions(value: ResourceGroupCostManagementExportExportDataOptions): void;
    /**
     * @stability stable
     */
    get exportDataOptionsInput(): ResourceGroupCostManagementExportExportDataOptions | undefined;
    private _exportDataStorageLocation;
    /**
     * @stability stable
     */
    get exportDataStorageLocation(): ResourceGroupCostManagementExportExportDataStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putExportDataStorageLocation(value: ResourceGroupCostManagementExportExportDataStorageLocation): void;
    /**
     * @stability stable
     */
    get exportDataStorageLocationInput(): ResourceGroupCostManagementExportExportDataStorageLocation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ResourceGroupCostManagementExportTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ResourceGroupCostManagementExportTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ResourceGroupCostManagementExportTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
