import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityCenterAssessmentPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#categories SecurityCenterAssessmentPolicy#categories}.
     *
     * @stability stable
     */
    readonly categories?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#description SecurityCenterAssessmentPolicy#description}.
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#display_name SecurityCenterAssessmentPolicy#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#implementation_effort SecurityCenterAssessmentPolicy#implementation_effort}.
     *
     * @stability stable
     */
    readonly implementationEffort?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#remediation_description SecurityCenterAssessmentPolicy#remediation_description}.
     *
     * @stability stable
     */
    readonly remediationDescription?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#severity SecurityCenterAssessmentPolicy#severity}.
     *
     * @stability stable
     */
    readonly severity?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#threats SecurityCenterAssessmentPolicy#threats}.
     *
     * @stability stable
     */
    readonly threats?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#user_impact SecurityCenterAssessmentPolicy#user_impact}.
     *
     * @stability stable
     */
    readonly userImpact?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#timeouts SecurityCenterAssessmentPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecurityCenterAssessmentPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface SecurityCenterAssessmentPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#create SecurityCenterAssessmentPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#delete SecurityCenterAssessmentPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#read SecurityCenterAssessmentPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html#update SecurityCenterAssessmentPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function securityCenterAssessmentPolicyTimeoutsToTerraform(struct?: SecurityCenterAssessmentPolicyTimeoutsOutputReference | SecurityCenterAssessmentPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class SecurityCenterAssessmentPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecurityCenterAssessmentPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecurityCenterAssessmentPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html azurerm_security_center_assessment_policy}.
 *
 * @stability stable
 */
export declare class SecurityCenterAssessmentPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment_policy.html azurerm_security_center_assessment_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurityCenterAssessmentPolicyConfig);
    private _categories?;
    /**
     * @stability stable
     */
    get categories(): string[];
    /**
     * @stability stable
     */
    set categories(value: string[]);
    /**
     * @stability stable
     */
    resetCategories(): void;
    /**
     * @stability stable
     */
    get categoriesInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _implementationEffort?;
    /**
     * @stability stable
     */
    get implementationEffort(): string;
    /**
     * @stability stable
     */
    set implementationEffort(value: string);
    /**
     * @stability stable
     */
    resetImplementationEffort(): void;
    /**
     * @stability stable
     */
    get implementationEffortInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _remediationDescription?;
    /**
     * @stability stable
     */
    get remediationDescription(): string;
    /**
     * @stability stable
     */
    set remediationDescription(value: string);
    /**
     * @stability stable
     */
    resetRemediationDescription(): void;
    /**
     * @stability stable
     */
    get remediationDescriptionInput(): string | undefined;
    private _severity?;
    /**
     * @stability stable
     */
    get severity(): string;
    /**
     * @stability stable
     */
    set severity(value: string);
    /**
     * @stability stable
     */
    resetSeverity(): void;
    /**
     * @stability stable
     */
    get severityInput(): string | undefined;
    private _threats?;
    /**
     * @stability stable
     */
    get threats(): string[];
    /**
     * @stability stable
     */
    set threats(value: string[]);
    /**
     * @stability stable
     */
    resetThreats(): void;
    /**
     * @stability stable
     */
    get threatsInput(): string[] | undefined;
    private _userImpact?;
    /**
     * @stability stable
     */
    get userImpact(): string;
    /**
     * @stability stable
     */
    set userImpact(value: string);
    /**
     * @stability stable
     */
    resetUserImpact(): void;
    /**
     * @stability stable
     */
    get userImpactInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecurityCenterAssessmentPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecurityCenterAssessmentPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecurityCenterAssessmentPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
