import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityCenterServerVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html#hybrid_machine_id SecurityCenterServerVulnerabilityAssessment#hybrid_machine_id}.
     *
     * @stability stable
     */
    readonly hybridMachineId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html#virtual_machine_id SecurityCenterServerVulnerabilityAssessment#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html#timeouts SecurityCenterServerVulnerabilityAssessment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecurityCenterServerVulnerabilityAssessmentTimeouts;
}
/**
 * @stability stable
 */
export interface SecurityCenterServerVulnerabilityAssessmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html#create SecurityCenterServerVulnerabilityAssessment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html#delete SecurityCenterServerVulnerabilityAssessment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html#read SecurityCenterServerVulnerabilityAssessment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function securityCenterServerVulnerabilityAssessmentTimeoutsToTerraform(struct?: SecurityCenterServerVulnerabilityAssessmentTimeoutsOutputReference | SecurityCenterServerVulnerabilityAssessmentTimeouts): any;
/**
 * @stability stable
 */
export declare class SecurityCenterServerVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecurityCenterServerVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecurityCenterServerVulnerabilityAssessmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html azurerm_security_center_server_vulnerability_assessment}.
 *
 * @stability stable
 */
export declare class SecurityCenterServerVulnerabilityAssessment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_server_vulnerability_assessment.html azurerm_security_center_server_vulnerability_assessment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: SecurityCenterServerVulnerabilityAssessmentConfig);
    private _hybridMachineId?;
    /**
     * @stability stable
     */
    get hybridMachineId(): string;
    /**
     * @stability stable
     */
    set hybridMachineId(value: string);
    /**
     * @stability stable
     */
    resetHybridMachineId(): void;
    /**
     * @stability stable
     */
    get hybridMachineIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _virtualMachineId?;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    /**
     * @stability stable
     */
    set virtualMachineId(value: string);
    /**
     * @stability stable
     */
    resetVirtualMachineId(): void;
    /**
     * @stability stable
     */
    get virtualMachineIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecurityCenterServerVulnerabilityAssessmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecurityCenterServerVulnerabilityAssessmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecurityCenterServerVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
