import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html#log_analytics_workspace_id SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html#name SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html#tenant_id SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html#timeouts SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeouts;
}
/**
 * @stability stable
 */
export interface SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html#create SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html#delete SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html#read SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function sentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeoutsToTerraform(struct?: SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeoutsOutputReference | SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeouts): any;
/**
 * @stability stable
 */
export declare class SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html azurerm_sentinel_data_connector_microsoft_defender_advanced_threat_protection}.
 *
 * @stability stable
 */
export declare class SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_microsoft_defender_advanced_threat_protection.html azurerm_sentinel_data_connector_microsoft_defender_advanced_threat_protection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SentinelDataConnectorMicrosoftDefenderAdvancedThreatProtectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
