import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#backup_service_enabled ServiceFabricManagedCluster#backup_service_enabled}.
     *
     * @stability stable
     */
    readonly backupServiceEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#client_connection_port ServiceFabricManagedCluster#client_connection_port}.
     *
     * @stability stable
     */
    readonly clientConnectionPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#dns_name ServiceFabricManagedCluster#dns_name}.
     *
     * @stability stable
     */
    readonly dnsName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#dns_service_enabled ServiceFabricManagedCluster#dns_service_enabled}.
     *
     * @stability stable
     */
    readonly dnsServiceEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#http_gateway_port ServiceFabricManagedCluster#http_gateway_port}.
     *
     * @stability stable
     */
    readonly httpGatewayPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#location ServiceFabricManagedCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#name ServiceFabricManagedCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#password ServiceFabricManagedCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#resource_group_name ServiceFabricManagedCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#sku ServiceFabricManagedCluster#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#tags ServiceFabricManagedCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#upgrade_wave ServiceFabricManagedCluster#upgrade_wave}.
     *
     * @stability stable
     */
    readonly upgradeWave?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#username ServiceFabricManagedCluster#username}.
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#authentication ServiceFabricManagedCluster#authentication}
     *
     * @stability stable
     */
    readonly authentication?: ServiceFabricManagedClusterAuthentication;
    /**
     * custom_fabric_setting block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#custom_fabric_setting ServiceFabricManagedCluster#custom_fabric_setting}
     *
     * @stability stable
     */
    readonly customFabricSetting?: ServiceFabricManagedClusterCustomFabricSetting[];
    /**
     * lb_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#lb_rule ServiceFabricManagedCluster#lb_rule}
     *
     * @stability stable
     */
    readonly lbRule: ServiceFabricManagedClusterLbRule[];
    /**
     * node_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#node_type ServiceFabricManagedCluster#node_type}
     *
     * @stability stable
     */
    readonly nodeType?: ServiceFabricManagedClusterNodeType[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#timeouts ServiceFabricManagedCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceFabricManagedClusterTimeouts;
}
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterAuthenticationActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#client_application_id ServiceFabricManagedCluster#client_application_id}.
     *
     * @stability stable
     */
    readonly clientApplicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#cluster_application_id ServiceFabricManagedCluster#cluster_application_id}.
     *
     * @stability stable
     */
    readonly clusterApplicationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#tenant_id ServiceFabricManagedCluster#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
}
export declare function serviceFabricManagedClusterAuthenticationActiveDirectoryToTerraform(struct?: ServiceFabricManagedClusterAuthenticationActiveDirectoryOutputReference | ServiceFabricManagedClusterAuthenticationActiveDirectory): any;
/**
 * @stability stable
 */
export declare class ServiceFabricManagedClusterAuthenticationActiveDirectoryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricManagedClusterAuthenticationActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricManagedClusterAuthenticationActiveDirectory | undefined);
    private _clientApplicationId?;
    /**
     * @stability stable
     */
    get clientApplicationId(): string;
    /**
     * @stability stable
     */
    set clientApplicationId(value: string);
    /**
     * @stability stable
     */
    get clientApplicationIdInput(): string | undefined;
    private _clusterApplicationId?;
    /**
     * @stability stable
     */
    get clusterApplicationId(): string;
    /**
     * @stability stable
     */
    set clusterApplicationId(value: string);
    /**
     * @stability stable
     */
    get clusterApplicationIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterAuthenticationCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#common_name ServiceFabricManagedCluster#common_name}.
     *
     * @stability stable
     */
    readonly commonName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#thumbprint ServiceFabricManagedCluster#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#type ServiceFabricManagedCluster#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function serviceFabricManagedClusterAuthenticationCertificateToTerraform(struct?: ServiceFabricManagedClusterAuthenticationCertificate): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterAuthentication {
    /**
     * active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#active_directory ServiceFabricManagedCluster#active_directory}
     *
     * @stability stable
     */
    readonly activeDirectory?: ServiceFabricManagedClusterAuthenticationActiveDirectory;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#certificate ServiceFabricManagedCluster#certificate}
     *
     * @stability stable
     */
    readonly certificate?: ServiceFabricManagedClusterAuthenticationCertificate[];
}
export declare function serviceFabricManagedClusterAuthenticationToTerraform(struct?: ServiceFabricManagedClusterAuthenticationOutputReference | ServiceFabricManagedClusterAuthentication): any;
/**
 * @stability stable
 */
export declare class ServiceFabricManagedClusterAuthenticationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricManagedClusterAuthentication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricManagedClusterAuthentication | undefined);
    private _activeDirectory;
    /**
     * @stability stable
     */
    get activeDirectory(): ServiceFabricManagedClusterAuthenticationActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putActiveDirectory(value: ServiceFabricManagedClusterAuthenticationActiveDirectory): void;
    /**
     * @stability stable
     */
    resetActiveDirectory(): void;
    /**
     * @stability stable
     */
    get activeDirectoryInput(): ServiceFabricManagedClusterAuthenticationActiveDirectory | undefined;
    private _certificate?;
    /**
     * @stability stable
     */
    get certificate(): ServiceFabricManagedClusterAuthenticationCertificate[];
    /**
     * @stability stable
     */
    set certificate(value: ServiceFabricManagedClusterAuthenticationCertificate[]);
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): ServiceFabricManagedClusterAuthenticationCertificate[] | undefined;
}
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterCustomFabricSetting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#parameter ServiceFabricManagedCluster#parameter}.
     *
     * @stability stable
     */
    readonly parameter: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#section ServiceFabricManagedCluster#section}.
     *
     * @stability stable
     */
    readonly section: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#value ServiceFabricManagedCluster#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function serviceFabricManagedClusterCustomFabricSettingToTerraform(struct?: ServiceFabricManagedClusterCustomFabricSetting): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterLbRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#backend_port ServiceFabricManagedCluster#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#frontend_port ServiceFabricManagedCluster#frontend_port}.
     *
     * @stability stable
     */
    readonly frontendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#probe_protocol ServiceFabricManagedCluster#probe_protocol}.
     *
     * @stability stable
     */
    readonly probeProtocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#probe_request_path ServiceFabricManagedCluster#probe_request_path}.
     *
     * @stability stable
     */
    readonly probeRequestPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#protocol ServiceFabricManagedCluster#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function serviceFabricManagedClusterLbRuleToTerraform(struct?: ServiceFabricManagedClusterLbRule): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterNodeTypeVmSecretsCertificates {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#store ServiceFabricManagedCluster#store}.
     *
     * @stability stable
     */
    readonly store: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#url ServiceFabricManagedCluster#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function serviceFabricManagedClusterNodeTypeVmSecretsCertificatesToTerraform(struct?: ServiceFabricManagedClusterNodeTypeVmSecretsCertificates): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterNodeTypeVmSecrets {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vault_id ServiceFabricManagedCluster#vault_id}.
     *
     * @stability stable
     */
    readonly vaultId: string;
    /**
     * certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#certificates ServiceFabricManagedCluster#certificates}
     *
     * @stability stable
     */
    readonly certificates: ServiceFabricManagedClusterNodeTypeVmSecretsCertificates[];
}
export declare function serviceFabricManagedClusterNodeTypeVmSecretsToTerraform(struct?: ServiceFabricManagedClusterNodeTypeVmSecrets): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterNodeType {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#application_port_range ServiceFabricManagedCluster#application_port_range}.
     *
     * @stability stable
     */
    readonly applicationPortRange: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#capacities ServiceFabricManagedCluster#capacities}.
     *
     * @stability stable
     */
    readonly capacities?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#data_disk_size_gb ServiceFabricManagedCluster#data_disk_size_gb}.
     *
     * @stability stable
     */
    readonly dataDiskSizeGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#data_disk_type ServiceFabricManagedCluster#data_disk_type}.
     *
     * @stability stable
     */
    readonly dataDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#ephemeral_port_range ServiceFabricManagedCluster#ephemeral_port_range}.
     *
     * @stability stable
     */
    readonly ephemeralPortRange: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#multiple_placement_groups_enabled ServiceFabricManagedCluster#multiple_placement_groups_enabled}.
     *
     * @stability stable
     */
    readonly multiplePlacementGroupsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#name ServiceFabricManagedCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#placement_properties ServiceFabricManagedCluster#placement_properties}.
     *
     * @stability stable
     */
    readonly placementProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#primary ServiceFabricManagedCluster#primary}.
     *
     * @stability stable
     */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#stateless ServiceFabricManagedCluster#stateless}.
     *
     * @stability stable
     */
    readonly stateless?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vm_image_offer ServiceFabricManagedCluster#vm_image_offer}.
     *
     * @stability stable
     */
    readonly vmImageOffer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vm_image_publisher ServiceFabricManagedCluster#vm_image_publisher}.
     *
     * @stability stable
     */
    readonly vmImagePublisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vm_image_sku ServiceFabricManagedCluster#vm_image_sku}.
     *
     * @stability stable
     */
    readonly vmImageSku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vm_image_version ServiceFabricManagedCluster#vm_image_version}.
     *
     * @stability stable
     */
    readonly vmImageVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vm_instance_count ServiceFabricManagedCluster#vm_instance_count}.
     *
     * @stability stable
     */
    readonly vmInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vm_size ServiceFabricManagedCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * vm_secrets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#vm_secrets ServiceFabricManagedCluster#vm_secrets}
     *
     * @stability stable
     */
    readonly vmSecrets?: ServiceFabricManagedClusterNodeTypeVmSecrets[];
}
export declare function serviceFabricManagedClusterNodeTypeToTerraform(struct?: ServiceFabricManagedClusterNodeType): any;
/**
 * @stability stable
 */
export interface ServiceFabricManagedClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#create ServiceFabricManagedCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#delete ServiceFabricManagedCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#read ServiceFabricManagedCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html#update ServiceFabricManagedCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function serviceFabricManagedClusterTimeoutsToTerraform(struct?: ServiceFabricManagedClusterTimeoutsOutputReference | ServiceFabricManagedClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class ServiceFabricManagedClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServiceFabricManagedClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServiceFabricManagedClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html azurerm_service_fabric_managed_cluster}.
 *
 * @stability stable
 */
export declare class ServiceFabricManagedCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/service_fabric_managed_cluster.html azurerm_service_fabric_managed_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceFabricManagedClusterConfig);
    private _backupServiceEnabled?;
    /**
     * @stability stable
     */
    get backupServiceEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set backupServiceEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBackupServiceEnabled(): void;
    /**
     * @stability stable
     */
    get backupServiceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientConnectionPort?;
    /**
     * @stability stable
     */
    get clientConnectionPort(): number;
    /**
     * @stability stable
     */
    set clientConnectionPort(value: number);
    /**
     * @stability stable
     */
    get clientConnectionPortInput(): number | undefined;
    private _dnsName?;
    /**
     * @stability stable
     */
    get dnsName(): string;
    /**
     * @stability stable
     */
    set dnsName(value: string);
    /**
     * @stability stable
     */
    resetDnsName(): void;
    /**
     * @stability stable
     */
    get dnsNameInput(): string | undefined;
    private _dnsServiceEnabled?;
    /**
     * @stability stable
     */
    get dnsServiceEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dnsServiceEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDnsServiceEnabled(): void;
    /**
     * @stability stable
     */
    get dnsServiceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpGatewayPort?;
    /**
     * @stability stable
     */
    get httpGatewayPort(): number;
    /**
     * @stability stable
     */
    set httpGatewayPort(value: number);
    /**
     * @stability stable
     */
    get httpGatewayPortInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _upgradeWave?;
    /**
     * @stability stable
     */
    get upgradeWave(): string;
    /**
     * @stability stable
     */
    set upgradeWave(value: string);
    /**
     * @stability stable
     */
    resetUpgradeWave(): void;
    /**
     * @stability stable
     */
    get upgradeWaveInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _authentication;
    /**
     * @stability stable
     */
    get authentication(): ServiceFabricManagedClusterAuthenticationOutputReference;
    /**
     * @stability stable
     */
    putAuthentication(value: ServiceFabricManagedClusterAuthentication): void;
    /**
     * @stability stable
     */
    resetAuthentication(): void;
    /**
     * @stability stable
     */
    get authenticationInput(): ServiceFabricManagedClusterAuthentication | undefined;
    private _customFabricSetting?;
    /**
     * @stability stable
     */
    get customFabricSetting(): ServiceFabricManagedClusterCustomFabricSetting[];
    /**
     * @stability stable
     */
    set customFabricSetting(value: ServiceFabricManagedClusterCustomFabricSetting[]);
    /**
     * @stability stable
     */
    resetCustomFabricSetting(): void;
    /**
     * @stability stable
     */
    get customFabricSettingInput(): ServiceFabricManagedClusterCustomFabricSetting[] | undefined;
    private _lbRule?;
    /**
     * @stability stable
     */
    get lbRule(): ServiceFabricManagedClusterLbRule[];
    /**
     * @stability stable
     */
    set lbRule(value: ServiceFabricManagedClusterLbRule[]);
    /**
     * @stability stable
     */
    get lbRuleInput(): ServiceFabricManagedClusterLbRule[] | undefined;
    private _nodeType?;
    /**
     * @stability stable
     */
    get nodeType(): ServiceFabricManagedClusterNodeType[];
    /**
     * @stability stable
     */
    set nodeType(value: ServiceFabricManagedClusterNodeType[]);
    /**
     * @stability stable
     */
    resetNodeType(): void;
    /**
     * @stability stable
     */
    get nodeTypeInput(): ServiceFabricManagedClusterNodeType[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServiceFabricManagedClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServiceFabricManagedClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceFabricManagedClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
