import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBlobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#access_tier StorageBlob#access_tier}.
     *
     * @stability stable
     */
    readonly accessTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#cache_control StorageBlob#cache_control}.
     *
     * @stability stable
     */
    readonly cacheControl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#content_md5 StorageBlob#content_md5}.
     *
     * @stability stable
     */
    readonly contentMd5?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#content_type StorageBlob#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#metadata StorageBlob#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#name StorageBlob#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#parallelism StorageBlob#parallelism}.
     *
     * @stability stable
     */
    readonly parallelism?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#size StorageBlob#size}.
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#source StorageBlob#source}.
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#source_content StorageBlob#source_content}.
     *
     * @stability stable
     */
    readonly sourceContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#source_uri StorageBlob#source_uri}.
     *
     * @stability stable
     */
    readonly sourceUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#storage_account_name StorageBlob#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#storage_container_name StorageBlob#storage_container_name}.
     *
     * @stability stable
     */
    readonly storageContainerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#type StorageBlob#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#timeouts StorageBlob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageBlobTimeouts;
}
/**
 * @stability stable
 */
export interface StorageBlobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#create StorageBlob#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#delete StorageBlob#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#read StorageBlob#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html#update StorageBlob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageBlobTimeoutsToTerraform(struct?: StorageBlobTimeoutsOutputReference | StorageBlobTimeouts): any;
/**
 * @stability stable
 */
export declare class StorageBlobTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBlobTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html azurerm_storage_blob}.
 *
 * @stability stable
 */
export declare class StorageBlob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_blob.html azurerm_storage_blob} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBlobConfig);
    private _accessTier?;
    /**
     * @stability stable
     */
    get accessTier(): string;
    /**
     * @stability stable
     */
    set accessTier(value: string);
    /**
     * @stability stable
     */
    resetAccessTier(): void;
    /**
     * @stability stable
     */
    get accessTierInput(): string | undefined;
    private _cacheControl?;
    /**
     * @stability stable
     */
    get cacheControl(): string;
    /**
     * @stability stable
     */
    set cacheControl(value: string);
    /**
     * @stability stable
     */
    resetCacheControl(): void;
    /**
     * @stability stable
     */
    get cacheControlInput(): string | undefined;
    private _contentMd5?;
    /**
     * @stability stable
     */
    get contentMd5(): string;
    /**
     * @stability stable
     */
    set contentMd5(value: string);
    /**
     * @stability stable
     */
    resetContentMd5(): void;
    /**
     * @stability stable
     */
    get contentMd5Input(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parallelism?;
    /**
     * @stability stable
     */
    get parallelism(): number;
    /**
     * @stability stable
     */
    set parallelism(value: number);
    /**
     * @stability stable
     */
    resetParallelism(): void;
    /**
     * @stability stable
     */
    get parallelismInput(): number | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _sourceContent?;
    /**
     * @stability stable
     */
    get sourceContent(): string;
    /**
     * @stability stable
     */
    set sourceContent(value: string);
    /**
     * @stability stable
     */
    resetSourceContent(): void;
    /**
     * @stability stable
     */
    get sourceContentInput(): string | undefined;
    private _sourceUri?;
    /**
     * @stability stable
     */
    get sourceUri(): string;
    /**
     * @stability stable
     */
    set sourceUri(value: string);
    /**
     * @stability stable
     */
    resetSourceUri(): void;
    /**
     * @stability stable
     */
    get sourceUriInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _storageContainerName?;
    /**
     * @stability stable
     */
    get storageContainerName(): string;
    /**
     * @stability stable
     */
    set storageContainerName(value: string);
    /**
     * @stability stable
     */
    get storageContainerNameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get url(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageBlobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageBlobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageBlobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
