import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputEventhubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#eventhub_name StreamAnalyticsOutputEventhub#eventhub_name}.
     *
     * @stability stable
     */
    readonly eventhubName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#name StreamAnalyticsOutputEventhub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#partition_key StreamAnalyticsOutputEventhub#partition_key}.
     *
     * @stability stable
     */
    readonly partitionKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#property_columns StreamAnalyticsOutputEventhub#property_columns}.
     *
     * @stability stable
     */
    readonly propertyColumns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#resource_group_name StreamAnalyticsOutputEventhub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#servicebus_namespace StreamAnalyticsOutputEventhub#servicebus_namespace}.
     *
     * @stability stable
     */
    readonly servicebusNamespace: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#shared_access_policy_key StreamAnalyticsOutputEventhub#shared_access_policy_key}.
     *
     * @stability stable
     */
    readonly sharedAccessPolicyKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#shared_access_policy_name StreamAnalyticsOutputEventhub#shared_access_policy_name}.
     *
     * @stability stable
     */
    readonly sharedAccessPolicyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#stream_analytics_job_name StreamAnalyticsOutputEventhub#stream_analytics_job_name}.
     *
     * @stability stable
     */
    readonly streamAnalyticsJobName: string;
    /**
     * serialization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#serialization StreamAnalyticsOutputEventhub#serialization}
     *
     * @stability stable
     */
    readonly serialization: StreamAnalyticsOutputEventhubSerialization;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#timeouts StreamAnalyticsOutputEventhub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsOutputEventhubTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputEventhubSerialization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#encoding StreamAnalyticsOutputEventhub#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#field_delimiter StreamAnalyticsOutputEventhub#field_delimiter}.
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#format StreamAnalyticsOutputEventhub#format}.
     *
     * @stability stable
     */
    readonly format?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#type StreamAnalyticsOutputEventhub#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsOutputEventhubSerializationToTerraform(struct?: StreamAnalyticsOutputEventhubSerializationOutputReference | StreamAnalyticsOutputEventhubSerialization): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsOutputEventhubSerializationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsOutputEventhubSerialization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsOutputEventhubSerialization | undefined);
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _format?;
    /**
     * @stability stable
     */
    get format(): string;
    /**
     * @stability stable
     */
    set format(value: string);
    /**
     * @stability stable
     */
    resetFormat(): void;
    /**
     * @stability stable
     */
    get formatInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputEventhubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#create StreamAnalyticsOutputEventhub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#delete StreamAnalyticsOutputEventhub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#read StreamAnalyticsOutputEventhub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html#update StreamAnalyticsOutputEventhub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsOutputEventhubTimeoutsToTerraform(struct?: StreamAnalyticsOutputEventhubTimeoutsOutputReference | StreamAnalyticsOutputEventhubTimeouts): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsOutputEventhubTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsOutputEventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsOutputEventhubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html azurerm_stream_analytics_output_eventhub}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsOutputEventhub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_eventhub.html azurerm_stream_analytics_output_eventhub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputEventhubConfig);
    private _eventhubName?;
    /**
     * @stability stable
     */
    get eventhubName(): string;
    /**
     * @stability stable
     */
    set eventhubName(value: string);
    /**
     * @stability stable
     */
    get eventhubNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _partitionKey?;
    /**
     * @stability stable
     */
    get partitionKey(): string;
    /**
     * @stability stable
     */
    set partitionKey(value: string);
    /**
     * @stability stable
     */
    resetPartitionKey(): void;
    /**
     * @stability stable
     */
    get partitionKeyInput(): string | undefined;
    private _propertyColumns?;
    /**
     * @stability stable
     */
    get propertyColumns(): string[];
    /**
     * @stability stable
     */
    set propertyColumns(value: string[]);
    /**
     * @stability stable
     */
    resetPropertyColumns(): void;
    /**
     * @stability stable
     */
    get propertyColumnsInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _servicebusNamespace?;
    /**
     * @stability stable
     */
    get servicebusNamespace(): string;
    /**
     * @stability stable
     */
    set servicebusNamespace(value: string);
    /**
     * @stability stable
     */
    get servicebusNamespaceInput(): string | undefined;
    private _sharedAccessPolicyKey?;
    /**
     * @stability stable
     */
    get sharedAccessPolicyKey(): string;
    /**
     * @stability stable
     */
    set sharedAccessPolicyKey(value: string);
    /**
     * @stability stable
     */
    get sharedAccessPolicyKeyInput(): string | undefined;
    private _sharedAccessPolicyName?;
    /**
     * @stability stable
     */
    get sharedAccessPolicyName(): string;
    /**
     * @stability stable
     */
    set sharedAccessPolicyName(value: string);
    /**
     * @stability stable
     */
    get sharedAccessPolicyNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    /**
     * @stability stable
     */
    get streamAnalyticsJobName(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsJobName(value: string);
    /**
     * @stability stable
     */
    get streamAnalyticsJobNameInput(): string | undefined;
    private _serialization;
    /**
     * @stability stable
     */
    get serialization(): StreamAnalyticsOutputEventhubSerializationOutputReference;
    /**
     * @stability stable
     */
    putSerialization(value: StreamAnalyticsOutputEventhubSerialization): void;
    /**
     * @stability stable
     */
    get serializationInput(): StreamAnalyticsOutputEventhubSerialization | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsOutputEventhubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsOutputEventhubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsOutputEventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
