import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseSqlPoolSecurityAlertPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#disabled_alerts SynapseSqlPoolSecurityAlertPolicy#disabled_alerts}.
     *
     * @stability stable
     */
    readonly disabledAlerts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#email_account_admins_enabled SynapseSqlPoolSecurityAlertPolicy#email_account_admins_enabled}.
     *
     * @stability stable
     */
    readonly emailAccountAdminsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#email_addresses SynapseSqlPoolSecurityAlertPolicy#email_addresses}.
     *
     * @stability stable
     */
    readonly emailAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#policy_state SynapseSqlPoolSecurityAlertPolicy#policy_state}.
     *
     * @stability stable
     */
    readonly policyState: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#retention_days SynapseSqlPoolSecurityAlertPolicy#retention_days}.
     *
     * @stability stable
     */
    readonly retentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#sql_pool_id SynapseSqlPoolSecurityAlertPolicy#sql_pool_id}.
     *
     * @stability stable
     */
    readonly sqlPoolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#storage_account_access_key SynapseSqlPoolSecurityAlertPolicy#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#storage_endpoint SynapseSqlPoolSecurityAlertPolicy#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#timeouts SynapseSqlPoolSecurityAlertPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseSqlPoolSecurityAlertPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseSqlPoolSecurityAlertPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#create SynapseSqlPoolSecurityAlertPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#delete SynapseSqlPoolSecurityAlertPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#read SynapseSqlPoolSecurityAlertPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html#update SynapseSqlPoolSecurityAlertPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseSqlPoolSecurityAlertPolicyTimeoutsToTerraform(struct?: SynapseSqlPoolSecurityAlertPolicyTimeoutsOutputReference | SynapseSqlPoolSecurityAlertPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseSqlPoolSecurityAlertPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSqlPoolSecurityAlertPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSqlPoolSecurityAlertPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html azurerm_synapse_sql_pool_security_alert_policy}.
 *
 * @stability stable
 */
export declare class SynapseSqlPoolSecurityAlertPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_security_alert_policy.html azurerm_synapse_sql_pool_security_alert_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolSecurityAlertPolicyConfig);
    private _disabledAlerts?;
    /**
     * @stability stable
     */
    get disabledAlerts(): string[];
    /**
     * @stability stable
     */
    set disabledAlerts(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledAlerts(): void;
    /**
     * @stability stable
     */
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdminsEnabled?;
    /**
     * @stability stable
     */
    get emailAccountAdminsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailAccountAdminsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailAccountAdminsEnabled(): void;
    /**
     * @stability stable
     */
    get emailAccountAdminsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _emailAddresses?;
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    set emailAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetEmailAddresses(): void;
    /**
     * @stability stable
     */
    get emailAddressesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyState?;
    /**
     * @stability stable
     */
    get policyState(): string;
    /**
     * @stability stable
     */
    set policyState(value: string);
    /**
     * @stability stable
     */
    get policyStateInput(): string | undefined;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    set retentionDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    private _sqlPoolId?;
    /**
     * @stability stable
     */
    get sqlPoolId(): string;
    /**
     * @stability stable
     */
    set sqlPoolId(value: string);
    /**
     * @stability stable
     */
    get sqlPoolIdInput(): string | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    /**
     * @stability stable
     */
    get storageEndpoint(): string;
    /**
     * @stability stable
     */
    set storageEndpoint(value: string);
    /**
     * @stability stable
     */
    resetStorageEndpoint(): void;
    /**
     * @stability stable
     */
    get storageEndpointInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseSqlPoolSecurityAlertPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseSqlPoolSecurityAlertPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseSqlPoolSecurityAlertPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
