import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseSqlPoolVulnerabilityAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#sql_pool_security_alert_policy_id SynapseSqlPoolVulnerabilityAssessment#sql_pool_security_alert_policy_id}.
     *
     * @stability stable
     */
    readonly sqlPoolSecurityAlertPolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#storage_account_access_key SynapseSqlPoolVulnerabilityAssessment#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#storage_container_path SynapseSqlPoolVulnerabilityAssessment#storage_container_path}.
     *
     * @stability stable
     */
    readonly storageContainerPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#storage_container_sas_key SynapseSqlPoolVulnerabilityAssessment#storage_container_sas_key}.
     *
     * @stability stable
     */
    readonly storageContainerSasKey?: string;
    /**
     * recurring_scans block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#recurring_scans SynapseSqlPoolVulnerabilityAssessment#recurring_scans}
     *
     * @stability stable
     */
    readonly recurringScans?: SynapseSqlPoolVulnerabilityAssessmentRecurringScans;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#timeouts SynapseSqlPoolVulnerabilityAssessment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseSqlPoolVulnerabilityAssessmentTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseSqlPoolVulnerabilityAssessmentRecurringScans {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#email_subscription_admins_enabled SynapseSqlPoolVulnerabilityAssessment#email_subscription_admins_enabled}.
     *
     * @stability stable
     */
    readonly emailSubscriptionAdminsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#emails SynapseSqlPoolVulnerabilityAssessment#emails}.
     *
     * @stability stable
     */
    readonly emails?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#enabled SynapseSqlPoolVulnerabilityAssessment#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function synapseSqlPoolVulnerabilityAssessmentRecurringScansToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference | SynapseSqlPoolVulnerabilityAssessmentRecurringScans): any;
/**
 * @stability stable
 */
export declare class SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentRecurringScans | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentRecurringScans | undefined);
    private _emailSubscriptionAdminsEnabled?;
    /**
     * @stability stable
     */
    get emailSubscriptionAdminsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailSubscriptionAdminsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailSubscriptionAdminsEnabled(): void;
    /**
     * @stability stable
     */
    get emailSubscriptionAdminsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _emails?;
    /**
     * @stability stable
     */
    get emails(): string[];
    /**
     * @stability stable
     */
    set emails(value: string[]);
    /**
     * @stability stable
     */
    resetEmails(): void;
    /**
     * @stability stable
     */
    get emailsInput(): string[] | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SynapseSqlPoolVulnerabilityAssessmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#create SynapseSqlPoolVulnerabilityAssessment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#delete SynapseSqlPoolVulnerabilityAssessment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#read SynapseSqlPoolVulnerabilityAssessment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html#update SynapseSqlPoolVulnerabilityAssessment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseSqlPoolVulnerabilityAssessmentTimeoutsToTerraform(struct?: SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference | SynapseSqlPoolVulnerabilityAssessmentTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSqlPoolVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSqlPoolVulnerabilityAssessmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html azurerm_synapse_sql_pool_vulnerability_assessment}.
 *
 * @stability stable
 */
export declare class SynapseSqlPoolVulnerabilityAssessment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_vulnerability_assessment.html azurerm_synapse_sql_pool_vulnerability_assessment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolVulnerabilityAssessmentConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _sqlPoolSecurityAlertPolicyId?;
    /**
     * @stability stable
     */
    get sqlPoolSecurityAlertPolicyId(): string;
    /**
     * @stability stable
     */
    set sqlPoolSecurityAlertPolicyId(value: string);
    /**
     * @stability stable
     */
    get sqlPoolSecurityAlertPolicyIdInput(): string | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageContainerPath?;
    /**
     * @stability stable
     */
    get storageContainerPath(): string;
    /**
     * @stability stable
     */
    set storageContainerPath(value: string);
    /**
     * @stability stable
     */
    get storageContainerPathInput(): string | undefined;
    private _storageContainerSasKey?;
    /**
     * @stability stable
     */
    get storageContainerSasKey(): string;
    /**
     * @stability stable
     */
    set storageContainerSasKey(value: string);
    /**
     * @stability stable
     */
    resetStorageContainerSasKey(): void;
    /**
     * @stability stable
     */
    get storageContainerSasKeyInput(): string | undefined;
    private _recurringScans;
    /**
     * @stability stable
     */
    get recurringScans(): SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference;
    /**
     * @stability stable
     */
    putRecurringScans(value: SynapseSqlPoolVulnerabilityAssessmentRecurringScans): void;
    /**
     * @stability stable
     */
    resetRecurringScans(): void;
    /**
     * @stability stable
     */
    get recurringScansInput(): SynapseSqlPoolVulnerabilityAssessmentRecurringScans | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseSqlPoolVulnerabilityAssessmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseSqlPoolVulnerabilityAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
