import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualHubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#address_prefix VirtualHub#address_prefix}.
     *
     * @stability stable
     */
    readonly addressPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#location VirtualHub#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#name VirtualHub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#resource_group_name VirtualHub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#sku VirtualHub#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#tags VirtualHub#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#virtual_wan_id VirtualHub#virtual_wan_id}.
     *
     * @stability stable
     */
    readonly virtualWanId?: string;
    /**
     * route block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#route VirtualHub#route}
     *
     * @stability stable
     */
    readonly route?: VirtualHubRoute[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#timeouts VirtualHub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualHubTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualHubRoute {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#address_prefixes VirtualHub#address_prefixes}.
     *
     * @stability stable
     */
    readonly addressPrefixes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#next_hop_ip_address VirtualHub#next_hop_ip_address}.
     *
     * @stability stable
     */
    readonly nextHopIpAddress: string;
}
export declare function virtualHubRouteToTerraform(struct?: VirtualHubRoute): any;
/**
 * @stability stable
 */
export interface VirtualHubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#create VirtualHub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#delete VirtualHub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#read VirtualHub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html#update VirtualHub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualHubTimeoutsToTerraform(struct?: VirtualHubTimeoutsOutputReference | VirtualHubTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualHubTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualHubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualHubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html azurerm_virtual_hub}.
 *
 * @stability stable
 */
export declare class VirtualHub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_hub.html azurerm_virtual_hub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualHubConfig);
    private _addressPrefix?;
    /**
     * @stability stable
     */
    get addressPrefix(): string;
    /**
     * @stability stable
     */
    set addressPrefix(value: string);
    /**
     * @stability stable
     */
    resetAddressPrefix(): void;
    /**
     * @stability stable
     */
    get addressPrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    get defaultRouteTableId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _virtualWanId?;
    /**
     * @stability stable
     */
    get virtualWanId(): string;
    /**
     * @stability stable
     */
    set virtualWanId(value: string);
    /**
     * @stability stable
     */
    resetVirtualWanId(): void;
    /**
     * @stability stable
     */
    get virtualWanIdInput(): string | undefined;
    private _route?;
    /**
     * @stability stable
     */
    get route(): VirtualHubRoute[];
    /**
     * @stability stable
     */
    set route(value: VirtualHubRoute[]);
    /**
     * @stability stable
     */
    resetRoute(): void;
    /**
     * @stability stable
     */
    get routeInput(): VirtualHubRoute[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualHubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualHubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualHubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
