/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMalliSemOsa;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class AlgVormSonaMall
extends SonaMalliSemOsa
implements SonaMall {
    private List<String> algvormid = new ArrayList<String>();
    private List<String> sonaliigid = new ArrayList<String>();

    public AlgVormSonaMall(String algvormiMuster) {
        if (algvormiMuster != null) {
            StringTokenizer tokenizer = new StringTokenizer(algvormiMuster, "|");
            while (tokenizer.hasMoreTokens()) {
                String algv = tokenizer.nextToken();
                if (algv.indexOf("(") > -1) {
                    String sonaliik = algv.substring(algv.indexOf("(") + 1, algv.length() - 1);
                    algv = algv.substring(0, algv.indexOf("("));
                    this.algvormid.add(algv);
                    this.sonaliigid.add(sonaliik);
                    continue;
                }
                this.algvormid.add(algv);
                this.sonaliigid.add("");
            }
        }
    }

    @Override
    public MallileVastavus vastabMallile(AjavtSona sona) {
        if (!this.algvormid.isEmpty() && sona.kasLeidusAnalyys()) {
            for (int i = 0; i < this.algvormid.size(); ++i) {
                String algv = this.algvormid.get(i);
                for (MorfAnRida rida : sona.getAnalyysiTulemused()) {
                    String sonaliik;
                    if (!rida.getLemmaIlmaVahemarkideta().equalsIgnoreCase(algv) || (sonaliik = this.sonaliigid.get(i)).length() != 0 && !rida.getSonaliik().equals(sonaliik)) continue;
                    return MallileVastavus.VASTAB_LOPLIKULT;
                }
            }
        }
        return MallileVastavus.EI_VASTA;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("|");
        for (int i = 0; i < this.algvormid.size(); ++i) {
            builder.append(this.algvormid.get(i));
            if (!this.sonaliigid.isEmpty() && this.sonaliigid.get(i).length() > 0) {
                builder.append("(");
                builder.append(this.sonaliigid.get(i));
                builder.append(")");
            }
            if (i >= this.algvormid.size() - 1) continue;
            builder.append("|");
        }
        builder.append("|");
        return builder.toString();
    }

    @Override
    public SonaMall.TYYP getTyyp() {
        return SonaMall.TYYP.ALGVORM;
    }
}

