/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.impl;

import ee.ut.soras.wrappers.EstyhmmWrapper;
import ee.ut.soras.wrappers.SisendVooLugejaLoim;
import ee.ut.soras.wrappers.erind.EstYhmmErind;
import ee.ut.soras.wrappers.erind.VigaMahisProtsessisErind;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;

public class EstyhmmTempFilesWrapperImpl
implements EstyhmmWrapper {
    private String[] cmds = new String[]{"estyhmmPrc.cmd"};
    private String charset = "UTF-8";
    private File tempDir = new File(".");

    public EstyhmmTempFilesWrapperImpl(String cmd, File tempDir) {
        this.tempDir = tempDir;
        if (cmd != null && cmd.length() > 0) {
            this.cmds = cmd.split("(\\s+)");
        }
    }

    public EstyhmmTempFilesWrapperImpl(String cmd, File tempDir, String encoding) {
        this(cmd, tempDir);
        this.charset = encoding;
    }

    @Override
    public String process(String text) throws Exception {
        File ajutineFail = this.kirjutaTekstAjutisseFaili(text);
        Process p = null;
        ArrayList<String> command = new ArrayList<String>(2);
        for (String cmdName : this.cmds) {
            command.add(cmdName);
        }
        command.add(ajutineFail.getCanonicalPath());
        ProcessBuilder pb = new ProcessBuilder(command);
        p = pb.start();
        SisendVooLugejaLoim stdInLugeja = new SisendVooLugejaLoim(p.getInputStream(), this.charset);
        SisendVooLugejaLoim stdErrLugeja = new SisendVooLugejaLoim(p.getErrorStream(), this.charset);
        stdErrLugeja.start();
        stdInLugeja.start();
        int exitValue = p.waitFor();
        if (!ajutineFail.delete()) {
            throw new VigaMahisProtsessisErind("Ajutise faili " + ajutineFail.getCanonicalPath() + " kustutamine ebaonnestus!");
        }
        if (exitValue != 0) {
            throw new EstYhmmErind(" Estyhmm exitValue: " + exitValue + " !");
        }
        while (stdInLugeja.isAlive() || stdErrLugeja.isAlive()) {
        }
        File estyhmmValjundFail = this.leiaEstyhmmiValjundFail(stdInLugeja.getSisendVooValjund());
        String tulemus = null;
        if (estyhmmValjundFail != null) {
            tulemus = this.votaEstyhmmValjundFailistAnalyysiTulemus(estyhmmValjundFail);
            if (!estyhmmValjundFail.delete()) {
                throw new VigaMahisProtsessisErind("Ajutise faili " + estyhmmValjundFail.getCanonicalPath() + " kustutamine ebaonnestus!");
            }
        } else {
            throw new EstYhmmErind(" V2ljundfailist ei 6nnestunud analyysi tulemust saada! ");
        }
        return tulemus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File kirjutaTekstAjutisseFaili(String tekst) throws Exception {
        File ajutineFail = File.createTempFile("tmp", ".txt", this.tempDir);
        try (BufferedWriter bf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ajutineFail), this.charset));){
            bf.append(tekst);
        }
        return ajutineFail;
    }

    private File leiaEstyhmmiValjundFail(String estyhmmiValjund) throws Exception {
        String[] subParts;
        File estyhmmiValjundFail = null;
        BufferedReader valjund = new BufferedReader(new StringReader(estyhmmiValjund));
        String rida = null;
        StringBuilder sb = new StringBuilder();
        while ((rida = valjund.readLine()) != null) {
            if (rida.length() <= 0) continue;
            sb.append(rida + " ");
        }
        if (sb.toString().indexOf("-->") > -1 && (subParts = sb.toString().split("-->")).length > 1) {
            estyhmmiValjundFail = new File(EstyhmmTempFilesWrapperImpl.trim(subParts[1]));
        }
        return estyhmmiValjundFail;
    }

    private String votaEstyhmmValjundFailistAnalyysiTulemus(File valjundFail) throws IOException {
        StringBuilder soneEhitaja = new StringBuilder();
        BufferedReader phvLugeja = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(valjundFail), this.charset));
        String rida = null;
        while ((rida = phvLugeja.readLine()) != null) {
            soneEhitaja.append(rida).append("\n");
        }
        phvLugeja.close();
        return soneEhitaja.toString();
    }

    private static String trim(String sone) {
        return sone.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
    }
}

